/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal;

import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.springframework.hateoas.LinkRelation;
import org.springframework.lang.NonNull;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;

public class HalConfiguration {
    private static final PathMatcher MATCHER = new AntPathMatcher();
    private final RenderSingleLinks renderSingleLinks;
    private final Map<String, RenderSingleLinks> singleLinksPerPattern;
    private final boolean applyPropertyNamingStrategy;
    private final boolean enforceEmbeddedCollections;

    public HalConfiguration() {
        this.renderSingleLinks = RenderSingleLinks.AS_SINGLE;
        this.singleLinksPerPattern = new LinkedHashMap<String, RenderSingleLinks>();
        this.applyPropertyNamingStrategy = true;
        this.enforceEmbeddedCollections = true;
    }

    public HalConfiguration withRenderSingleLinksFor(LinkRelation relation, RenderSingleLinks renderSingleLinks) {
        Assert.notNull((Object)relation, (String)"Link relation must not be null!");
        Assert.notNull((Object)((Object)renderSingleLinks), (String)"RenderSingleLinks must not be null!");
        return this.withRenderSingleLinksFor(relation.value(), renderSingleLinks);
    }

    public HalConfiguration withRenderSingleLinksFor(String pattern, RenderSingleLinks renderSingleLinks) {
        LinkedHashMap<String, RenderSingleLinks> map = new LinkedHashMap<String, RenderSingleLinks>(this.singleLinksPerPattern);
        map.put(pattern, renderSingleLinks);
        return this.withSingleLinksPerPattern(map);
    }

    RenderSingleLinks getSingleLinkRenderModeFor(LinkRelation relation) {
        return this.singleLinksPerPattern.entrySet().stream().filter(entry -> MATCHER.match((String)entry.getKey(), relation.value())).map(Map.Entry::getValue).findFirst().orElse(this.renderSingleLinks);
    }

    @Generated
    private HalConfiguration(RenderSingleLinks renderSingleLinks, Map<String, RenderSingleLinks> singleLinksPerPattern, boolean applyPropertyNamingStrategy, boolean enforceEmbeddedCollections) {
        this.renderSingleLinks = renderSingleLinks;
        this.singleLinksPerPattern = singleLinksPerPattern;
        this.applyPropertyNamingStrategy = applyPropertyNamingStrategy;
        this.enforceEmbeddedCollections = enforceEmbeddedCollections;
    }

    @NonNull
    @Generated
    public HalConfiguration withRenderSingleLinks(RenderSingleLinks renderSingleLinks) {
        return this.renderSingleLinks == renderSingleLinks ? this : new HalConfiguration(renderSingleLinks, this.singleLinksPerPattern, this.applyPropertyNamingStrategy, this.enforceEmbeddedCollections);
    }

    @Generated
    public RenderSingleLinks getRenderSingleLinks() {
        return this.renderSingleLinks;
    }

    @NonNull
    @Generated
    private HalConfiguration withSingleLinksPerPattern(Map<String, RenderSingleLinks> singleLinksPerPattern) {
        return this.singleLinksPerPattern == singleLinksPerPattern ? this : new HalConfiguration(this.renderSingleLinks, singleLinksPerPattern, this.applyPropertyNamingStrategy, this.enforceEmbeddedCollections);
    }

    @NonNull
    @Generated
    public HalConfiguration withApplyPropertyNamingStrategy(boolean applyPropertyNamingStrategy) {
        return this.applyPropertyNamingStrategy == applyPropertyNamingStrategy ? this : new HalConfiguration(this.renderSingleLinks, this.singleLinksPerPattern, applyPropertyNamingStrategy, this.enforceEmbeddedCollections);
    }

    @Generated
    public boolean isApplyPropertyNamingStrategy() {
        return this.applyPropertyNamingStrategy;
    }

    @NonNull
    @Generated
    public HalConfiguration withEnforceEmbeddedCollections(boolean enforceEmbeddedCollections) {
        return this.enforceEmbeddedCollections == enforceEmbeddedCollections ? this : new HalConfiguration(this.renderSingleLinks, this.singleLinksPerPattern, this.applyPropertyNamingStrategy, enforceEmbeddedCollections);
    }

    @Generated
    public boolean isEnforceEmbeddedCollections() {
        return this.enforceEmbeddedCollections;
    }

    public static enum RenderSingleLinks {
        AS_SINGLE,
        AS_ARRAY;

    }
}

