/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.client;

import java.io.InputStream;
import java.util.Optional;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.Links;
import org.springframework.http.MediaType;
import org.springframework.plugin.core.Plugin;

public interface LinkDiscoverer
extends Plugin<MediaType> {
    public Optional<Link> findLinkWithRel(LinkRelation var1, String var2);

    default public Optional<Link> findLinkWithRel(String rel, String representation) {
        return this.findLinkWithRel(LinkRelation.of(rel), representation);
    }

    default public Link findRequiredLinkWithRel(LinkRelation relation, String representation) {
        return this.findLinkWithRel(relation, representation).orElseThrow(() -> new IllegalArgumentException(String.format("Did not find link with relation '%s'!", relation.value())));
    }

    public Optional<Link> findLinkWithRel(LinkRelation var1, InputStream var2);

    default public Optional<Link> findLinkWithRel(String relation, InputStream representation) {
        return this.findLinkWithRel(LinkRelation.of(relation), representation);
    }

    default public Link findRequiredLinkWithRel(LinkRelation relation, InputStream representation) {
        return this.findLinkWithRel(relation, representation).orElseThrow(() -> new IllegalArgumentException(String.format("Did not find link with relation '%s'!", relation.value())));
    }

    default public Links findLinksWithRel(String relation, String representation) {
        return this.findLinksWithRel(LinkRelation.of(relation), representation);
    }

    public Links findLinksWithRel(LinkRelation var1, String var2);

    default public Links findLinksWithRel(String relation, InputStream representation) {
        return this.findLinksWithRel(LinkRelation.of(relation), representation);
    }

    public Links findLinksWithRel(LinkRelation var1, InputStream var2);
}

