/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.internal.checks.annotationparameters;

import java.util.Collections;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.hibernate.validator.ap.internal.checks.ConstraintCheckIssue;
import org.hibernate.validator.ap.internal.checks.annotationparameters.AnnotationMessageCheck;
import org.hibernate.validator.ap.internal.util.AnnotationApiHelper;
import org.hibernate.validator.ap.internal.util.CollectionHelper;

public class AnnotationDefaultMessageCheck
extends AnnotationMessageCheck {
    private final Elements elementUtils;

    public AnnotationDefaultMessageCheck(AnnotationApiHelper annotationApiHelper, Elements elementUtils) {
        super(annotationApiHelper);
        this.elementUtils = elementUtils;
    }

    @Override
    protected boolean canCheckThisAnnotation(AnnotationMirror annotation) {
        return true;
    }

    @Override
    protected Set<ConstraintCheckIssue> doCheck(Element element, AnnotationMirror annotation) {
        if (ElementKind.ANNOTATION_TYPE.equals((Object)element.getKind())) {
            for (Element element2 : this.elementUtils.getAllMembers((TypeElement)element)) {
                if (!ElementKind.METHOD.equals((Object)element2.getKind()) || !"message".equals(element2.getSimpleName().toString()) || !this.checkMessage(((ExecutableElement)element2).getDefaultValue().getValue().toString())) continue;
                return CollectionHelper.asSet(ConstraintCheckIssue.warning(element2, annotation, "INVALID_MESSAGE_VALUE_ANNOTATION_PARAMETERS", new Object[0]));
            }
        }
        return Collections.emptySet();
    }
}

