/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.spi;

import java.sql.Statement;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.internal.Formatter;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.build.AllowSysOut;
import org.jboss.logging.Logger;

public class SqlStatementLogger {
    private static final Logger LOG = CoreLogging.logger("org.hibernate.SQL");
    private static final Logger LOG_SLOW = CoreLogging.logger("org.hibernate.SQL_SLOW");
    private boolean logToStdout;
    private boolean format;
    private final long logSlowQuery;

    public SqlStatementLogger() {
        this(false, false);
    }

    public SqlStatementLogger(boolean logToStdout, boolean format) {
        this(logToStdout, format, 0L);
    }

    public SqlStatementLogger(boolean logToStdout, boolean format, long logSlowQuery) {
        this.logToStdout = logToStdout;
        this.format = format;
        this.logSlowQuery = logSlowQuery;
    }

    public boolean isLogToStdout() {
        return this.logToStdout;
    }

    @Deprecated
    public void setLogToStdout(boolean logToStdout) {
        this.logToStdout = logToStdout;
    }

    public boolean isFormat() {
        return this.format;
    }

    @Deprecated
    public void setFormat(boolean format) {
        this.format = format;
    }

    public long getLogSlowQuery() {
        return this.logSlowQuery;
    }

    public void logStatement(String statement) {
        this.logStatement(statement, FormatStyle.BASIC.getFormatter());
    }

    @AllowSysOut
    public void logStatement(String statement, Formatter formatter) {
        if (this.format && (this.logToStdout || LOG.isDebugEnabled())) {
            statement = formatter.format(statement);
        }
        LOG.debug((Object)statement);
        if (this.logToStdout) {
            System.out.println("Hibernate: " + statement);
        }
    }

    public void logSlowQuery(Statement statement, long startTime) {
        if (this.logSlowQuery < 1L) {
            return;
        }
        this.logSlowQuery(statement.toString(), startTime);
    }

    @AllowSysOut
    public void logSlowQuery(String sql, long startTime) {
        if (this.logSlowQuery < 1L) {
            return;
        }
        assert (startTime > 0L) : "startTime is invalid!";
        long spent = System.currentTimeMillis() - startTime;
        assert (spent >= 0L) : "startTime is invalid!";
        if (spent > this.logSlowQuery) {
            String logData = "SlowQuery: " + spent + " milliseconds. SQL: '" + sql + "'";
            LOG_SLOW.info((Object)logData);
            if (this.logToStdout) {
                System.out.println(logData);
            }
        }
    }
}

