/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.javac;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.compiler.CompilerResult;
import org.codehaus.plexus.compiler.javac.JavaxToolsCompiler;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class JavacCompiler
extends AbstractCompiler {
    private static final String[] WARNING_PREFIXES = new String[]{"warning: ", "\u8b66\u544a: ", "\u8b66\u544a\uff1a "};
    private static final String[] NOTE_PREFIXES = new String[]{"Note: ", "\u6ce8: ", "\u6ce8\u610f\uff1a "};
    private static final String[] MISC_PREFIXES = new String[]{"["};
    private static final Object LOCK = new Object();
    private static final String JAVAC_CLASSNAME = "com.sun.tools.javac.Main";
    private static volatile Class<?> JAVAC_CLASS;
    private List<Class<?>> javaccClasses = new CopyOnWriteArrayList();

    public JavacCompiler() {
        super(CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE, ".java", ".class", null);
    }

    public CompilerResult performCompile(CompilerConfiguration config) throws CompilerException {
        CompilerResult result;
        String[] sourceFiles;
        File destinationDir = new File(config.getOutputLocation());
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        if ((sourceFiles = JavacCompiler.getSourceFiles((CompilerConfiguration)config)) == null || sourceFiles.length == 0) {
            return new CompilerResult();
        }
        if (this.getLogger() != null && this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Compiling " + sourceFiles.length + " source file" + (sourceFiles.length == 1 ? "" : "s") + " to " + destinationDir.getAbsolutePath());
        }
        String[] args = JavacCompiler.buildCompilerArguments(config, sourceFiles);
        if (config.isFork()) {
            String executable = config.getExecutable();
            if (StringUtils.isEmpty((String)executable)) {
                try {
                    executable = JavacCompiler.getJavacExecutable();
                }
                catch (IOException e) {
                    this.getLogger().warn("Unable to autodetect 'javac' path, using 'javac' from the environment.");
                    executable = "javac";
                }
            }
            result = this.compileOutOfProcess(config, executable, args);
        } else {
            result = JavacCompiler.isJava16() && !config.isForceJavacCompilerUse() ? JavaxToolsCompiler.compileInProcess(args, config, sourceFiles) : this.compileInProcess(args, config);
        }
        return result;
    }

    protected static boolean isJava16() {
        try {
            Thread.currentThread().getContextClassLoader().loadClass("javax.tools.ToolProvider");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String[] createCommandLine(CompilerConfiguration config) throws CompilerException {
        return JavacCompiler.buildCompilerArguments(config, JavacCompiler.getSourceFiles((CompilerConfiguration)config));
    }

    public static String[] buildCompilerArguments(CompilerConfiguration config, String[] sourceFiles) {
        List sourceLocations;
        List modulepathEntries;
        ArrayList<String> args = new ArrayList<String>();
        File destinationDir = new File(config.getOutputLocation());
        args.add("-d");
        args.add(destinationDir.getAbsolutePath());
        List classpathEntries = config.getClasspathEntries();
        if (classpathEntries != null && !classpathEntries.isEmpty()) {
            args.add("-classpath");
            args.add(JavacCompiler.getPathString((List)classpathEntries));
        }
        if ((modulepathEntries = config.getModulepathEntries()) != null && !modulepathEntries.isEmpty()) {
            args.add("--module-path");
            args.add(JavacCompiler.getPathString((List)modulepathEntries));
        }
        if ((sourceLocations = config.getSourceLocations()) != null && !sourceLocations.isEmpty()) {
            args.add("-sourcepath");
            args.add(JavacCompiler.getPathString((List)sourceLocations));
        }
        if (!JavacCompiler.isJava16() || config.isForceJavacCompilerUse() || config.isFork()) {
            args.addAll(Arrays.asList(sourceFiles));
        }
        if (!JavacCompiler.isPreJava16(config)) {
            if (config.getGeneratedSourcesDirectory() != null) {
                config.getGeneratedSourcesDirectory().mkdirs();
                args.add("-s");
                args.add(config.getGeneratedSourcesDirectory().getAbsolutePath());
            }
            if (config.getProc() != null) {
                args.add("-proc:" + config.getProc());
            }
            if (config.getAnnotationProcessors() != null) {
                args.add("-processor");
                String[] procs = config.getAnnotationProcessors();
                StringBuilder buffer = new StringBuilder();
                for (int i = 0; i < procs.length; ++i) {
                    if (i > 0) {
                        buffer.append(",");
                    }
                    buffer.append(procs[i]);
                }
                args.add(buffer.toString());
            }
            if (config.getProcessorPathEntries() != null && !config.getProcessorPathEntries().isEmpty()) {
                args.add("-processorpath");
                args.add(JavacCompiler.getPathString((List)config.getProcessorPathEntries()));
            }
        }
        if (config.isOptimize()) {
            args.add("-O");
        }
        if (config.isDebug()) {
            if (StringUtils.isNotEmpty((String)config.getDebugLevel())) {
                args.add("-g:" + config.getDebugLevel());
            } else {
                args.add("-g");
            }
        }
        if (config.isVerbose()) {
            args.add("-verbose");
        }
        if (!JavacCompiler.isPreJava18(config) && config.isParameters()) {
            args.add("-parameters");
        }
        if (config.isShowDeprecation()) {
            args.add("-deprecation");
            config.setShowWarnings(true);
        }
        if (!config.isShowWarnings()) {
            args.add("-nowarn");
        }
        if (config.isFailOnWarning()) {
            args.add("-Werror");
        }
        if (!StringUtils.isEmpty((String)config.getReleaseVersion())) {
            args.add("--release");
            args.add(config.getReleaseVersion());
        } else {
            if (StringUtils.isEmpty((String)config.getTargetVersion())) {
                args.add("-target");
                args.add("1.1");
            } else {
                args.add("-target");
                args.add(config.getTargetVersion());
            }
            if (!JavacCompiler.suppressSource(config) && StringUtils.isEmpty((String)config.getSourceVersion())) {
                args.add("-source");
                args.add("1.3");
            } else if (!JavacCompiler.suppressSource(config)) {
                args.add("-source");
                args.add(config.getSourceVersion());
            }
        }
        if (!JavacCompiler.suppressEncoding(config) && !StringUtils.isEmpty((String)config.getSourceEncoding())) {
            args.add("-encoding");
            args.add(config.getSourceEncoding());
        }
        if (!StringUtils.isEmpty((String)config.getModuleVersion())) {
            args.add("--module-version");
            args.add(config.getModuleVersion());
        }
        for (Map.Entry entry : config.getCustomCompilerArgumentsEntries()) {
            String key = (String)entry.getKey();
            if (StringUtils.isEmpty((String)key) || key.startsWith("-J")) continue;
            args.add(key);
            String value = (String)entry.getValue();
            if (StringUtils.isEmpty((String)value)) continue;
            args.add(value);
        }
        return args.toArray(new String[args.size()]);
    }

    private static boolean isPreJava14(CompilerConfiguration config) {
        String v = config.getCompilerVersion();
        if (v == null) {
            return false;
        }
        return v.startsWith("1.3") || v.startsWith("1.2") || v.startsWith("1.1") || v.startsWith("1.0");
    }

    private static boolean isPreJava16(CompilerConfiguration config) {
        String v = config.getCompilerVersion();
        if (v == null) {
            String s = config.getSourceVersion();
            if (s == null) {
                return true;
            }
            return s.startsWith("1.5") || s.startsWith("1.4") || s.startsWith("1.3") || s.startsWith("1.2") || s.startsWith("1.1") || s.startsWith("1.0");
        }
        return v.startsWith("1.5") || v.startsWith("1.4") || v.startsWith("1.3") || v.startsWith("1.2") || v.startsWith("1.1") || v.startsWith("1.0");
    }

    private static boolean isPreJava18(CompilerConfiguration config) {
        String v = config.getCompilerVersion();
        if (v == null) {
            v = config.getSourceVersion();
        }
        if (v == null) {
            return true;
        }
        return v.startsWith("1.7") || v.startsWith("1.6") || v.startsWith("1.5") || v.startsWith("1.4") || v.startsWith("1.3") || v.startsWith("1.2") || v.startsWith("1.1") || v.startsWith("1.0");
    }

    private static boolean suppressSource(CompilerConfiguration config) {
        return JavacCompiler.isPreJava14(config);
    }

    private static boolean suppressEncoding(CompilerConfiguration config) {
        return JavacCompiler.isPreJava14(config);
    }

    protected CompilerResult compileOutOfProcess(CompilerConfiguration config, String executable, String[] args) throws CompilerException {
        List<CompilerMessage> messages;
        int returnCode;
        CommandLineUtils.StringStreamConsumer out;
        Commandline cli;
        block12: {
            cli = new Commandline();
            cli.setWorkingDirectory(config.getWorkingDirectory().getAbsolutePath());
            cli.setExecutable(executable);
            try {
                File argumentsFile = this.createFileWithArguments(args, config.getOutputLocation());
                cli.addArguments(new String[]{"@" + argumentsFile.getCanonicalPath().replace(File.separatorChar, '/')});
                if (!StringUtils.isEmpty((String)config.getMaxmem())) {
                    cli.addArguments(new String[]{"-J-Xmx" + config.getMaxmem()});
                }
                if (!StringUtils.isEmpty((String)config.getMeminitial())) {
                    cli.addArguments(new String[]{"-J-Xms" + config.getMeminitial()});
                }
                for (String key : config.getCustomCompilerArgumentsAsMap().keySet()) {
                    if (!StringUtils.isNotEmpty((String)key) || !key.startsWith("-J")) continue;
                    cli.addArguments(new String[]{key});
                }
            }
            catch (IOException e) {
                throw new CompilerException("Error creating file with javac arguments", (Throwable)e);
            }
            out = new CommandLineUtils.StringStreamConsumer();
            if (this.getLogger() != null && this.getLogger().isDebugEnabled()) {
                File commandLineFile = new File(config.getOutputLocation(), "javac." + (Os.isFamily((String)"windows") ? "bat" : "sh"));
                try {
                    FileUtils.fileWrite((String)commandLineFile.getAbsolutePath(), (String)cli.toString().replaceAll("'", ""));
                    if (!Os.isFamily((String)"windows")) {
                        Runtime.getRuntime().exec(new String[]{"chmod", "a+x", commandLineFile.getAbsolutePath()});
                    }
                }
                catch (IOException e) {
                    if (this.getLogger() == null || !this.getLogger().isWarnEnabled()) break block12;
                    this.getLogger().warn("Unable to write '" + commandLineFile.getName() + "' debug script file", (Throwable)e);
                }
            }
        }
        try {
            returnCode = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)out);
            messages = JavacCompiler.parseModernStream(returnCode, new BufferedReader(new StringReader(out.getOutput())));
        }
        catch (CommandLineException e) {
            throw new CompilerException("Error while executing the external compiler.", (Throwable)e);
        }
        catch (IOException e) {
            throw new CompilerException("Error while executing the external compiler.", (Throwable)e);
        }
        boolean success = returnCode == 0;
        return new CompilerResult(success, messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompilerResult compileInProcess(String[] args, CompilerConfiguration config) throws CompilerException {
        Class<?> javacClass = this.getJavacClass(config);
        Thread thread = Thread.currentThread();
        ClassLoader contextClassLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(javacClass.getClassLoader());
        this.getLogger().debug("ttcl changed run compileInProcessWithProperClassloader");
        try {
            CompilerResult compilerResult = this.compileInProcessWithProperClassloader(javacClass, args);
            return compilerResult;
        }
        finally {
            this.releaseJavaccClass(javacClass, config);
            thread.setContextClassLoader(contextClassLoader);
        }
    }

    protected CompilerResult compileInProcessWithProperClassloader(Class<?> javacClass, String[] args) throws CompilerException {
        return JavacCompiler.compileInProcess0(javacClass, args);
    }

    private static CompilerResult compileInProcess0(Class<?> javacClass, String[] args) throws CompilerException {
        List<CompilerMessage> messages;
        Integer ok;
        StringWriter out = new StringWriter();
        try {
            Method compile = javacClass.getMethod("compile", String[].class, PrintWriter.class);
            ok = (Integer)compile.invoke(null, args, new PrintWriter(out));
            messages = JavacCompiler.parseModernStream(ok, new BufferedReader(new StringReader(out.toString())));
        }
        catch (NoSuchMethodException e) {
            throw new CompilerException("Error while executing the compiler.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new CompilerException("Error while executing the compiler.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new CompilerException("Error while executing the compiler.", (Throwable)e);
        }
        catch (IOException e) {
            throw new CompilerException("Error while executing the compiler.", (Throwable)e);
        }
        boolean success = ok == 0;
        return new CompilerResult(success, messages);
    }

    static List<CompilerMessage> parseModernStream(int exitCode, BufferedReader input) throws IOException {
        ArrayList<CompilerMessage> errors = new ArrayList<CompilerMessage>();
        StringBuilder buffer = new StringBuilder();
        boolean hasPointer = false;
        while (true) {
            String line;
            if ((line = input.readLine()) == null) {
                if (buffer.length() > 0 && buffer.toString().startsWith("javac:")) {
                    errors.add(new CompilerMessage(buffer.toString(), CompilerMessage.Kind.ERROR));
                }
                return errors;
            }
            if (line.startsWith("An exception has occurred in the compiler")) {
                buffer = new StringBuilder();
                while (line != null) {
                    buffer.append(line);
                    buffer.append(EOL);
                    line = input.readLine();
                }
                errors.add(new CompilerMessage(buffer.toString(), CompilerMessage.Kind.ERROR));
                return errors;
            }
            if (!line.startsWith(" ") && hasPointer) {
                errors.add(JavacCompiler.parseModernError(exitCode, buffer.toString()));
                buffer = new StringBuilder();
                hasPointer = false;
            }
            if (buffer.length() == 0 && line.startsWith("error: ")) {
                errors.add(new CompilerMessage(line, CompilerMessage.Kind.ERROR));
            } else if (buffer.length() == 0 && line.startsWith("warning: ")) {
                errors.add(new CompilerMessage(line, CompilerMessage.Kind.WARNING));
            } else if (buffer.length() != 0 || !JavacCompiler.isNote(line)) {
                if (buffer.length() == 0 && JavacCompiler.isMisc(line)) {
                    errors.add(new CompilerMessage(line, CompilerMessage.Kind.OTHER));
                } else {
                    buffer.append(line);
                    buffer.append(EOL);
                }
            }
            if (!line.endsWith("^")) continue;
            hasPointer = true;
        }
    }

    private static boolean isMisc(String line) {
        return JavacCompiler.startsWithPrefix(line, MISC_PREFIXES);
    }

    private static boolean isNote(String line) {
        return JavacCompiler.startsWithPrefix(line, NOTE_PREFIXES);
    }

    private static boolean startsWithPrefix(String line, String[] prefixes) {
        for (int i = 0; i < prefixes.length; ++i) {
            if (!line.startsWith(prefixes[i])) continue;
            return true;
        }
        return false;
    }

    static CompilerMessage parseModernError(int exitCode, String error) {
        StringTokenizer tokens = new StringTokenizer(error, ":");
        boolean isError = exitCode != 0;
        try {
            int endcolumn;
            boolean tokenIsAnInteger;
            StringBuilder file = null;
            String currentToken = null;
            do {
                if (currentToken != null) {
                    if (file == null) {
                        file = new StringBuilder(currentToken);
                    } else {
                        file.append(':').append(currentToken);
                    }
                }
                currentToken = tokens.nextToken();
                tokenIsAnInteger = true;
                try {
                    Integer.parseInt(currentToken);
                }
                catch (NumberFormatException e) {
                    tokenIsAnInteger = false;
                }
            } while (!tokenIsAnInteger);
            String lineIndicator = currentToken;
            int startOfFileName = file.toString().lastIndexOf(93);
            if (startOfFileName > -1) {
                file = new StringBuilder(file.substring(startOfFileName + 1 + EOL.length()));
            }
            int line = Integer.parseInt(lineIndicator);
            StringBuilder msgBuffer = new StringBuilder();
            String msg = tokens.nextToken(EOL).substring(2);
            String warnPrefix = JavacCompiler.getWarnPrefix(msg);
            if (warnPrefix != null) {
                isError = false;
                msg = msg.substring(warnPrefix.length());
            } else {
                isError = exitCode != 0;
            }
            msgBuffer.append(msg);
            msgBuffer.append(EOL);
            String context = tokens.nextToken(EOL);
            String pointer = null;
            do {
                String msgLine = tokens.nextToken(EOL);
                if (pointer != null) {
                    msgBuffer.append(msgLine);
                    msgBuffer.append(EOL);
                    continue;
                }
                if (msgLine.endsWith("^")) {
                    pointer = msgLine;
                    continue;
                }
                msgBuffer.append(context);
                msgBuffer.append(EOL);
                context = msgLine;
            } while (tokens.hasMoreTokens());
            msgBuffer.append(EOL);
            String message = msgBuffer.toString();
            int startcolumn = pointer.indexOf("^");
            int n = endcolumn = context == null ? startcolumn : context.indexOf(" ", startcolumn);
            if (endcolumn == -1) {
                endcolumn = context.length();
            }
            return new CompilerMessage(file.toString(), isError, line, startcolumn, line, endcolumn, message.trim());
        }
        catch (NoSuchElementException e) {
            return new CompilerMessage("no more tokens - could not parse error message: " + error, isError);
        }
        catch (NumberFormatException e) {
            return new CompilerMessage("could not parse error message: " + error, isError);
        }
        catch (Exception e) {
            return new CompilerMessage("could not parse error message: " + error, isError);
        }
    }

    private static String getWarnPrefix(String msg) {
        for (int i = 0; i < WARNING_PREFIXES.length; ++i) {
            if (!msg.startsWith(WARNING_PREFIXES[i])) continue;
            return WARNING_PREFIXES[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createFileWithArguments(String[] args, String outputDirectory) throws IOException {
        try (PrintWriter writer = null;){
            File tempFile;
            if (this.getLogger() != null && this.getLogger().isDebugEnabled()) {
                tempFile = File.createTempFile(JavacCompiler.class.getName(), "arguments", new File(outputDirectory));
            } else {
                tempFile = File.createTempFile(JavacCompiler.class.getName(), "arguments");
                tempFile.deleteOnExit();
            }
            writer = new PrintWriter(new FileWriter(tempFile));
            for (int i = 0; i < args.length; ++i) {
                String argValue = args[i].replace(File.separatorChar, '/');
                writer.write("\"" + argValue + "\"");
                writer.println();
            }
            writer.flush();
            File file = tempFile;
            return file;
        }
    }

    private static String getJavacExecutable() throws IOException {
        String javacCommand = "javac" + (Os.isFamily((String)"windows") ? ".exe" : "");
        String javaHome = System.getProperty("java.home");
        File javacExe = Os.isName((String)"AIX") ? new File(javaHome + File.separator + ".." + File.separator + "sh", javacCommand) : (Os.isName((String)"Mac OS X") ? new File(javaHome + File.separator + "bin", javacCommand) : new File(javaHome + File.separator + ".." + File.separator + "bin", javacCommand));
        if (!javacExe.isFile()) {
            Properties env = CommandLineUtils.getSystemEnvVars();
            javaHome = env.getProperty("JAVA_HOME");
            if (StringUtils.isEmpty((String)javaHome)) {
                throw new IOException("The environment variable JAVA_HOME is not correctly set.");
            }
            if (!new File(javaHome).isDirectory()) {
                throw new IOException("The environment variable JAVA_HOME=" + javaHome + " doesn't exist or is not a valid directory.");
            }
            javacExe = new File(env.getProperty("JAVA_HOME") + File.separator + "bin", javacCommand);
        }
        if (!javacExe.isFile()) {
            throw new IOException("The javadoc executable '" + javacExe + "' doesn't exist or is not a file. Verify the JAVA_HOME environment variable.");
        }
        return javacExe.getAbsolutePath();
    }

    private void releaseJavaccClass(Class<?> javaccClass, CompilerConfiguration compilerConfiguration) {
        if (compilerConfiguration.getCompilerReuseStrategy() == CompilerConfiguration.CompilerReuseStrategy.ReuseCreated) {
            this.javaccClasses.add(javaccClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> getJavacClass(CompilerConfiguration compilerConfiguration) throws CompilerException {
        Class<?> c = null;
        switch (compilerConfiguration.getCompilerReuseStrategy()) {
            case AlwaysNew: {
                return this.createJavacClass();
            }
            case ReuseCreated: {
                List<Class<?>> list = this.javaccClasses;
                synchronized (list) {
                    if (this.javaccClasses.size() > 0) {
                        c = this.javaccClasses.get(0);
                        this.javaccClasses.remove(c);
                        return c;
                    }
                }
                c = this.createJavacClass();
                return c;
            }
        }
        c = JAVAC_CLASS;
        if (c != null) {
            return c;
        }
        Object object = LOCK;
        synchronized (object) {
            if (c == null) {
                JAVAC_CLASS = c = this.createJavacClass();
            }
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> createJavacClass() throws CompilerException {
        try {
            return JavacCompiler.class.getClassLoader().loadClass(JAVAC_CLASSNAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            File toolsJar = new File(System.getProperty("java.home"), "../lib/tools.jar");
            if (!toolsJar.exists()) {
                throw new CompilerException("tools.jar not found: " + toolsJar);
            }
            URL[] originalUrls = ((URLClassLoader)JavacCompiler.class.getClassLoader()).getURLs();
            URL[] urls = new URL[originalUrls.length + 1];
            urls[0] = toolsJar.toURI().toURL();
            System.arraycopy(originalUrls, 0, urls, 1, originalUrls.length);
            URLClassLoader javacClassLoader = new URLClassLoader(urls);
            Thread thread = Thread.currentThread();
            ClassLoader contextClassLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(javacClassLoader);
            try {
                Class<?> clazz = javacClassLoader.loadClass(JAVAC_CLASSNAME);
                thread.setContextClassLoader(contextClassLoader);
                return clazz;
            }
            catch (Throwable throwable) {
                try {
                    thread.setContextClassLoader(contextClassLoader);
                    throw throwable;
                }
                catch (MalformedURLException ex) {
                    throw new CompilerException("Could not convert the file reference to tools.jar to a URL, path to tools.jar: '" + toolsJar.getAbsolutePath() + "'.", (Throwable)ex);
                }
                catch (ClassNotFoundException ex) {
                    throw new CompilerException("Unable to locate the Javac Compiler in:" + EOL + "  " + toolsJar + EOL + "Please ensure you are using JDK 1.4 or above and" + EOL + "not a JRE (the com.sun.tools.javac.Main class is required)." + EOL + "In most cases you can change the location of your Java" + EOL + "installation by setting the JAVA_HOME environment variable.", (Throwable)ex);
                }
            }
        }
    }
}

