/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.util.internal.StringUtils;

public final class ConsoleOutputCapture {
    public static void startCapture(ConsoleOutputReceiver target) {
        System.setOut(new ForwardingPrintStream(true, target));
        System.setErr(new ForwardingPrintStream(false, target));
    }

    private static final class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }

    private static final class ForwardingPrintStream
    extends PrintStream {
        private final boolean isStdout;
        private final ConsoleOutputReceiver target;

        ForwardingPrintStream(boolean stdout, ConsoleOutputReceiver target) {
            super(new NullOutputStream());
            this.isStdout = stdout;
            this.target = target;
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            this.target.writeTestOutput(buf, off, len, this.isStdout);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.target.writeTestOutput(b, 0, b.length, this.isStdout);
        }

        @Override
        public void write(int b) {
            try {
                this.write(new byte[]{(byte)b});
            }
            catch (IOException e) {
                this.setError();
            }
        }

        @Override
        public void println(String s) {
            if (s == null) {
                s = "null";
            }
            byte[] bytes = (s + StringUtils.NL).getBytes();
            this.target.writeTestOutput(bytes, 0, bytes.length, this.isStdout);
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }
    }
}

