/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.surefire.report.ReportEntryType;
import org.apache.maven.plugin.surefire.report.Utf8RecodingDeferredFileOutputStream;
import org.apache.maven.surefire.api.report.ReportEntry;
import org.apache.maven.surefire.api.report.RunMode;
import org.apache.maven.surefire.api.report.StackTraceWriter;
import org.apache.maven.surefire.api.report.TestSetReportEntry;
import org.apache.maven.surefire.api.util.internal.StringUtils;

public class WrappedReportEntry
implements TestSetReportEntry {
    private static final float ONE_SECOND = 1000.0f;
    private final ReportEntry original;
    private final ReportEntryType reportEntryType;
    private final Integer elapsed;
    private final Utf8RecodingDeferredFileOutputStream stdout;
    private final Utf8RecodingDeferredFileOutputStream stdErr;
    private final Map<String, String> systemProperties;
    private final MessageFormat elapsedTimeFormat = new MessageFormat("{0,choice,0#0|0.0<{0,number,0.000}|10#{0,number,0.00}|100#{0,number,0.0}|1000#{0,number,0}} s", Locale.ROOT);

    public WrappedReportEntry(ReportEntry original, ReportEntryType reportEntryType, Integer estimatedElapsed, Utf8RecodingDeferredFileOutputStream stdout, Utf8RecodingDeferredFileOutputStream stdErr, Map<String, String> systemProperties) {
        this.original = original;
        this.reportEntryType = reportEntryType;
        this.elapsed = estimatedElapsed;
        this.stdout = stdout;
        this.stdErr = stdErr;
        this.systemProperties = Collections.unmodifiableMap(systemProperties);
    }

    public WrappedReportEntry(ReportEntry original, ReportEntryType reportEntryType, Integer estimatedElapsed, Utf8RecodingDeferredFileOutputStream stdout, Utf8RecodingDeferredFileOutputStream stdErr) {
        this(original, reportEntryType, estimatedElapsed, stdout, stdErr, Collections.emptyMap());
    }

    public Integer getElapsed() {
        return this.elapsed;
    }

    public int getElapsed(int fallback) {
        return this.elapsed == null ? fallback : this.elapsed;
    }

    public ReportEntryType getReportEntryType() {
        return this.reportEntryType;
    }

    public Utf8RecodingDeferredFileOutputStream getStdout() {
        return this.stdout;
    }

    public Utf8RecodingDeferredFileOutputStream getStdErr() {
        return this.stdErr;
    }

    public String getSourceName() {
        return this.original.getSourceName();
    }

    public String getSourceText() {
        return this.original.getSourceText();
    }

    public String getName() {
        return this.original.getName();
    }

    public String getNameText() {
        return this.original.getNameText();
    }

    public String getClassMethodName() {
        return this.original.getSourceName() + "." + this.original.getName();
    }

    public String getGroup() {
        return this.original.getGroup();
    }

    public StackTraceWriter getStackTraceWriter() {
        return this.original.getStackTraceWriter();
    }

    public String getMessage() {
        return this.original.getMessage();
    }

    public String getStackTrace(boolean trimStackTrace) {
        StackTraceWriter w = this.original.getStackTraceWriter();
        return w == null ? null : (trimStackTrace ? w.writeTrimmedTraceToString() : w.writeTraceToString());
    }

    public String elapsedTimeAsString() {
        return this.getElapsed() != null ? this.elapsedTimeFormat.format(new Object[]{Float.valueOf((float)this.getElapsed().intValue() / 1000.0f)}) : null;
    }

    String getReportSourceName() {
        String sourceName = this.getSourceName();
        String sourceText = this.getSourceText();
        return org.apache.maven.surefire.shared.utils.StringUtils.isBlank((String)sourceText) ? sourceName : sourceText;
    }

    String getReportSourceName(String suffix) {
        return org.apache.maven.surefire.shared.utils.StringUtils.isBlank((String)suffix) ? this.getReportSourceName() : this.getReportSourceName() + "(" + suffix + ")";
    }

    String getSourceName(String suffix) {
        return org.apache.maven.surefire.shared.utils.StringUtils.isBlank((String)suffix) ? this.getSourceName() : this.getSourceName() + "(" + suffix + ")";
    }

    String getReportName() {
        String name = this.getName();
        String nameText = this.getNameText();
        return org.apache.maven.surefire.shared.utils.StringUtils.isBlank((String)nameText) ? name : nameText;
    }

    public String getOutput(boolean trimStackTrace) {
        String outputLine = this.getElapsedTimeSummary() + " <<< " + this.getReportEntryType().name() + "!";
        String trimmedStackTrace = this.getStackTrace(trimStackTrace);
        return trimmedStackTrace == null ? outputLine : outputLine + StringUtils.NL + trimmedStackTrace;
    }

    public String getElapsedTimeVerbose() {
        return "Time elapsed: " + (this.getElapsed() != null ? this.elapsedTimeAsString() : "(unknown)");
    }

    public String getElapsedTimeSummary() {
        String description = this.getName() == null ? this.getSourceName() : this.getClassMethodName();
        return description + " -- " + this.getElapsedTimeVerbose();
    }

    public boolean isErrorOrFailure() {
        ReportEntryType thisType = this.getReportEntryType();
        return ReportEntryType.FAILURE == thisType || ReportEntryType.ERROR == thisType;
    }

    public boolean isSkipped() {
        return ReportEntryType.SKIPPED == this.getReportEntryType();
    }

    public boolean isSucceeded() {
        return ReportEntryType.SUCCESS == this.getReportEntryType();
    }

    public String getNameWithGroup() {
        return this.original.getNameWithGroup();
    }

    public String getReportNameWithGroup() {
        String reportNameWithGroup = this.original.getReportNameWithGroup();
        if (org.apache.maven.surefire.shared.utils.StringUtils.isBlank((String)reportNameWithGroup)) {
            return this.getNameWithGroup();
        }
        return reportNameWithGroup;
    }

    @Nonnull
    public RunMode getRunMode() {
        return this.original.getRunMode();
    }

    public Long getTestRunId() {
        return this.original.getTestRunId();
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }
}

