/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.versions;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.shared.release.versions.AetherVersion;
import org.apache.maven.shared.release.versions.MavenArtifactVersion;
import org.apache.maven.shared.release.versions.VersionComparisonConflictException;
import org.apache.maven.shared.release.versions.VersionParseException;
import org.codehaus.plexus.util.StringUtils;

public class Version
implements Comparable<Version> {
    private final AetherVersion aetherVersion;
    private final MavenArtifactVersion mavenArtifactVersion;
    private final String strVersion;
    private final List<String> digits;
    private String annotation;
    private String annotationRevision;
    private final String buildSpecifier;
    private String annotationSeparator;
    private String annotationRevSeparator;
    private final String buildSeparator;
    private static final int DIGITS_INDEX = 1;
    private static final int ANNOTATION_SEPARATOR_INDEX = 2;
    private static final int ANNOTATION_INDEX = 3;
    private static final int ANNOTATION_REV_SEPARATOR_INDEX = 4;
    private static final int ANNOTATION_REVISION_INDEX = 5;
    private static final int BUILD_SEPARATOR_INDEX = 6;
    private static final int BUILD_SPECIFIER_INDEX = 7;
    private static final String SNAPSHOT_IDENTIFIER = "SNAPSHOT";
    private static final String DIGIT_SEPARATOR_STRING = ".";
    public static final Pattern STANDARD_PATTERN = Pattern.compile("^((?:\\d+\\.)*\\d+)([-_])?([a-zA-Z]*)([-_])?(\\d*)(?:([-_])?(.*?))?$");
    public static final Pattern ALTERNATE_PATTERN = Pattern.compile("^(SNAPSHOT|[a-zA-Z]+[_-]SNAPSHOT)");

    public Version(String version) throws VersionParseException {
        this.strVersion = version;
        this.aetherVersion = new AetherVersion(version);
        this.mavenArtifactVersion = new MavenArtifactVersion(version);
        Matcher matcher = ALTERNATE_PATTERN.matcher(this.strVersion);
        if (matcher.matches()) {
            this.annotation = null;
            this.digits = null;
            this.buildSpecifier = version;
            this.buildSeparator = null;
            return;
        }
        Matcher m = STANDARD_PATTERN.matcher(this.strVersion);
        if (m.matches()) {
            this.digits = this.parseDigits(m.group(1));
            if (!SNAPSHOT_IDENTIFIER.equals(m.group(3))) {
                this.annotationSeparator = m.group(2);
                this.annotation = Version.nullIfEmpty(m.group(3));
                if (StringUtils.isNotEmpty((String)m.group(4)) && StringUtils.isEmpty((String)m.group(5))) {
                    this.buildSeparator = m.group(4);
                    this.buildSpecifier = Version.nullIfEmpty(m.group(7));
                } else {
                    this.annotationRevSeparator = m.group(4);
                    this.annotationRevision = Version.nullIfEmpty(m.group(5));
                    this.buildSeparator = m.group(6);
                    this.buildSpecifier = Version.nullIfEmpty(m.group(7));
                }
            } else {
                this.buildSeparator = m.group(2);
                this.buildSpecifier = Version.nullIfEmpty(m.group(3));
            }
        } else {
            throw new VersionParseException("Unable to parse the version string: \"" + version + "\"");
        }
    }

    public boolean isSnapshot() {
        return ArtifactUtils.isSnapshot((String)this.strVersion);
    }

    public String toString() {
        return this.strVersion;
    }

    protected static String getVersionString(Version info, String buildSpecifier, String buildSeparator) {
        StringBuilder sb = new StringBuilder();
        if (info.digits != null) {
            sb.append(Version.joinDigitString(info.digits));
        }
        if (StringUtils.isNotEmpty((String)info.annotation)) {
            sb.append(StringUtils.defaultString((Object)info.annotationSeparator));
            sb.append(info.annotation);
        }
        if (StringUtils.isNotEmpty((String)info.annotationRevision)) {
            if (StringUtils.isEmpty((String)info.annotation)) {
                sb.append(StringUtils.defaultString((Object)info.annotationSeparator));
            } else {
                sb.append(StringUtils.defaultString((Object)info.annotationRevSeparator));
            }
            sb.append(info.annotationRevision);
        }
        if (StringUtils.isNotEmpty((String)buildSpecifier)) {
            sb.append(StringUtils.defaultString((Object)buildSeparator));
            sb.append(buildSpecifier);
        }
        return sb.toString();
    }

    protected static String joinDigitString(List<String> digits) {
        return digits != null ? StringUtils.join(digits.iterator(), (String)DIGIT_SEPARATOR_STRING) : null;
    }

    private List<String> parseDigits(String strDigits) {
        return Arrays.asList(StringUtils.split((String)strDigits, (String)DIGIT_SEPARATOR_STRING));
    }

    private static String nullIfEmpty(String s) {
        return StringUtils.isEmpty((String)s) ? null : s;
    }

    public List<String> getDigits() {
        return this.digits;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public String getAnnotationRevSeparator() {
        return this.annotationRevSeparator;
    }

    public String getAnnotationRevision() {
        return this.annotationRevision;
    }

    public String getBuildSeparator() {
        return this.buildSeparator;
    }

    public String getBuildSpecifier() {
        return this.buildSpecifier;
    }

    @Override
    public int compareTo(Version other) throws VersionComparisonConflictException {
        int aetherComparisonResult = this.aetherVersion.compareTo(other.aetherVersion);
        int mavenComparisonResult = this.mavenArtifactVersion.compareTo(other.mavenArtifactVersion);
        if (aetherComparisonResult < 0 && mavenComparisonResult < 0) {
            return -1;
        }
        if (aetherComparisonResult == 0 && mavenComparisonResult == 0) {
            return 0;
        }
        if (aetherComparisonResult > 0 && mavenComparisonResult > 0) {
            return 1;
        }
        throw new VersionComparisonConflictException(this.strVersion, other.strVersion, aetherComparisonResult, mavenComparisonResult);
    }
}

