/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.emoji.internal;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class EmojiCheatSheet {
    public static final HashMap<String, EmojiShortcut> shortCutMap = new HashMap();
    public static final HashMap<String, EmojiShortcut> fileMap = new HashMap();
    public static final HashMap<String, EmojiShortcut> gitHubUrlMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wantFileUrlMaps() {
        HashMap<String, EmojiShortcut> hashMap = fileMap;
        synchronized (hashMap) {
            if (fileMap.isEmpty()) {
                for (Map.Entry<String, EmojiShortcut> entry : shortCutMap.entrySet()) {
                    if (!fileMap.containsKey(entry.getValue().image)) {
                        fileMap.put(entry.getValue().image, entry.getValue());
                    }
                    if (entry.getValue().url == null || gitHubUrlMap.containsKey(entry.getValue().url)) continue;
                    gitHubUrlMap.put(entry.getValue().url, entry.getValue());
                }
            }
        }
    }

    public static EmojiShortcut getImageShortcut(String imageURI) {
        EmojiCheatSheet.wantFileUrlMaps();
        EmojiShortcut shortcut = gitHubUrlMap.get(imageURI);
        if (shortcut == null) {
            String fileName = new File(imageURI).getName();
            shortcut = fileMap.get(fileName);
        }
        return shortcut;
    }

    static {
        shortCutMap.put("+1", new EmojiShortcut("+1", "plus1.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f44d.png", "people"));
        shortCutMap.put("-1", new EmojiShortcut("-1", "-1.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f44e.png", "people"));
        shortCutMap.put("8ball", new EmojiShortcut("8ball", "8ball.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3b1.png", "objects"));
        shortCutMap.put("100", new EmojiShortcut("100", "100.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4af.png", "symbols"));
        shortCutMap.put("1234", new EmojiShortcut("1234", "1234.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f522.png", "symbols"));
        shortCutMap.put("a", new EmojiShortcut("a", "a.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f170.png", "symbols"));
        shortCutMap.put("ab", new EmojiShortcut("ab", "ab.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f18e.png", "symbols"));
        shortCutMap.put("abc", new EmojiShortcut("abc", "abc.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f524.png", "symbols"));
        shortCutMap.put("abcd", new EmojiShortcut("abcd", "abcd.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f521.png", "symbols"));
        shortCutMap.put("accept", new EmojiShortcut("accept", "accept.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f251.png", "symbols"));
        shortCutMap.put("aerial_tramway", new EmojiShortcut("aerial_tramway", "aerial_tramway.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6a1.png", "places"));
        shortCutMap.put("airplane", new EmojiShortcut("airplane", "airplane.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2708.png", "places"));
        shortCutMap.put("alarm_clock", new EmojiShortcut("alarm_clock", "alarm_clock.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/23f0.png", "objects"));
        shortCutMap.put("alien", new EmojiShortcut("alien", "alien.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f47d.png", "people"));
        shortCutMap.put("ambulance", new EmojiShortcut("ambulance", "ambulance.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f691.png", "places"));
        shortCutMap.put("anchor", new EmojiShortcut("anchor", "anchor.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2693.png", "places"));
        shortCutMap.put("angel", new EmojiShortcut("angel", "angel.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f47c.png", "people"));
        shortCutMap.put("anger", new EmojiShortcut("anger", "anger.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4a2.png", "people"));
        shortCutMap.put("angry", new EmojiShortcut("angry", "angry.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f620.png", "people"));
        shortCutMap.put("anguished", new EmojiShortcut("anguished", "anguished.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f627.png", "people"));
        shortCutMap.put("ant", new EmojiShortcut("ant", "ant.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f41c.png", "nature"));
        shortCutMap.put("apple", new EmojiShortcut("apple", "apple.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f34e.png", "objects"));
        shortCutMap.put("aquarius", new EmojiShortcut("aquarius", "aquarius.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2652.png", "symbols"));
        shortCutMap.put("aries", new EmojiShortcut("aries", "aries.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2648.png", "symbols"));
        shortCutMap.put("arrow_backward", new EmojiShortcut("arrow_backward", "arrow_backward.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/25c0.png", "symbols"));
        shortCutMap.put("arrow_double_down", new EmojiShortcut("arrow_double_down", "arrow_double_down.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/23ec.png", "symbols"));
        shortCutMap.put("arrow_double_up", new EmojiShortcut("arrow_double_up", "arrow_double_up.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/23eb.png", "symbols"));
        shortCutMap.put("arrow_down", new EmojiShortcut("arrow_down", "arrow_down.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2b07.png", "symbols"));
        shortCutMap.put("arrow_down_small", new EmojiShortcut("arrow_down_small", "arrow_down_small.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f53d.png", "symbols"));
        shortCutMap.put("arrow_forward", new EmojiShortcut("arrow_forward", "arrow_forward.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/25b6.png", "symbols"));
        shortCutMap.put("arrow_heading_down", new EmojiShortcut("arrow_heading_down", "arrow_heading_down.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2935.png", "symbols"));
        shortCutMap.put("arrow_heading_up", new EmojiShortcut("arrow_heading_up", "arrow_heading_up.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2934.png", "symbols"));
        shortCutMap.put("arrow_left", new EmojiShortcut("arrow_left", "arrow_left.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2b05.png", "symbols"));
        shortCutMap.put("arrow_lower_left", new EmojiShortcut("arrow_lower_left", "arrow_lower_left.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2199.png", "symbols"));
        shortCutMap.put("arrow_lower_right", new EmojiShortcut("arrow_lower_right", "arrow_lower_right.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2198.png", "symbols"));
        shortCutMap.put("arrow_right", new EmojiShortcut("arrow_right", "arrow_right.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/27a1.png", "symbols"));
        shortCutMap.put("arrow_right_hook", new EmojiShortcut("arrow_right_hook", "arrow_right_hook.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/21aa.png", "symbols"));
        shortCutMap.put("arrow_up", new EmojiShortcut("arrow_up", "arrow_up.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2b06.png", "symbols"));
        shortCutMap.put("arrow_up_down", new EmojiShortcut("arrow_up_down", "arrow_up_down.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2195.png", "symbols"));
        shortCutMap.put("arrow_up_small", new EmojiShortcut("arrow_up_small", "arrow_up_small.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f53c.png", "symbols"));
        shortCutMap.put("arrow_upper_left", new EmojiShortcut("arrow_upper_left", "arrow_upper_left.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2196.png", "symbols"));
        shortCutMap.put("arrow_upper_right", new EmojiShortcut("arrow_upper_right", "arrow_upper_right.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2197.png", "symbols"));
        shortCutMap.put("arrows_clockwise", new EmojiShortcut("arrows_clockwise", "arrows_clockwise.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f503.png", "symbols"));
        shortCutMap.put("arrows_counterclockwise", new EmojiShortcut("arrows_counterclockwise", "arrows_counterclockwise.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f504.png", "symbols"));
        shortCutMap.put("art", new EmojiShortcut("art", "art.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3a8.png", "objects"));
        shortCutMap.put("articulated_lorry", new EmojiShortcut("articulated_lorry", "articulated_lorry.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f69b.png", "places"));
        shortCutMap.put("astonished", new EmojiShortcut("astonished", "astonished.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f632.png", "people"));
        shortCutMap.put("atm", new EmojiShortcut("atm", "atm.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3e7.png", "places"));
        shortCutMap.put("b", new EmojiShortcut("b", "b.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f171.png", "symbols"));
        shortCutMap.put("baby", new EmojiShortcut("baby", "baby.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f476.png", "people"));
        shortCutMap.put("baby_bottle", new EmojiShortcut("baby_bottle", "baby_bottle.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f37c.png", "objects"));
        shortCutMap.put("baby_chick", new EmojiShortcut("baby_chick", "baby_chick.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f424.png", "nature"));
        shortCutMap.put("baby_symbol", new EmojiShortcut("baby_symbol", "baby_symbol.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6bc.png", "symbols"));
        shortCutMap.put("back", new EmojiShortcut("back", "back.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f519.png", "symbols"));
        shortCutMap.put("baggage_claim", new EmojiShortcut("baggage_claim", "baggage_claim.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6c4.png", "symbols"));
        shortCutMap.put("balloon", new EmojiShortcut("balloon", "balloon.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f388.png", "objects"));
        shortCutMap.put("ballot_box_with_check", new EmojiShortcut("ballot_box_with_check", "ballot_box_with_check.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2611.png", "symbols"));
        shortCutMap.put("bamboo", new EmojiShortcut("bamboo", "bamboo.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f38d.png", "objects"));
        shortCutMap.put("banana", new EmojiShortcut("banana", "banana.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f34c.png", "objects"));
        shortCutMap.put("bangbang", new EmojiShortcut("bangbang", "bangbang.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/203c.png", "symbols"));
        shortCutMap.put("bank", new EmojiShortcut("bank", "bank.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3e6.png", "places"));
        shortCutMap.put("bar_chart", new EmojiShortcut("bar_chart", "bar_chart.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4ca.png", "objects"));
        shortCutMap.put("barber", new EmojiShortcut("barber", "barber.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f488.png", "places"));
        shortCutMap.put("baseball", new EmojiShortcut("baseball", "baseball.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/26be.png", "objects"));
        shortCutMap.put("basketball", new EmojiShortcut("basketball", "basketball.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3c0.png", "objects"));
        shortCutMap.put("bath", new EmojiShortcut("bath", "bath.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6c0.png", "objects"));
        shortCutMap.put("bathtub", new EmojiShortcut("bathtub", "bathtub.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6c1.png", "objects"));
        shortCutMap.put("battery", new EmojiShortcut("battery", "battery.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f50b.png", "objects"));
        shortCutMap.put("bear", new EmojiShortcut("bear", "bear.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f43b.png", "nature"));
        shortCutMap.put("beer", new EmojiShortcut("beer", "beer.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f37a.png", "objects"));
        shortCutMap.put("beers", new EmojiShortcut("beers", "beers.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f37b.png", "objects"));
        shortCutMap.put("beetle", new EmojiShortcut("beetle", "beetle.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f41e.png", "nature"));
        shortCutMap.put("beginner", new EmojiShortcut("beginner", "beginner.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f530.png", "places"));
        shortCutMap.put("bell", new EmojiShortcut("bell", "bell.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f514.png", "objects"));
        shortCutMap.put("bento", new EmojiShortcut("bento", "bento.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f371.png", "objects"));
        shortCutMap.put("bicyclist", new EmojiShortcut("bicyclist", "bicyclist.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6b4.png", "objects"));
        shortCutMap.put("bike", new EmojiShortcut("bike", "bike.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6b2.png", "places"));
        shortCutMap.put("bikini", new EmojiShortcut("bikini", "bikini.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f459.png", "objects"));
        shortCutMap.put("bird", new EmojiShortcut("bird", "bird.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f426.png", "nature"));
        shortCutMap.put("birthday", new EmojiShortcut("birthday", "birthday.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f382.png", "objects"));
        shortCutMap.put("black_circle", new EmojiShortcut("black_circle", "black_circle.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/26ab.png", "symbols"));
        shortCutMap.put("black_joker", new EmojiShortcut("black_joker", "black_joker.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f0cf.png", "objects"));
        shortCutMap.put("black_large_square", new EmojiShortcut("black_large_square", "black_square.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2b1b.png", "symbols"));
        shortCutMap.put("black_medium_small_square", new EmojiShortcut("black_medium_small_square", "black_medium_small_square.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/25fe.png", "symbols"));
        shortCutMap.put("black_medium_square", new EmojiShortcut("black_medium_square", "black_medium_square.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/25fc.png", "symbols"));
        shortCutMap.put("black_nib", new EmojiShortcut("black_nib", "black_nib.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2712.png", "objects"));
        shortCutMap.put("black_small_square", new EmojiShortcut("black_small_square", "black_small_square.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/25aa.png", "symbols"));
        shortCutMap.put("black_square_button", new EmojiShortcut("black_square_button", "black_square_button.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f532.png", "symbols"));
        shortCutMap.put("blossom", new EmojiShortcut("blossom", "blossom.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f33c.png", "nature"));
        shortCutMap.put("blowfish", new EmojiShortcut("blowfish", "blowfish.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f421.png", "nature"));
        shortCutMap.put("blue_book", new EmojiShortcut("blue_book", "blue_book.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4d8.png", "objects"));
        shortCutMap.put("blue_car", new EmojiShortcut("blue_car", "blue_car.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f699.png", "places"));
        shortCutMap.put("blue_heart", new EmojiShortcut("blue_heart", "blue_heart.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f499.png", "people"));
        shortCutMap.put("blush", new EmojiShortcut("blush", "blush.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f60a.png", "people"));
        shortCutMap.put("boar", new EmojiShortcut("boar", "boar.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f417.png", "nature"));
        shortCutMap.put("boat", new EmojiShortcut("boat", "boat.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/26f5.png", "places"));
        shortCutMap.put("bomb", new EmojiShortcut("bomb", "bomb.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4a3.png", "objects"));
        shortCutMap.put("book", new EmojiShortcut("book", "book.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4d6.png", "objects"));
        shortCutMap.put("bookmark", new EmojiShortcut("bookmark", "bookmark.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f516.png", "objects"));
        shortCutMap.put("bookmark_tabs", new EmojiShortcut("bookmark_tabs", "bookmark_tabs.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4d1.png", "objects"));
        shortCutMap.put("books", new EmojiShortcut("books", "books.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4da.png", "objects"));
        shortCutMap.put("boom", new EmojiShortcut("boom", "boom.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4a5.png", "people"));
        shortCutMap.put("boot", new EmojiShortcut("boot", "boot.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f462.png", "objects"));
        shortCutMap.put("bouquet", new EmojiShortcut("bouquet", "bouquet.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f490.png", "nature"));
        shortCutMap.put("bow", new EmojiShortcut("bow", "bow.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f647.png", "people"));
        shortCutMap.put("bowling", new EmojiShortcut("bowling", "bowling.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3b3.png", "objects"));
        shortCutMap.put("bowtie", new EmojiShortcut("bowtie", "bowtie.png", "https://assets-cdn.github.com/images/icons/emoji/bowtie.png", "people"));
        shortCutMap.put("boy", new EmojiShortcut("boy", "boy.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f466.png", "people"));
        shortCutMap.put("bread", new EmojiShortcut("bread", "bread.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f35e.png", "objects"));
        shortCutMap.put("bride_with_veil", new EmojiShortcut("bride_with_veil", "bride_with_veil.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f470.png", "people"));
        shortCutMap.put("bridge_at_night", new EmojiShortcut("bridge_at_night", "bridge_at_night.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f309.png", "places"));
        shortCutMap.put("briefcase", new EmojiShortcut("briefcase", "briefcase.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4bc.png", "objects"));
        shortCutMap.put("broken_heart", new EmojiShortcut("broken_heart", "broken_heart.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f494.png", "people"));
        shortCutMap.put("bug", new EmojiShortcut("bug", "bug.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f41b.png", "nature"));
        shortCutMap.put("bulb", new EmojiShortcut("bulb", "bulb.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4a1.png", "objects"));
        shortCutMap.put("bullettrain_front", new EmojiShortcut("bullettrain_front", "bullettrain_front.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f685.png", "places"));
        shortCutMap.put("bullettrain_side", new EmojiShortcut("bullettrain_side", "bullettrain_side.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f684.png", "places"));
        shortCutMap.put("bus", new EmojiShortcut("bus", "bus.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f68c.png", "places"));
        shortCutMap.put("busstop", new EmojiShortcut("busstop", "busstop.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f68f.png", "places"));
        shortCutMap.put("bust_in_silhouette", new EmojiShortcut("bust_in_silhouette", "bust_in_silhouette.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f464.png", "people"));
        shortCutMap.put("busts_in_silhouette", new EmojiShortcut("busts_in_silhouette", "busts_in_silhouette.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f465.png", "people"));
        shortCutMap.put("cactus", new EmojiShortcut("cactus", "cactus.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f335.png", "nature"));
        shortCutMap.put("cake", new EmojiShortcut("cake", "cake.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f370.png", "objects"));
        shortCutMap.put("calendar", new EmojiShortcut("calendar", "calendar.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4c6.png", "objects"));
        shortCutMap.put("calling", new EmojiShortcut("calling", "calling.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4f2.png", "objects"));
        shortCutMap.put("camel", new EmojiShortcut("camel", "camel.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f42b.png", "nature"));
        shortCutMap.put("camera", new EmojiShortcut("camera", "camera.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4f7.png", "objects"));
        shortCutMap.put("cancer", new EmojiShortcut("cancer", "cancer.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/264b.png", "symbols"));
        shortCutMap.put("candy", new EmojiShortcut("candy", "candy.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f36c.png", "objects"));
        shortCutMap.put("capital_abcd", new EmojiShortcut("capital_abcd", "capital_abcd.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f520.png", "symbols"));
        shortCutMap.put("capricorn", new EmojiShortcut("capricorn", "capricorn.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2651.png", "symbols"));
        shortCutMap.put("car", new EmojiShortcut("car", "car.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f697.png", "places"));
        shortCutMap.put("card_index", new EmojiShortcut("card_index", "card_index.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4c7.png", "objects"));
        shortCutMap.put("carousel_horse", new EmojiShortcut("carousel_horse", "carousel_horse.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3a0.png", "places"));
        shortCutMap.put("cat", new EmojiShortcut("cat", "cat.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f431.png", "nature"));
        shortCutMap.put("cat2", new EmojiShortcut("cat2", "cat2.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f408.png", "nature"));
        shortCutMap.put("cd", new EmojiShortcut("cd", "cd.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4bf.png", "objects"));
        shortCutMap.put("chart", new EmojiShortcut("chart", "chart.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4b9.png", "symbols"));
        shortCutMap.put("chart_with_downwards_trend", new EmojiShortcut("chart_with_downwards_trend", "chart_with_downwards_trend.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4c9.png", "objects"));
        shortCutMap.put("chart_with_upwards_trend", new EmojiShortcut("chart_with_upwards_trend", "chart_with_upwards_trend.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4c8.png", "objects"));
        shortCutMap.put("checkered_flag", new EmojiShortcut("checkered_flag", "checkered_flag.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3c1.png", "places"));
        shortCutMap.put("cherries", new EmojiShortcut("cherries", "cherries.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f352.png", "objects"));
        shortCutMap.put("cherry_blossom", new EmojiShortcut("cherry_blossom", "cherry_blossom.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f338.png", "nature"));
        shortCutMap.put("chestnut", new EmojiShortcut("chestnut", "chestnut.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f330.png", "nature"));
        shortCutMap.put("chicken", new EmojiShortcut("chicken", "chicken.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f414.png", "nature"));
        shortCutMap.put("children_crossing", new EmojiShortcut("children_crossing", "children_crossing.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6b8.png", "symbols"));
        shortCutMap.put("chocolate_bar", new EmojiShortcut("chocolate_bar", "chocolate_bar.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f36b.png", "objects"));
        shortCutMap.put("christmas_tree", new EmojiShortcut("christmas_tree", "christmas_tree.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f384.png", "objects"));
        shortCutMap.put("church", new EmojiShortcut("church", "church.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/26ea.png", "places"));
        shortCutMap.put("cinema", new EmojiShortcut("cinema", "cinema.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3a6.png", "symbols"));
        shortCutMap.put("circus_tent", new EmojiShortcut("circus_tent", "circus_tent.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3aa.png", "places"));
        shortCutMap.put("city_sunrise", new EmojiShortcut("city_sunrise", "city_sunrise.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f307.png", "places"));
        shortCutMap.put("city_sunset", new EmojiShortcut("city_sunset", "city_sunset.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f306.png", "places"));
        shortCutMap.put("cl", new EmojiShortcut("cl", "cl.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f191.png", "symbols"));
        shortCutMap.put("clap", new EmojiShortcut("clap", "clap.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f44f.png", "people"));
        shortCutMap.put("clapper", new EmojiShortcut("clapper", "clapper.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3ac.png", "objects"));
        shortCutMap.put("clipboard", new EmojiShortcut("clipboard", "clipboard.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4cb.png", "objects"));
        shortCutMap.put("clock1", new EmojiShortcut("clock1", "clock1.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f550.png", "symbols"));
        shortCutMap.put("clock2", new EmojiShortcut("clock2", "clock2.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f551.png", "symbols"));
        shortCutMap.put("clock3", new EmojiShortcut("clock3", "clock3.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f552.png", "symbols"));
        shortCutMap.put("clock4", new EmojiShortcut("clock4", "clock4.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f553.png", "symbols"));
        shortCutMap.put("clock5", new EmojiShortcut("clock5", "clock5.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f554.png", "symbols"));
        shortCutMap.put("clock6", new EmojiShortcut("clock6", "clock6.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f555.png", "symbols"));
        shortCutMap.put("clock7", new EmojiShortcut("clock7", "clock7.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f556.png", "symbols"));
        shortCutMap.put("clock8", new EmojiShortcut("clock8", "clock8.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f557.png", "symbols"));
        shortCutMap.put("clock9", new EmojiShortcut("clock9", "clock9.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f558.png", "symbols"));
        shortCutMap.put("clock10", new EmojiShortcut("clock10", "clock10.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f559.png", "symbols"));
        shortCutMap.put("clock11", new EmojiShortcut("clock11", "clock11.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f55a.png", "symbols"));
        shortCutMap.put("clock12", new EmojiShortcut("clock12", "clock12.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f55b.png", "symbols"));
        shortCutMap.put("clock130", new EmojiShortcut("clock130", "clock130.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f55c.png", "symbols"));
        shortCutMap.put("clock230", new EmojiShortcut("clock230", "clock230.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f55d.png", "symbols"));
        shortCutMap.put("clock330", new EmojiShortcut("clock330", "clock330.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f55e.png", "symbols"));
        shortCutMap.put("clock430", new EmojiShortcut("clock430", "clock430.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f55f.png", "symbols"));
        shortCutMap.put("clock530", new EmojiShortcut("clock530", "clock530.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f560.png", "symbols"));
        shortCutMap.put("clock630", new EmojiShortcut("clock630", "clock630.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f561.png", "symbols"));
        shortCutMap.put("clock730", new EmojiShortcut("clock730", "clock730.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f562.png", "symbols"));
        shortCutMap.put("clock830", new EmojiShortcut("clock830", "clock830.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f563.png", "symbols"));
        shortCutMap.put("clock930", new EmojiShortcut("clock930", "clock930.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f564.png", "symbols"));
        shortCutMap.put("clock1030", new EmojiShortcut("clock1030", "clock1030.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f565.png", "symbols"));
        shortCutMap.put("clock1130", new EmojiShortcut("clock1130", "clock1130.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f566.png", "symbols"));
        shortCutMap.put("clock1230", new EmojiShortcut("clock1230", "clock1230.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f567.png", "symbols"));
        shortCutMap.put("closed_book", new EmojiShortcut("closed_book", "closed_book.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4d5.png", "objects"));
        shortCutMap.put("closed_lock_with_key", new EmojiShortcut("closed_lock_with_key", "closed_lock_with_key.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f510.png", "objects"));
        shortCutMap.put("closed_umbrella", new EmojiShortcut("closed_umbrella", "closed_umbrella.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f302.png", "objects"));
        shortCutMap.put("cloud", new EmojiShortcut("cloud", "cloud.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2601.png", "nature"));
        shortCutMap.put("clubs", new EmojiShortcut("clubs", "clubs.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2663.png", "objects"));
        shortCutMap.put("cn", new EmojiShortcut("cn", "cn.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f1e8-1f1f3.png", "places"));
        shortCutMap.put("cocktail", new EmojiShortcut("cocktail", "cocktail.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f378.png", "objects"));
        shortCutMap.put("coffee", new EmojiShortcut("coffee", "coffee.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2615.png", "objects"));
        shortCutMap.put("cold_sweat", new EmojiShortcut("cold_sweat", "cold_sweat.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f630.png", "people"));
        shortCutMap.put("collision", new EmojiShortcut("collision", "collision.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4a5.png", "people"));
        shortCutMap.put("computer", new EmojiShortcut("computer", "computer.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4bb.png", "objects"));
        shortCutMap.put("confetti_ball", new EmojiShortcut("confetti_ball", "confetti_ball.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f38a.png", "objects"));
        shortCutMap.put("confounded", new EmojiShortcut("confounded", "confounded.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f616.png", "people"));
        shortCutMap.put("confused", new EmojiShortcut("confused", "confused.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f615.png", "people"));
        shortCutMap.put("congratulations", new EmojiShortcut("congratulations", "congratulations.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/3297.png", "symbols"));
        shortCutMap.put("construction", new EmojiShortcut("construction", "construction.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6a7.png", "places"));
        shortCutMap.put("construction_worker", new EmojiShortcut("construction_worker", "construction_worker.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f477.png", "people"));
        shortCutMap.put("convenience_store", new EmojiShortcut("convenience_store", "convenience_store.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3ea.png", "places"));
        shortCutMap.put("cookie", new EmojiShortcut("cookie", "cookie.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f36a.png", "objects"));
        shortCutMap.put("cool", new EmojiShortcut("cool", "cool.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f192.png", "symbols"));
        shortCutMap.put("cop", new EmojiShortcut("cop", "cop.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f46e.png", "people"));
        shortCutMap.put("copyright", new EmojiShortcut("copyright", "copyright.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/00a9.png", "symbols"));
        shortCutMap.put("corn", new EmojiShortcut("corn", "corn.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f33d.png", "objects"));
        shortCutMap.put("couple", new EmojiShortcut("couple", "couple.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f46b.png", "people"));
        shortCutMap.put("couple_with_heart", new EmojiShortcut("couple_with_heart", "couple_with_heart.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f491.png", "people"));
        shortCutMap.put("couplekiss", new EmojiShortcut("couplekiss", "couplekiss.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f48f.png", "people"));
        shortCutMap.put("cow", new EmojiShortcut("cow", "cow.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f42e.png", "nature"));
        shortCutMap.put("cow2", new EmojiShortcut("cow2", "cow2.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f404.png", "nature"));
        shortCutMap.put("credit_card", new EmojiShortcut("credit_card", "credit_card.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4b3.png", "objects"));
        shortCutMap.put("crescent_moon", new EmojiShortcut("crescent_moon", "crescent_moon.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f319.png", "nature"));
        shortCutMap.put("crocodile", new EmojiShortcut("crocodile", "crocodile.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f40a.png", "nature"));
        shortCutMap.put("crossed_flags", new EmojiShortcut("crossed_flags", "crossed_flags.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f38c.png", "places"));
        shortCutMap.put("crown", new EmojiShortcut("crown", "crown.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f451.png", "objects"));
        shortCutMap.put("cry", new EmojiShortcut("cry", "cry.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f622.png", "people"));
        shortCutMap.put("crying_cat_face", new EmojiShortcut("crying_cat_face", "crying_cat_face.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f63f.png", "people"));
        shortCutMap.put("crystal_ball", new EmojiShortcut("crystal_ball", "crystal_ball.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f52e.png", "objects"));
        shortCutMap.put("cupid", new EmojiShortcut("cupid", "cupid.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f498.png", "people"));
        shortCutMap.put("curly_loop", new EmojiShortcut("curly_loop", "curly_loop.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/27b0.png", "symbols"));
        shortCutMap.put("currency_exchange", new EmojiShortcut("currency_exchange", "currency_exchange.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4b1.png", "symbols"));
        shortCutMap.put("curry", new EmojiShortcut("curry", "curry.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f35b.png", "objects"));
        shortCutMap.put("custard", new EmojiShortcut("custard", "custard.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f36e.png", "objects"));
        shortCutMap.put("customs", new EmojiShortcut("customs", "customs.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6c3.png", "symbols"));
        shortCutMap.put("cyclone", new EmojiShortcut("cyclone", "cyclone.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f300.png", "nature"));
        shortCutMap.put("dancer", new EmojiShortcut("dancer", "dancer.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f483.png", "people"));
        shortCutMap.put("dancers", new EmojiShortcut("dancers", "dancers.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f46f.png", "people"));
        shortCutMap.put("dango", new EmojiShortcut("dango", "dango.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f361.png", "objects"));
        shortCutMap.put("dart", new EmojiShortcut("dart", "dart.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3af.png", "objects"));
        shortCutMap.put("dash", new EmojiShortcut("dash", "dash.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4a8.png", "people"));
        shortCutMap.put("date", new EmojiShortcut("date", "date.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4c5.png", "objects"));
        shortCutMap.put("de", new EmojiShortcut("de", "de.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f1e9-1f1ea.png", "places"));
        shortCutMap.put("deciduous_tree", new EmojiShortcut("deciduous_tree", "deciduous_tree.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f333.png", "nature"));
        shortCutMap.put("department_store", new EmojiShortcut("department_store", "department_store.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3ec.png", "places"));
        shortCutMap.put("diamond_shape_with_a_dot_inside", new EmojiShortcut("diamond_shape_with_a_dot_inside", "diamond_shape_with_a_dot_inside.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4a0.png", "symbols"));
        shortCutMap.put("diamonds", new EmojiShortcut("diamonds", "diamonds.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2666.png", "objects"));
        shortCutMap.put("disappointed", new EmojiShortcut("disappointed", "disappointed.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f61e.png", "people"));
        shortCutMap.put("disappointed_relieved", new EmojiShortcut("disappointed_relieved", "disappointed_relieved.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f625.png", "people"));
        shortCutMap.put("dizzy", new EmojiShortcut("dizzy", "dizzy.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4ab.png", "people"));
        shortCutMap.put("dizzy_face", new EmojiShortcut("dizzy_face", "dizzy_face.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f635.png", "people"));
        shortCutMap.put("do_not_litter", new EmojiShortcut("do_not_litter", "do_not_litter.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6af.png", "symbols"));
        shortCutMap.put("dog", new EmojiShortcut("dog", "dog.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f436.png", "nature"));
        shortCutMap.put("dog2", new EmojiShortcut("dog2", "dog2.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f415.png", "nature"));
        shortCutMap.put("dollar", new EmojiShortcut("dollar", "dollar.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4b5.png", "objects"));
        shortCutMap.put("dolls", new EmojiShortcut("dolls", "dolls.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f38e.png", "objects"));
        shortCutMap.put("dolphin", new EmojiShortcut("dolphin", "dolphin.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f42c.png", "nature"));
        shortCutMap.put("door", new EmojiShortcut("door", "door.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6aa.png", "objects"));
        shortCutMap.put("doughnut", new EmojiShortcut("doughnut", "doughnut.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f369.png", "objects"));
        shortCutMap.put("dragon", new EmojiShortcut("dragon", "dragon.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f409.png", "nature"));
        shortCutMap.put("dragon_face", new EmojiShortcut("dragon_face", "dragon_face.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f432.png", "nature"));
        shortCutMap.put("dress", new EmojiShortcut("dress", "dress.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f457.png", "objects"));
        shortCutMap.put("dromedary_camel", new EmojiShortcut("dromedary_camel", "dromedary_camel.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f42a.png", "nature"));
        shortCutMap.put("droplet", new EmojiShortcut("droplet", "droplet.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4a7.png", "people"));
        shortCutMap.put("dvd", new EmojiShortcut("dvd", "dvd.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4c0.png", "objects"));
        shortCutMap.put("ear", new EmojiShortcut("ear", "ear.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f442.png", "people"));
        shortCutMap.put("ear_of_rice", new EmojiShortcut("ear_of_rice", "ear_of_rice.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f33e.png", "nature"));
        shortCutMap.put("earth_africa", new EmojiShortcut("earth_africa", "earth_africa.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f30d.png", "nature"));
        shortCutMap.put("earth_americas", new EmojiShortcut("earth_americas", "earth_americas.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f30e.png", "nature"));
        shortCutMap.put("earth_asia", new EmojiShortcut("earth_asia", "earth_asia.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f30f.png", "nature"));
        shortCutMap.put("egg", new EmojiShortcut("egg", "egg.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f373.png", "objects"));
        shortCutMap.put("eggplant", new EmojiShortcut("eggplant", "eggplant.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f346.png", "objects"));
        shortCutMap.put("eight", new EmojiShortcut("eight", "eight.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/0038-20e3.png", "symbols"));
        shortCutMap.put("eight_pointed_black_star", new EmojiShortcut("eight_pointed_black_star", "eight_pointed_black_star.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2734.png", "symbols"));
        shortCutMap.put("eight_spoked_asterisk", new EmojiShortcut("eight_spoked_asterisk", "eight_spoked_asterisk.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2733.png", "symbols"));
        shortCutMap.put("electric_plug", new EmojiShortcut("electric_plug", "electric_plug.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f50c.png", "objects"));
        shortCutMap.put("elephant", new EmojiShortcut("elephant", "elephant.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f418.png", "nature"));
        shortCutMap.put("email", new EmojiShortcut("email", "email.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2709.png", "objects"));
        shortCutMap.put("e-mail", new EmojiShortcut("e-mail", "e-mail.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4e7.png", "objects"));
        shortCutMap.put("end", new EmojiShortcut("end", "end.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f51a.png", "symbols"));
        shortCutMap.put("envelope", new EmojiShortcut("envelope", "envelope.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2709.png", "objects"));
        shortCutMap.put("es", new EmojiShortcut("es", "es.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f1ea-1f1f8.png", "places"));
        shortCutMap.put("euro", new EmojiShortcut("euro", "euro.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4b6.png", "objects"));
        shortCutMap.put("european_castle", new EmojiShortcut("european_castle", "european_castle.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3f0.png", "places"));
        shortCutMap.put("european_post_office", new EmojiShortcut("european_post_office", "european_post_office.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3e4.png", "places"));
        shortCutMap.put("evergreen_tree", new EmojiShortcut("evergreen_tree", "evergreen_tree.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f332.png", "nature"));
        shortCutMap.put("exclamation", new EmojiShortcut("exclamation", "exclamation.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2757.png", "people"));
        shortCutMap.put("expressionless", new EmojiShortcut("expressionless", "expressionless.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f611.png", "people"));
        shortCutMap.put("eyeglasses", new EmojiShortcut("eyeglasses", "eyeglasses.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f453.png", "objects"));
        shortCutMap.put("eyes", new EmojiShortcut("eyes", "eyes.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f440.png", "people"));
        shortCutMap.put("facepunch", new EmojiShortcut("facepunch", "facepunch.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f44a.png", "people"));
        shortCutMap.put("factory", new EmojiShortcut("factory", "factory.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3ed.png", "places"));
        shortCutMap.put("fallen_leaf", new EmojiShortcut("fallen_leaf", "fallen_leaf.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f342.png", "nature"));
        shortCutMap.put("family", new EmojiShortcut("family", "family.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f46a.png", "people"));
        shortCutMap.put("fast_forward", new EmojiShortcut("fast_forward", "fast_forward.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/23e9.png", "symbols"));
        shortCutMap.put("fax", new EmojiShortcut("fax", "fax.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4e0.png", "objects"));
        shortCutMap.put("fearful", new EmojiShortcut("fearful", "fearful.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f628.png", "people"));
        shortCutMap.put("feelsgood", new EmojiShortcut("feelsgood", "feelsgood.png", "https://assets-cdn.github.com/images/icons/emoji/feelsgood.png", "people"));
        shortCutMap.put("feet", new EmojiShortcut("feet", "feet.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f43e.png", "people"));
        shortCutMap.put("ferris_wheel", new EmojiShortcut("ferris_wheel", "ferris_wheel.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3a1.png", "places"));
        shortCutMap.put("file_folder", new EmojiShortcut("file_folder", "file_folder.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4c1.png", "objects"));
        shortCutMap.put("finnadie", new EmojiShortcut("finnadie", "finnadie.png", "https://assets-cdn.github.com/images/icons/emoji/finnadie.png", "people"));
        shortCutMap.put("fire", new EmojiShortcut("fire", "fire.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f525.png", "people"));
        shortCutMap.put("fire_engine", new EmojiShortcut("fire_engine", "fire_engine.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f692.png", "places"));
        shortCutMap.put("fireworks", new EmojiShortcut("fireworks", "fireworks.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f386.png", "objects"));
        shortCutMap.put("first_quarter_moon", new EmojiShortcut("first_quarter_moon", "first_quarter_moon.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f313.png", "nature"));
        shortCutMap.put("first_quarter_moon_with_face", new EmojiShortcut("first_quarter_moon_with_face", "first_quarter_moon_with_face.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f31b.png", "nature"));
        shortCutMap.put("fish", new EmojiShortcut("fish", "fish.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f41f.png", "nature"));
        shortCutMap.put("fish_cake", new EmojiShortcut("fish_cake", "fish_cake.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f365.png", "objects"));
        shortCutMap.put("fishing_pole_and_fish", new EmojiShortcut("fishing_pole_and_fish", "fishing_pole_and_fish.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3a3.png", "objects"));
        shortCutMap.put("fist", new EmojiShortcut("fist", "fist.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/270a.png", "people"));
        shortCutMap.put("five", new EmojiShortcut("five", "five.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/0035-20e3.png", "symbols"));
        shortCutMap.put("flags", new EmojiShortcut("flags", "flags.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f38f.png", "objects"));
        shortCutMap.put("flashlight", new EmojiShortcut("flashlight", "flashlight.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f526.png", "objects"));
        shortCutMap.put("floppy_disk", new EmojiShortcut("floppy_disk", "floppy_disk.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4be.png", "objects"));
        shortCutMap.put("flower_playing_cards", new EmojiShortcut("flower_playing_cards", "flower_playing_cards.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3b4.png", "objects"));
        shortCutMap.put("flushed", new EmojiShortcut("flushed", "flushed.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f633.png", "people"));
        shortCutMap.put("foggy", new EmojiShortcut("foggy", "foggy.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f301.png", "nature"));
        shortCutMap.put("football", new EmojiShortcut("football", "football.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3c8.png", "objects"));
        shortCutMap.put("fork_and_knife", new EmojiShortcut("fork_and_knife", "fork_and_knife.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f374.png", "objects"));
        shortCutMap.put("fountain", new EmojiShortcut("fountain", "fountain.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/26f2.png", "places"));
        shortCutMap.put("four", new EmojiShortcut("four", "four.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/0034-20e3.png", "symbols"));
        shortCutMap.put("four_leaf_clover", new EmojiShortcut("four_leaf_clover", "four_leaf_clover.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f340.png", "nature"));
        shortCutMap.put("fr", new EmojiShortcut("fr", "fr.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f1eb-1f1f7.png", "places"));
        shortCutMap.put("free", new EmojiShortcut("free", "free.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f193.png", "symbols"));
        shortCutMap.put("fried_shrimp", new EmojiShortcut("fried_shrimp", "fried_shrimp.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f364.png", "objects"));
        shortCutMap.put("fries", new EmojiShortcut("fries", "fries.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f35f.png", "objects"));
        shortCutMap.put("frog", new EmojiShortcut("frog", "frog.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f438.png", "nature"));
        shortCutMap.put("frowning", new EmojiShortcut("frowning", "frowning.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f626.png", "people"));
        shortCutMap.put("fu", new EmojiShortcut("fu", "fu.png", "https://assets-cdn.github.com/images/icons/emoji/fu.png", "people"));
        shortCutMap.put("fuelpump", new EmojiShortcut("fuelpump", "fuelpump.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/26fd.png", "places"));
        shortCutMap.put("full_moon", new EmojiShortcut("full_moon", "full_moon.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f315.png", "nature"));
        shortCutMap.put("full_moon_with_face", new EmojiShortcut("full_moon_with_face", "full_moon_with_face.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f31d.png", "nature"));
        shortCutMap.put("game_die", new EmojiShortcut("game_die", "game_die.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3b2.png", "objects"));
        shortCutMap.put("gb", new EmojiShortcut("gb", "gb.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f1ec-1f1e7.png", "places"));
        shortCutMap.put("gem", new EmojiShortcut("gem", "gem.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f48e.png", "objects"));
        shortCutMap.put("gemini", new EmojiShortcut("gemini", "gemini.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/264a.png", "symbols"));
        shortCutMap.put("ghost", new EmojiShortcut("ghost", "ghost.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f47b.png", "objects"));
        shortCutMap.put("gift", new EmojiShortcut("gift", "gift.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f381.png", "objects"));
        shortCutMap.put("gift_heart", new EmojiShortcut("gift_heart", "gift_heart.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f49d.png", "objects"));
        shortCutMap.put("girl", new EmojiShortcut("girl", "girl.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f467.png", "people"));
        shortCutMap.put("globe_with_meridians", new EmojiShortcut("globe_with_meridians", "globe_with_meridians.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f310.png", "nature"));
        shortCutMap.put("goat", new EmojiShortcut("goat", "goat.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f410.png", "nature"));
        shortCutMap.put("goberserk", new EmojiShortcut("goberserk", "goberserk.png", "https://assets-cdn.github.com/images/icons/emoji/goberserk.png", "people"));
        shortCutMap.put("godmode", new EmojiShortcut("godmode", "godmode.png", "https://assets-cdn.github.com/images/icons/emoji/godmode.png", "people"));
        shortCutMap.put("golf", new EmojiShortcut("golf", "golf.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/26f3.png", "objects"));
        shortCutMap.put("grapes", new EmojiShortcut("grapes", "grapes.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f347.png", "objects"));
        shortCutMap.put("green_apple", new EmojiShortcut("green_apple", "green_apple.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f34f.png", "objects"));
        shortCutMap.put("green_book", new EmojiShortcut("green_book", "green_book.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4d7.png", "objects"));
        shortCutMap.put("green_heart", new EmojiShortcut("green_heart", "green_heart.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f49a.png", "people"));
        shortCutMap.put("grey_exclamation", new EmojiShortcut("grey_exclamation", "grey_exclamation.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2755.png", "people"));
        shortCutMap.put("grey_question", new EmojiShortcut("grey_question", "grey_question.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2754.png", "people"));
        shortCutMap.put("grimacing", new EmojiShortcut("grimacing", "grimacing.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f62c.png", "people"));
        shortCutMap.put("grin", new EmojiShortcut("grin", "grin.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f601.png", "people"));
        shortCutMap.put("grinning", new EmojiShortcut("grinning", "grinning.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f600.png", "people"));
        shortCutMap.put("guardsman", new EmojiShortcut("guardsman", "guardsman.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f482.png", "people"));
        shortCutMap.put("guitar", new EmojiShortcut("guitar", "guitar.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3b8.png", "objects"));
        shortCutMap.put("gun", new EmojiShortcut("gun", "gun.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f52b.png", "objects"));
        shortCutMap.put("haircut", new EmojiShortcut("haircut", "haircut.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f487.png", "people"));
        shortCutMap.put("hamburger", new EmojiShortcut("hamburger", "hamburger.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f354.png", "objects"));
        shortCutMap.put("hammer", new EmojiShortcut("hammer", "hammer.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f528.png", "objects"));
        shortCutMap.put("hamster", new EmojiShortcut("hamster", "hamster.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f439.png", "nature"));
        shortCutMap.put("hand", new EmojiShortcut("hand", "hand.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/270b.png", "people"));
        shortCutMap.put("handbag", new EmojiShortcut("handbag", "handbag.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f45c.png", "objects"));
        shortCutMap.put("hankey", new EmojiShortcut("hankey", "hankey.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4a9.png", "people"));
        shortCutMap.put("hash", new EmojiShortcut("hash", "hash.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/0023-20e3.png", "symbols"));
        shortCutMap.put("hatched_chick", new EmojiShortcut("hatched_chick", "hatched_chick.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f425.png", "nature"));
        shortCutMap.put("hatching_chick", new EmojiShortcut("hatching_chick", "hatching_chick.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f423.png", "nature"));
        shortCutMap.put("headphones", new EmojiShortcut("headphones", "headphones.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3a7.png", "objects"));
        shortCutMap.put("hear_no_evil", new EmojiShortcut("hear_no_evil", "hear_no_evil.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f649.png", "people"));
        shortCutMap.put("heart", new EmojiShortcut("heart", "heart.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2764.png", "people"));
        shortCutMap.put("heart_decoration", new EmojiShortcut("heart_decoration", "heart_decoration.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f49f.png", "symbols"));
        shortCutMap.put("heart_eyes", new EmojiShortcut("heart_eyes", "heart_eyes.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f60d.png", "people"));
        shortCutMap.put("heart_eyes_cat", new EmojiShortcut("heart_eyes_cat", "heart_eyes_cat.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f63b.png", "people"));
        shortCutMap.put("heartbeat", new EmojiShortcut("heartbeat", "heartbeat.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f493.png", "people"));
        shortCutMap.put("heartpulse", new EmojiShortcut("heartpulse", "heartpulse.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f497.png", "people"));
        shortCutMap.put("hearts", new EmojiShortcut("hearts", "hearts.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2665.png", "objects"));
        shortCutMap.put("heavy_check_mark", new EmojiShortcut("heavy_check_mark", "heavy_check_mark.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2714.png", "symbols"));
        shortCutMap.put("heavy_division_sign", new EmojiShortcut("heavy_division_sign", "heavy_division_sign.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2797.png", "symbols"));
        shortCutMap.put("heavy_dollar_sign", new EmojiShortcut("heavy_dollar_sign", "heavy_dollar_sign.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4b2.png", "symbols"));
        shortCutMap.put("heavy_exclamation_mark", new EmojiShortcut("heavy_exclamation_mark", "heavy_exclamation_mark.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2757.png", "symbols"));
        shortCutMap.put("heavy_minus_sign", new EmojiShortcut("heavy_minus_sign", "heavy_minus_sign.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2796.png", "symbols"));
        shortCutMap.put("heavy_multiplication_x", new EmojiShortcut("heavy_multiplication_x", "heavy_multiplication_x.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2716.png", "symbols"));
        shortCutMap.put("heavy_plus_sign", new EmojiShortcut("heavy_plus_sign", "heavy_plus_sign.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2795.png", "symbols"));
        shortCutMap.put("helicopter", new EmojiShortcut("helicopter", "helicopter.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f681.png", "places"));
        shortCutMap.put("herb", new EmojiShortcut("herb", "herb.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f33f.png", "nature"));
        shortCutMap.put("hibiscus", new EmojiShortcut("hibiscus", "hibiscus.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f33a.png", "nature"));
        shortCutMap.put("high_brightness", new EmojiShortcut("high_brightness", "high_brightness.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f506.png", "objects"));
        shortCutMap.put("high_heel", new EmojiShortcut("high_heel", "high_heel.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f460.png", "objects"));
        shortCutMap.put("hocho", new EmojiShortcut("hocho", "hocho.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f52a.png", "objects"));
        shortCutMap.put("honey_pot", new EmojiShortcut("honey_pot", "honey_pot.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f36f.png", "objects"));
        shortCutMap.put("honeybee", new EmojiShortcut("honeybee", "honeybee.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f41d.png", "nature"));
        shortCutMap.put("horse", new EmojiShortcut("horse", "horse.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f434.png", "nature"));
        shortCutMap.put("horse_racing", new EmojiShortcut("horse_racing", "horse_racing.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3c7.png", "objects"));
        shortCutMap.put("hospital", new EmojiShortcut("hospital", "hospital.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3e5.png", "places"));
        shortCutMap.put("hotel", new EmojiShortcut("hotel", "hotel.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3e8.png", "places"));
        shortCutMap.put("hotsprings", new EmojiShortcut("hotsprings", "hotsprings.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2668.png", "places"));
        shortCutMap.put("hourglass", new EmojiShortcut("hourglass", "hourglass.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/231b.png", "objects"));
        shortCutMap.put("hourglass_flowing_sand", new EmojiShortcut("hourglass_flowing_sand", "hourglass_flowing_sand.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/23f3.png", "objects"));
        shortCutMap.put("house", new EmojiShortcut("house", "house.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3e0.png", "places"));
        shortCutMap.put("house_with_garden", new EmojiShortcut("house_with_garden", "house_with_garden.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3e1.png", "places"));
        shortCutMap.put("hurtrealbad", new EmojiShortcut("hurtrealbad", "hurtrealbad.png", "https://assets-cdn.github.com/images/icons/emoji/hurtrealbad.png", "people"));
        shortCutMap.put("hushed", new EmojiShortcut("hushed", "hushed.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f62f.png", "people"));
        shortCutMap.put("ice_cream", new EmojiShortcut("ice_cream", "ice_cream.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f368.png", "objects"));
        shortCutMap.put("icecream", new EmojiShortcut("icecream", "icecream.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f366.png", "objects"));
        shortCutMap.put("id", new EmojiShortcut("id", "id.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f194.png", "symbols"));
        shortCutMap.put("ideograph_advantage", new EmojiShortcut("ideograph_advantage", "ideograph_advantage.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f250.png", "symbols"));
        shortCutMap.put("imp", new EmojiShortcut("imp", "imp.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f47f.png", "people"));
        shortCutMap.put("inbox_tray", new EmojiShortcut("inbox_tray", "inbox_tray.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4e5.png", "objects"));
        shortCutMap.put("incoming_envelope", new EmojiShortcut("incoming_envelope", "incoming_envelope.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4e8.png", "objects"));
        shortCutMap.put("information_desk_person", new EmojiShortcut("information_desk_person", "information_desk_person.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f481.png", "people"));
        shortCutMap.put("information_source", new EmojiShortcut("information_source", "information_source.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2139.png", "symbols"));
        shortCutMap.put("innocent", new EmojiShortcut("innocent", "innocent.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f607.png", "people"));
        shortCutMap.put("interrobang", new EmojiShortcut("interrobang", "interrobang.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2049.png", "symbols"));
        shortCutMap.put("iphone", new EmojiShortcut("iphone", "iphone.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4f1.png", "objects"));
        shortCutMap.put("it", new EmojiShortcut("it", "it.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f1ee-1f1f9.png", "places"));
        shortCutMap.put("izakaya_lantern", new EmojiShortcut("izakaya_lantern", "izakaya_lantern.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3ee.png", "places"));
        shortCutMap.put("jack_o_lantern", new EmojiShortcut("jack_o_lantern", "jack_o_lantern.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f383.png", "objects"));
        shortCutMap.put("japan", new EmojiShortcut("japan", "japan.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f5fe.png", "places"));
        shortCutMap.put("japanese_castle", new EmojiShortcut("japanese_castle", "japanese_castle.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3ef.png", "places"));
        shortCutMap.put("japanese_goblin", new EmojiShortcut("japanese_goblin", "japanese_goblin.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f47a.png", "people"));
        shortCutMap.put("japanese_ogre", new EmojiShortcut("japanese_ogre", "japanese_ogre.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f479.png", "people"));
        shortCutMap.put("jeans", new EmojiShortcut("jeans", "jeans.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f456.png", "objects"));
        shortCutMap.put("joy", new EmojiShortcut("joy", "joy.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f602.png", "people"));
        shortCutMap.put("joy_cat", new EmojiShortcut("joy_cat", "joy_cat.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f639.png", "people"));
        shortCutMap.put("jp", new EmojiShortcut("jp", "jp.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f1ef-1f1f5.png", "places"));
        shortCutMap.put("key", new EmojiShortcut("key", "key.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f511.png", "objects"));
        shortCutMap.put("keycap_ten", new EmojiShortcut("keycap_ten", "keycap_ten.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f51f.png", "symbols"));
        shortCutMap.put("kimono", new EmojiShortcut("kimono", "kimono.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f458.png", "objects"));
        shortCutMap.put("kiss", new EmojiShortcut("kiss", "kiss.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f48b.png", "people"));
        shortCutMap.put("kissing", new EmojiShortcut("kissing", "kissing.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f617.png", "people"));
        shortCutMap.put("kissing_cat", new EmojiShortcut("kissing_cat", "kissing_cat.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f63d.png", "people"));
        shortCutMap.put("kissing_closed_eyes", new EmojiShortcut("kissing_closed_eyes", "kissing_closed_eyes.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f61a.png", "people"));
        shortCutMap.put("kissing_heart", new EmojiShortcut("kissing_heart", "kissing_heart.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f618.png", "people"));
        shortCutMap.put("kissing_smiling_eyes", new EmojiShortcut("kissing_smiling_eyes", "kissing_smiling_eyes.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f619.png", "people"));
        shortCutMap.put("koala", new EmojiShortcut("koala", "koala.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f428.png", "nature"));
        shortCutMap.put("koko", new EmojiShortcut("koko", "koko.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f201.png", "symbols"));
        shortCutMap.put("kr", new EmojiShortcut("kr", "kr.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f1f0-1f1f7.png", "places"));
        shortCutMap.put("large_blue_circle", new EmojiShortcut("large_blue_circle", "large_blue_circle.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f535.png", "symbols"));
        shortCutMap.put("large_blue_diamond", new EmojiShortcut("large_blue_diamond", "large_blue_diamond.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f537.png", "symbols"));
        shortCutMap.put("large_orange_diamond", new EmojiShortcut("large_orange_diamond", "large_orange_diamond.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f536.png", "symbols"));
        shortCutMap.put("last_quarter_moon", new EmojiShortcut("last_quarter_moon", "last_quarter_moon.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f317.png", "nature"));
        shortCutMap.put("last_quarter_moon_with_face", new EmojiShortcut("last_quarter_moon_with_face", "last_quarter_moon_with_face.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f31c.png", "nature"));
        shortCutMap.put("laughing", new EmojiShortcut("laughing", "laughing.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f606.png", "people"));
        shortCutMap.put("leaves", new EmojiShortcut("leaves", "leaves.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f343.png", "nature"));
        shortCutMap.put("ledger", new EmojiShortcut("ledger", "ledger.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4d2.png", "objects"));
        shortCutMap.put("left_luggage", new EmojiShortcut("left_luggage", "left_luggage.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6c5.png", "symbols"));
        shortCutMap.put("left_right_arrow", new EmojiShortcut("left_right_arrow", "left_right_arrow.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2194.png", "symbols"));
        shortCutMap.put("leftwards_arrow_with_hook", new EmojiShortcut("leftwards_arrow_with_hook", "leftwards_arrow_with_hook.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/21a9.png", "symbols"));
        shortCutMap.put("lemon", new EmojiShortcut("lemon", "lemon.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f34b.png", "objects"));
        shortCutMap.put("leo", new EmojiShortcut("leo", "leo.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/264c.png", "symbols"));
        shortCutMap.put("leopard", new EmojiShortcut("leopard", "leopard.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f406.png", "nature"));
        shortCutMap.put("libra", new EmojiShortcut("libra", "libra.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/264e.png", "symbols"));
        shortCutMap.put("light_rail", new EmojiShortcut("light_rail", "light_rail.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f688.png", "places"));
        shortCutMap.put("link", new EmojiShortcut("link", "link.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f517.png", "symbols"));
        shortCutMap.put("lips", new EmojiShortcut("lips", "lips.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f444.png", "people"));
        shortCutMap.put("lipstick", new EmojiShortcut("lipstick", "lipstick.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f484.png", "objects"));
        shortCutMap.put("lock", new EmojiShortcut("lock", "lock.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f512.png", "objects"));
        shortCutMap.put("lock_with_ink_pen", new EmojiShortcut("lock_with_ink_pen", "lock_with_ink_pen.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f50f.png", "objects"));
        shortCutMap.put("lollipop", new EmojiShortcut("lollipop", "lollipop.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f36d.png", "objects"));
        shortCutMap.put("loop", new EmojiShortcut("loop", "loop.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/27bf.png", "objects"));
        shortCutMap.put("loudspeaker", new EmojiShortcut("loudspeaker", "loudspeaker.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4e2.png", "objects"));
        shortCutMap.put("love_hotel", new EmojiShortcut("love_hotel", "love_hotel.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3e9.png", "places"));
        shortCutMap.put("love_letter", new EmojiShortcut("love_letter", "love_letter.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f48c.png", "people"));
        shortCutMap.put("low_brightness", new EmojiShortcut("low_brightness", "low_brightness.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f505.png", "objects"));
        shortCutMap.put("m", new EmojiShortcut("m", "m.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/24c2.png", "symbols"));
        shortCutMap.put("mag", new EmojiShortcut("mag", "mag.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f50d.png", "objects"));
        shortCutMap.put("mag_right", new EmojiShortcut("mag_right", "mag_right.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f50e.png", "objects"));
        shortCutMap.put("mahjong", new EmojiShortcut("mahjong", "mahjong.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f004.png", "objects"));
        shortCutMap.put("mailbox", new EmojiShortcut("mailbox", "mailbox.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4eb.png", "objects"));
        shortCutMap.put("mailbox_closed", new EmojiShortcut("mailbox_closed", "mailbox_closed.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4ea.png", "objects"));
        shortCutMap.put("mailbox_with_mail", new EmojiShortcut("mailbox_with_mail", "mailbox_with_mail.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4ec.png", "objects"));
        shortCutMap.put("mailbox_with_no_mail", new EmojiShortcut("mailbox_with_no_mail", "mailbox_with_no_mail.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4ed.png", "objects"));
        shortCutMap.put("man", new EmojiShortcut("man", "man.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f468.png", "people"));
        shortCutMap.put("man_with_gua_pi_mao", new EmojiShortcut("man_with_gua_pi_mao", "man_with_gua_pi_mao.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f472.png", "people"));
        shortCutMap.put("man_with_turban", new EmojiShortcut("man_with_turban", "man_with_turban.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f473.png", "people"));
        shortCutMap.put("mans_shoe", new EmojiShortcut("mans_shoe", "mans_shoe.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f45e.png", "objects"));
        shortCutMap.put("maple_leaf", new EmojiShortcut("maple_leaf", "maple_leaf.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f341.png", "nature"));
        shortCutMap.put("mask", new EmojiShortcut("mask", "mask.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f637.png", "people"));
        shortCutMap.put("massage", new EmojiShortcut("massage", "massage.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f486.png", "people"));
        shortCutMap.put("meat_on_bone", new EmojiShortcut("meat_on_bone", "meat_on_bone.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f356.png", "objects"));
        shortCutMap.put("mega", new EmojiShortcut("mega", "mega.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4e3.png", "objects"));
        shortCutMap.put("melon", new EmojiShortcut("melon", "melon.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f348.png", "objects"));
        shortCutMap.put("memo", new EmojiShortcut("memo", "memo.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4dd.png", "objects"));
        shortCutMap.put("mens", new EmojiShortcut("mens", "mens.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6b9.png", "symbols"));
        shortCutMap.put("metal", new EmojiShortcut("metal", "metal.png", "https://assets-cdn.github.com/images/icons/emoji/metal.png", "people"));
        shortCutMap.put("metro", new EmojiShortcut("metro", "metro.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f687.png", "symbols"));
        shortCutMap.put("microphone", new EmojiShortcut("microphone", "microphone.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3a4.png", "objects"));
        shortCutMap.put("microscope", new EmojiShortcut("microscope", "microscope.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f52c.png", "objects"));
        shortCutMap.put("milky_way", new EmojiShortcut("milky_way", "milky_way.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f30c.png", "nature"));
        shortCutMap.put("minibus", new EmojiShortcut("minibus", "minibus.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f690.png", "places"));
        shortCutMap.put("minidisc", new EmojiShortcut("minidisc", "minidisc.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4bd.png", "objects"));
        shortCutMap.put("mobile_phone_off", new EmojiShortcut("mobile_phone_off", "mobile_phone_off.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4f4.png", "symbols"));
        shortCutMap.put("money_with_wings", new EmojiShortcut("money_with_wings", "money_with_wings.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4b8.png", "objects"));
        shortCutMap.put("moneybag", new EmojiShortcut("moneybag", "moneybag.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4b0.png", "objects"));
        shortCutMap.put("monkey", new EmojiShortcut("monkey", "monkey.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f412.png", "nature"));
        shortCutMap.put("monkey_face", new EmojiShortcut("monkey_face", "monkey_face.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f435.png", "nature"));
        shortCutMap.put("monorail", new EmojiShortcut("monorail", "monorail.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f69d.png", "places"));
        shortCutMap.put("mortar_board", new EmojiShortcut("mortar_board", "mortar_board.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f393.png", "objects"));
        shortCutMap.put("mount_fuji", new EmojiShortcut("mount_fuji", "mount_fuji.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f5fb.png", "places"));
        shortCutMap.put("mountain_bicyclist", new EmojiShortcut("mountain_bicyclist", "mountain_bicyclist.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6b5.png", "objects"));
        shortCutMap.put("mountain_cableway", new EmojiShortcut("mountain_cableway", "mountain_cableway.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6a0.png", "places"));
        shortCutMap.put("mountain_railway", new EmojiShortcut("mountain_railway", "mountain_railway.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f69e.png", "places"));
        shortCutMap.put("mouse", new EmojiShortcut("mouse", "mouse.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f42d.png", "nature"));
        shortCutMap.put("mouse2", new EmojiShortcut("mouse2", "mouse2.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f401.png", "nature"));
        shortCutMap.put("movie_camera", new EmojiShortcut("movie_camera", "movie_camera.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3a5.png", "objects"));
        shortCutMap.put("moyai", new EmojiShortcut("moyai", "moyai.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f5ff.png", "places"));
        shortCutMap.put("muscle", new EmojiShortcut("muscle", "muscle.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4aa.png", "people"));
        shortCutMap.put("mushroom", new EmojiShortcut("mushroom", "mushroom.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f344.png", "nature"));
        shortCutMap.put("musical_keyboard", new EmojiShortcut("musical_keyboard", "musical_keyboard.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3b9.png", "objects"));
        shortCutMap.put("musical_note", new EmojiShortcut("musical_note", "musical_note.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3b5.png", "people"));
        shortCutMap.put("musical_score", new EmojiShortcut("musical_score", "musical_score.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3bc.png", "objects"));
        shortCutMap.put("mute", new EmojiShortcut("mute", "mute.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f507.png", "objects"));
        shortCutMap.put("nail_care", new EmojiShortcut("nail_care", "nail_care.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f485.png", "people"));
        shortCutMap.put("name_badge", new EmojiShortcut("name_badge", "name_badge.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4db.png", "objects"));
        shortCutMap.put("neckbeard", new EmojiShortcut("neckbeard", "neckbeard.png", "https://assets-cdn.github.com/images/icons/emoji/neckbeard.png", "people"));
        shortCutMap.put("necktie", new EmojiShortcut("necktie", "necktie.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f454.png", "objects"));
        shortCutMap.put("negative_squared_cross_mark", new EmojiShortcut("negative_squared_cross_mark", "negative_squared_cross_mark.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/274e.png", "symbols"));
        shortCutMap.put("neutral_face", new EmojiShortcut("neutral_face", "neutral_face.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f610.png", "people"));
        shortCutMap.put("new", new EmojiShortcut("new", "new.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f195.png", "symbols"));
        shortCutMap.put("new_moon", new EmojiShortcut("new_moon", "new_moon.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f311.png", "nature"));
        shortCutMap.put("new_moon_with_face", new EmojiShortcut("new_moon_with_face", "new_moon_with_face.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f31a.png", "nature"));
        shortCutMap.put("newspaper", new EmojiShortcut("newspaper", "newspaper.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4f0.png", "objects"));
        shortCutMap.put("ng", new EmojiShortcut("ng", "ng.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f196.png", "symbols"));
        shortCutMap.put("nine", new EmojiShortcut("nine", "nine.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/0039-20e3.png", "symbols"));
        shortCutMap.put("no_bell", new EmojiShortcut("no_bell", "no_bell.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f515.png", "objects"));
        shortCutMap.put("no_bicycles", new EmojiShortcut("no_bicycles", "no_bicycles.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6b3.png", "symbols"));
        shortCutMap.put("no_entry", new EmojiShortcut("no_entry", "no_entry.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/26d4.png", "symbols"));
        shortCutMap.put("no_entry_sign", new EmojiShortcut("no_entry_sign", "no_entry_sign.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6ab.png", "symbols"));
        shortCutMap.put("no_good", new EmojiShortcut("no_good", "no_good.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f645.png", "people"));
        shortCutMap.put("no_mobile_phones", new EmojiShortcut("no_mobile_phones", "no_mobile_phones.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4f5.png", "symbols"));
        shortCutMap.put("no_mouth", new EmojiShortcut("no_mouth", "no_mouth.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f636.png", "people"));
        shortCutMap.put("no_pedestrians", new EmojiShortcut("no_pedestrians", "no_pedestrians.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6b7.png", "symbols"));
        shortCutMap.put("no_smoking", new EmojiShortcut("no_smoking", "no_smoking.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6ad.png", "symbols"));
        shortCutMap.put("non-potable_water", new EmojiShortcut("non-potable_water", "non-potable_water.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6b1.png", "symbols"));
        shortCutMap.put("nose", new EmojiShortcut("nose", "nose.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f443.png", "people"));
        shortCutMap.put("notebook", new EmojiShortcut("notebook", "notebook.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4d3.png", "objects"));
        shortCutMap.put("notebook_with_decorative_cover", new EmojiShortcut("notebook_with_decorative_cover", "notebook_with_decorative_cover.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4d4.png", "objects"));
        shortCutMap.put("notes", new EmojiShortcut("notes", "notes.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3b6.png", "people"));
        shortCutMap.put("nut_and_bolt", new EmojiShortcut("nut_and_bolt", "nut_and_bolt.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f529.png", "objects"));
        shortCutMap.put("o", new EmojiShortcut("o", "o.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2b55.png", "symbols"));
        shortCutMap.put("o2", new EmojiShortcut("o2", "o2.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f17e.png", "symbols"));
        shortCutMap.put("ocean", new EmojiShortcut("ocean", "ocean.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f30a.png", "nature"));
        shortCutMap.put("octocat", new EmojiShortcut("octocat", "octocat.png", "https://assets-cdn.github.com/images/icons/emoji/octocat.png", "nature"));
        shortCutMap.put("octopus", new EmojiShortcut("octopus", "octopus.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f419.png", "nature"));
        shortCutMap.put("oden", new EmojiShortcut("oden", "oden.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f362.png", "objects"));
        shortCutMap.put("office", new EmojiShortcut("office", "office.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3e2.png", "places"));
        shortCutMap.put("ok", new EmojiShortcut("ok", "ok.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f197.png", "symbols"));
        shortCutMap.put("ok_hand", new EmojiShortcut("ok_hand", "ok_hand.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f44c.png", "people"));
        shortCutMap.put("ok_woman", new EmojiShortcut("ok_woman", "ok_woman.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f646.png", "people"));
        shortCutMap.put("older_man", new EmojiShortcut("older_man", "older_man.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f474.png", "people"));
        shortCutMap.put("older_woman", new EmojiShortcut("older_woman", "older_woman.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f475.png", "people"));
        shortCutMap.put("on", new EmojiShortcut("on", "on.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f51b.png", "symbols"));
        shortCutMap.put("oncoming_automobile", new EmojiShortcut("oncoming_automobile", "oncoming_automobile.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f698.png", "places"));
        shortCutMap.put("oncoming_bus", new EmojiShortcut("oncoming_bus", "oncoming_bus.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f68d.png", "places"));
        shortCutMap.put("oncoming_police_car", new EmojiShortcut("oncoming_police_car", "oncoming_police_car.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f694.png", "places"));
        shortCutMap.put("oncoming_taxi", new EmojiShortcut("oncoming_taxi", "oncoming_taxi.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f696.png", "places"));
        shortCutMap.put("one", new EmojiShortcut("one", "one.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/0031-20e3.png", "symbols"));
        shortCutMap.put("open_file_folder", new EmojiShortcut("open_file_folder", "open_file_folder.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4c2.png", "objects"));
        shortCutMap.put("open_hands", new EmojiShortcut("open_hands", "open_hands.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f450.png", "people"));
        shortCutMap.put("open_mouth", new EmojiShortcut("open_mouth", "open_mouth.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f62e.png", "people"));
        shortCutMap.put("ophiuchus", new EmojiShortcut("ophiuchus", "ophiuchus.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/26ce.png", "symbols"));
        shortCutMap.put("orange_book", new EmojiShortcut("orange_book", "orange_book.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4d9.png", "objects"));
        shortCutMap.put("outbox_tray", new EmojiShortcut("outbox_tray", "outbox_tray.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4e4.png", "objects"));
        shortCutMap.put("ox", new EmojiShortcut("ox", "ox.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f402.png", "nature"));
        shortCutMap.put("package", new EmojiShortcut("package", "package.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4e6.png", "objects"));
        shortCutMap.put("page_facing_up", new EmojiShortcut("page_facing_up", "page_facing_up.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4c4.png", "objects"));
        shortCutMap.put("page_with_curl", new EmojiShortcut("page_with_curl", "page_with_curl.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4c3.png", "objects"));
        shortCutMap.put("pager", new EmojiShortcut("pager", "pager.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4df.png", "objects"));
        shortCutMap.put("palm_tree", new EmojiShortcut("palm_tree", "palm_tree.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f334.png", "nature"));
        shortCutMap.put("panda_face", new EmojiShortcut("panda_face", "panda_face.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f43c.png", "nature"));
        shortCutMap.put("paperclip", new EmojiShortcut("paperclip", "paperclip.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4ce.png", "objects"));
        shortCutMap.put("parking", new EmojiShortcut("parking", "parking.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f17f.png", "symbols"));
        shortCutMap.put("part_alternation_mark", new EmojiShortcut("part_alternation_mark", "part_alternation_mark.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/303d.png", "symbols"));
        shortCutMap.put("partly_sunny", new EmojiShortcut("partly_sunny", "partly_sunny.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/26c5.png", "nature"));
        shortCutMap.put("passport_control", new EmojiShortcut("passport_control", "passport_control.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6c2.png", "symbols"));
        shortCutMap.put("paw_prints", new EmojiShortcut("paw_prints", "paw_prints.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f43e.png", "nature"));
        shortCutMap.put("peach", new EmojiShortcut("peach", "peach.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f351.png", "objects"));
        shortCutMap.put("pear", new EmojiShortcut("pear", "pear.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f350.png", "objects"));
        shortCutMap.put("pencil", new EmojiShortcut("pencil", "pencil.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4dd.png", "objects"));
        shortCutMap.put("pencil2", new EmojiShortcut("pencil2", "pencil2.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/270f.png", "objects"));
        shortCutMap.put("penguin", new EmojiShortcut("penguin", "penguin.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f427.png", "nature"));
        shortCutMap.put("pensive", new EmojiShortcut("pensive", "pensive.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f614.png", "people"));
        shortCutMap.put("performing_arts", new EmojiShortcut("performing_arts", "performing_arts.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3ad.png", "places"));
        shortCutMap.put("persevere", new EmojiShortcut("persevere", "persevere.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f623.png", "people"));
        shortCutMap.put("person_frowning", new EmojiShortcut("person_frowning", "person_frowning.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f64d.png", "people"));
        shortCutMap.put("person_with_blond_hair", new EmojiShortcut("person_with_blond_hair", "person_with_blond_hair.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f471.png", "people"));
        shortCutMap.put("person_with_pouting_face", new EmojiShortcut("person_with_pouting_face", "person_with_pouting_face.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f64e.png", "people"));
        shortCutMap.put("phone", new EmojiShortcut("phone", "phone.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/260e.png", "objects"));
        shortCutMap.put("pig", new EmojiShortcut("pig", "pig.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f437.png", "nature"));
        shortCutMap.put("pig2", new EmojiShortcut("pig2", "pig2.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f416.png", "nature"));
        shortCutMap.put("pig_nose", new EmojiShortcut("pig_nose", "pig_nose.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f43d.png", "nature"));
        shortCutMap.put("pill", new EmojiShortcut("pill", "pill.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f48a.png", "objects"));
        shortCutMap.put("pineapple", new EmojiShortcut("pineapple", "pineapple.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f34d.png", "objects"));
        shortCutMap.put("pisces", new EmojiShortcut("pisces", "pisces.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2653.png", "symbols"));
        shortCutMap.put("pizza", new EmojiShortcut("pizza", "pizza.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f355.png", "objects"));
        shortCutMap.put("point_down", new EmojiShortcut("point_down", "point_down.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f447.png", "people"));
        shortCutMap.put("point_left", new EmojiShortcut("point_left", "point_left.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f448.png", "people"));
        shortCutMap.put("point_right", new EmojiShortcut("point_right", "point_right.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f449.png", "people"));
        shortCutMap.put("point_up", new EmojiShortcut("point_up", "point_up.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/261d.png", "people"));
        shortCutMap.put("point_up_2", new EmojiShortcut("point_up_2", "point_up_2.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f446.png", "people"));
        shortCutMap.put("police_car", new EmojiShortcut("police_car", "police_car.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f693.png", "places"));
        shortCutMap.put("poodle", new EmojiShortcut("poodle", "poodle.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f429.png", "nature"));
        shortCutMap.put("poop", new EmojiShortcut("poop", "poop.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4a9.png", "people"));
        shortCutMap.put("post_office", new EmojiShortcut("post_office", "post_office.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3e3.png", "places"));
        shortCutMap.put("postal_horn", new EmojiShortcut("postal_horn", "postal_horn.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4ef.png", "objects"));
        shortCutMap.put("postbox", new EmojiShortcut("postbox", "postbox.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4ee.png", "objects"));
        shortCutMap.put("potable_water", new EmojiShortcut("potable_water", "potable_water.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6b0.png", "symbols"));
        shortCutMap.put("pouch", new EmojiShortcut("pouch", "pouch.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f45d.png", "objects"));
        shortCutMap.put("poultry_leg", new EmojiShortcut("poultry_leg", "poultry_leg.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f357.png", "objects"));
        shortCutMap.put("pound", new EmojiShortcut("pound", "pound.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4b7.png", "objects"));
        shortCutMap.put("pouting_cat", new EmojiShortcut("pouting_cat", "pouting_cat.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f63e.png", "people"));
        shortCutMap.put("pray", new EmojiShortcut("pray", "pray.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f64f.png", "people"));
        shortCutMap.put("princess", new EmojiShortcut("princess", "princess.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f478.png", "people"));
        shortCutMap.put("punch", new EmojiShortcut("punch", "punch.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f44a.png", "people"));
        shortCutMap.put("purple_heart", new EmojiShortcut("purple_heart", "purple_heart.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f49c.png", "people"));
        shortCutMap.put("purse", new EmojiShortcut("purse", "purse.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f45b.png", "objects"));
        shortCutMap.put("pushpin", new EmojiShortcut("pushpin", "pushpin.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4cc.png", "objects"));
        shortCutMap.put("put_litter_in_its_place", new EmojiShortcut("put_litter_in_its_place", "put_litter_in_its_place.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6ae.png", "symbols"));
        shortCutMap.put("question", new EmojiShortcut("question", "question.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2753.png", "people"));
        shortCutMap.put("rabbit", new EmojiShortcut("rabbit", "rabbit.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f430.png", "nature"));
        shortCutMap.put("rabbit2", new EmojiShortcut("rabbit2", "rabbit2.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f407.png", "nature"));
        shortCutMap.put("racehorse", new EmojiShortcut("racehorse", "racehorse.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f40e.png", "nature"));
        shortCutMap.put("radio", new EmojiShortcut("radio", "radio.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4fb.png", "objects"));
        shortCutMap.put("radio_button", new EmojiShortcut("radio_button", "radio_button.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f518.png", "symbols"));
        shortCutMap.put("rage", new EmojiShortcut("rage", "rage.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f621.png", "people"));
        shortCutMap.put("rage1", new EmojiShortcut("rage1", "rage1.png", "https://assets-cdn.github.com/images/icons/emoji/rage1.png", "people"));
        shortCutMap.put("rage2", new EmojiShortcut("rage2", "rage2.png", "https://assets-cdn.github.com/images/icons/emoji/rage2.png", "people"));
        shortCutMap.put("rage3", new EmojiShortcut("rage3", "rage3.png", "https://assets-cdn.github.com/images/icons/emoji/rage3.png", "people"));
        shortCutMap.put("rage4", new EmojiShortcut("rage4", "rage4.png", "https://assets-cdn.github.com/images/icons/emoji/rage4.png", "people"));
        shortCutMap.put("railway_car", new EmojiShortcut("railway_car", "railway_car.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f683.png", "places"));
        shortCutMap.put("rainbow", new EmojiShortcut("rainbow", "rainbow.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f308.png", "places"));
        shortCutMap.put("raised_hand", new EmojiShortcut("raised_hand", "raised_hand.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/270b.png", "people"));
        shortCutMap.put("raised_hands", new EmojiShortcut("raised_hands", "raised_hands.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f64c.png", "people"));
        shortCutMap.put("raising_hand", new EmojiShortcut("raising_hand", "raising_hand.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f64b.png", "people"));
        shortCutMap.put("ram", new EmojiShortcut("ram", "ram.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f40f.png", "nature"));
        shortCutMap.put("ramen", new EmojiShortcut("ramen", "ramen.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f35c.png", "objects"));
        shortCutMap.put("rat", new EmojiShortcut("rat", "rat.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f400.png", "nature"));
        shortCutMap.put("recycle", new EmojiShortcut("recycle", "recycle.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/267b.png", "symbols"));
        shortCutMap.put("red_car", new EmojiShortcut("red_car", "red_car.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f697.png", "places"));
        shortCutMap.put("red_circle", new EmojiShortcut("red_circle", "red_circle.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f534.png", "symbols"));
        shortCutMap.put("registered", new EmojiShortcut("registered", "registered.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/00ae.png", "symbols"));
        shortCutMap.put("relaxed", new EmojiShortcut("relaxed", "relaxed.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/263a.png", "people"));
        shortCutMap.put("relieved", new EmojiShortcut("relieved", "relieved.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f60c.png", "people"));
        shortCutMap.put("repeat", new EmojiShortcut("repeat", "repeat.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f501.png", "symbols"));
        shortCutMap.put("repeat_one", new EmojiShortcut("repeat_one", "repeat_one.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f502.png", "symbols"));
        shortCutMap.put("restroom", new EmojiShortcut("restroom", "restroom.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6bb.png", "symbols"));
        shortCutMap.put("revolving_hearts", new EmojiShortcut("revolving_hearts", "revolving_hearts.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f49e.png", "people"));
        shortCutMap.put("rewind", new EmojiShortcut("rewind", "rewind.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/23ea.png", "symbols"));
        shortCutMap.put("ribbon", new EmojiShortcut("ribbon", "ribbon.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f380.png", "objects"));
        shortCutMap.put("rice", new EmojiShortcut("rice", "rice.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f35a.png", "objects"));
        shortCutMap.put("rice_ball", new EmojiShortcut("rice_ball", "rice_ball.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f359.png", "objects"));
        shortCutMap.put("rice_cracker", new EmojiShortcut("rice_cracker", "rice_cracker.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f358.png", "objects"));
        shortCutMap.put("rice_scene", new EmojiShortcut("rice_scene", "rice_scene.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f391.png", "objects"));
        shortCutMap.put("ring", new EmojiShortcut("ring", "ring.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f48d.png", "objects"));
        shortCutMap.put("rocket", new EmojiShortcut("rocket", "rocket.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f680.png", "places"));
        shortCutMap.put("roller_coaster", new EmojiShortcut("roller_coaster", "roller_coaster.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3a2.png", "places"));
        shortCutMap.put("rooster", new EmojiShortcut("rooster", "rooster.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f413.png", "nature"));
        shortCutMap.put("rose", new EmojiShortcut("rose", "rose.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f339.png", "nature"));
        shortCutMap.put("rotating_light", new EmojiShortcut("rotating_light", "rotating_light.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6a8.png", "places"));
        shortCutMap.put("round_pushpin", new EmojiShortcut("round_pushpin", "round_pushpin.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4cd.png", "places"));
        shortCutMap.put("rowboat", new EmojiShortcut("rowboat", "rowboat.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6a3.png", "places"));
        shortCutMap.put("ru", new EmojiShortcut("ru", "ru.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f1f7-1f1fa.png", "places"));
        shortCutMap.put("rugby_football", new EmojiShortcut("rugby_football", "rugby_football.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3c9.png", "objects"));
        shortCutMap.put("runner", new EmojiShortcut("runner", "runner.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3c3.png", "people"));
        shortCutMap.put("running", new EmojiShortcut("running", "running.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3c3.png", "people"));
        shortCutMap.put("running_shirt_with_sash", new EmojiShortcut("running_shirt_with_sash", "running_shirt_with_sash.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3bd.png", "objects"));
        shortCutMap.put("sa", new EmojiShortcut("sa", "sa.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f202.png", "symbols"));
        shortCutMap.put("sagittarius", new EmojiShortcut("sagittarius", "sagittarius.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2650.png", "symbols"));
        shortCutMap.put("sailboat", new EmojiShortcut("sailboat", "sailboat.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/26f5.png", "places"));
        shortCutMap.put("sake", new EmojiShortcut("sake", "sake.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f376.png", "objects"));
        shortCutMap.put("sandal", new EmojiShortcut("sandal", "sandal.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f461.png", "objects"));
        shortCutMap.put("santa", new EmojiShortcut("santa", "santa.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f385.png", "objects"));
        shortCutMap.put("satellite", new EmojiShortcut("satellite", "satellite.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4e1.png", "objects"));
        shortCutMap.put("satisfied", new EmojiShortcut("satisfied", "satisfied.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f606.png", "people"));
        shortCutMap.put("saxophone", new EmojiShortcut("saxophone", "saxophone.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3b7.png", "objects"));
        shortCutMap.put("school", new EmojiShortcut("school", "school.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3eb.png", "places"));
        shortCutMap.put("school_satchel", new EmojiShortcut("school_satchel", "school_satchel.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f392.png", "objects"));
        shortCutMap.put("scissors", new EmojiShortcut("scissors", "scissors.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2702.png", "objects"));
        shortCutMap.put("scorpius", new EmojiShortcut("scorpius", "scorpius.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/264f.png", "symbols"));
        shortCutMap.put("scream", new EmojiShortcut("scream", "scream.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f631.png", "people"));
        shortCutMap.put("scream_cat", new EmojiShortcut("scream_cat", "scream_cat.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f640.png", "people"));
        shortCutMap.put("scroll", new EmojiShortcut("scroll", "scroll.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4dc.png", "objects"));
        shortCutMap.put("seat", new EmojiShortcut("seat", "seat.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4ba.png", "objects"));
        shortCutMap.put("secret", new EmojiShortcut("secret", "secret.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/3299.png", "symbols"));
        shortCutMap.put("see_no_evil", new EmojiShortcut("see_no_evil", "see_no_evil.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f648.png", "people"));
        shortCutMap.put("seedling", new EmojiShortcut("seedling", "seedling.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f331.png", "nature"));
        shortCutMap.put("seven", new EmojiShortcut("seven", "seven.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/0037-20e3.png", "symbols"));
        shortCutMap.put("shaved_ice", new EmojiShortcut("shaved_ice", "shaved_ice.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f367.png", "objects"));
        shortCutMap.put("sheep", new EmojiShortcut("sheep", "sheep.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f411.png", "nature"));
        shortCutMap.put("shell", new EmojiShortcut("shell", "shell.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f41a.png", "nature"));
        shortCutMap.put("ship", new EmojiShortcut("ship", "ship.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6a2.png", "places"));
        shortCutMap.put("shipit", new EmojiShortcut("shipit", "shipit.png", "https://assets-cdn.github.com/images/icons/emoji/shipit.png", "symbols"));
        shortCutMap.put("shirt", new EmojiShortcut("shirt", "shirt.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f455.png", "objects"));
        shortCutMap.put("shit", new EmojiShortcut("shit", "shit.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4a9.png", "people"));
        shortCutMap.put("shoe", new EmojiShortcut("shoe", "shoe.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f45e.png", "objects"));
        shortCutMap.put("shower", new EmojiShortcut("shower", "shower.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6bf.png", "objects"));
        shortCutMap.put("signal_strength", new EmojiShortcut("signal_strength", "signal_strength.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4f6.png", "symbols"));
        shortCutMap.put("simple_smile", new EmojiShortcut("simple_smile", "simple_smile.png", null, "people"));
        shortCutMap.put("six", new EmojiShortcut("six", "six.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/0036-20e3.png", "symbols"));
        shortCutMap.put("six_pointed_star", new EmojiShortcut("six_pointed_star", "six_pointed_star.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f52f.png", "symbols"));
        shortCutMap.put("ski", new EmojiShortcut("ski", "ski.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3bf.png", "objects"));
        shortCutMap.put("skull", new EmojiShortcut("skull", "skull.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f480.png", "people"));
        shortCutMap.put("sleeping", new EmojiShortcut("sleeping", "sleeping.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f634.png", "people"));
        shortCutMap.put("sleepy", new EmojiShortcut("sleepy", "sleepy.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f62a.png", "people"));
        shortCutMap.put("slot_machine", new EmojiShortcut("slot_machine", "slot_machine.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3b0.png", "places"));
        shortCutMap.put("small_blue_diamond", new EmojiShortcut("small_blue_diamond", "small_blue_diamond.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f539.png", "symbols"));
        shortCutMap.put("small_orange_diamond", new EmojiShortcut("small_orange_diamond", "small_orange_diamond.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f538.png", "symbols"));
        shortCutMap.put("small_red_triangle", new EmojiShortcut("small_red_triangle", "small_red_triangle.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f53a.png", "symbols"));
        shortCutMap.put("small_red_triangle_down", new EmojiShortcut("small_red_triangle_down", "small_red_triangle_down.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f53b.png", "symbols"));
        shortCutMap.put("smile", new EmojiShortcut("smile", "smile.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f604.png", "people"));
        shortCutMap.put("smile_cat", new EmojiShortcut("smile_cat", "smile_cat.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f638.png", "people"));
        shortCutMap.put("smiley", new EmojiShortcut("smiley", "smiley.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f603.png", "people"));
        shortCutMap.put("smiley_cat", new EmojiShortcut("smiley_cat", "smiley_cat.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f63a.png", "people"));
        shortCutMap.put("smiling_imp", new EmojiShortcut("smiling_imp", "smiling_imp.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f608.png", "people"));
        shortCutMap.put("smirk", new EmojiShortcut("smirk", "smirk.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f60f.png", "people"));
        shortCutMap.put("smirk_cat", new EmojiShortcut("smirk_cat", "smirk_cat.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f63c.png", "people"));
        shortCutMap.put("smoking", new EmojiShortcut("smoking", "smoking.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6ac.png", "objects"));
        shortCutMap.put("snail", new EmojiShortcut("snail", "snail.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f40c.png", "nature"));
        shortCutMap.put("snake", new EmojiShortcut("snake", "snake.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f40d.png", "nature"));
        shortCutMap.put("snowboarder", new EmojiShortcut("snowboarder", "snowboarder.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3c2.png", "objects"));
        shortCutMap.put("snowflake", new EmojiShortcut("snowflake", "snowflake.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2744.png", "nature"));
        shortCutMap.put("snowman", new EmojiShortcut("snowman", "snowman.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/26c4.png", "nature"));
        shortCutMap.put("sob", new EmojiShortcut("sob", "sob.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f62d.png", "people"));
        shortCutMap.put("soccer", new EmojiShortcut("soccer", "soccer.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/26bd.png", "objects"));
        shortCutMap.put("soon", new EmojiShortcut("soon", "soon.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f51c.png", "symbols"));
        shortCutMap.put("sos", new EmojiShortcut("sos", "sos.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f198.png", "symbols"));
        shortCutMap.put("sound", new EmojiShortcut("sound", "sound.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f509.png", "objects"));
        shortCutMap.put("space_invader", new EmojiShortcut("space_invader", "space_invader.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f47e.png", "objects"));
        shortCutMap.put("spades", new EmojiShortcut("spades", "spades.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2660.png", "objects"));
        shortCutMap.put("spaghetti", new EmojiShortcut("spaghetti", "spaghetti.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f35d.png", "objects"));
        shortCutMap.put("sparkle", new EmojiShortcut("sparkle", "sparkle.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2747.png", "symbols"));
        shortCutMap.put("sparkler", new EmojiShortcut("sparkler", "sparkler.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f387.png", "objects"));
        shortCutMap.put("sparkles", new EmojiShortcut("sparkles", "sparkles.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2728.png", "people"));
        shortCutMap.put("sparkling_heart", new EmojiShortcut("sparkling_heart", "sparkling_heart.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f496.png", "people"));
        shortCutMap.put("speak_no_evil", new EmojiShortcut("speak_no_evil", "speak_no_evil.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f64a.png", "people"));
        shortCutMap.put("speaker", new EmojiShortcut("speaker", "speaker.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f508.png", "objects"));
        shortCutMap.put("speech_balloon", new EmojiShortcut("speech_balloon", "speech_balloon.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4ac.png", "people"));
        shortCutMap.put("speedboat", new EmojiShortcut("speedboat", "speedboat.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6a4.png", "places"));
        shortCutMap.put("squirrel", new EmojiShortcut("squirrel", "squirrel.png", "https://assets-cdn.github.com/images/icons/emoji/shipit.png", "nature"));
        shortCutMap.put("star", new EmojiShortcut("star", "star.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2b50.png", "people"));
        shortCutMap.put("star2", new EmojiShortcut("star2", "star2.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f31f.png", "people"));
        shortCutMap.put("stars", new EmojiShortcut("stars", "stars.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f320.png", "places"));
        shortCutMap.put("station", new EmojiShortcut("station", "station.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f689.png", "places"));
        shortCutMap.put("statue_of_liberty", new EmojiShortcut("statue_of_liberty", "statue_of_liberty.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f5fd.png", "places"));
        shortCutMap.put("steam_locomotive", new EmojiShortcut("steam_locomotive", "steam_locomotive.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f682.png", "places"));
        shortCutMap.put("stew", new EmojiShortcut("stew", "stew.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f372.png", "objects"));
        shortCutMap.put("straight_ruler", new EmojiShortcut("straight_ruler", "straight_ruler.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4cf.png", "objects"));
        shortCutMap.put("strawberry", new EmojiShortcut("strawberry", "strawberry.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f353.png", "objects"));
        shortCutMap.put("stuck_out_tongue", new EmojiShortcut("stuck_out_tongue", "stuck_out_tongue.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f61b.png", "people"));
        shortCutMap.put("stuck_out_tongue_closed_eyes", new EmojiShortcut("stuck_out_tongue_closed_eyes", "stuck_out_tongue_closed_eyes.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f61d.png", "people"));
        shortCutMap.put("stuck_out_tongue_winking_eye", new EmojiShortcut("stuck_out_tongue_winking_eye", "stuck_out_tongue_winking_eye.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f61c.png", "people"));
        shortCutMap.put("sun_with_face", new EmojiShortcut("sun_with_face", "sun_with_face.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f31e.png", "nature"));
        shortCutMap.put("sunflower", new EmojiShortcut("sunflower", "sunflower.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f33b.png", "nature"));
        shortCutMap.put("sunglasses", new EmojiShortcut("sunglasses", "sunglasses.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f60e.png", "people"));
        shortCutMap.put("sunny", new EmojiShortcut("sunny", "sunny.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2600.png", "nature"));
        shortCutMap.put("sunrise", new EmojiShortcut("sunrise", "sunrise.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f305.png", "places"));
        shortCutMap.put("sunrise_over_mountains", new EmojiShortcut("sunrise_over_mountains", "sunrise_over_mountains.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f304.png", "places"));
        shortCutMap.put("surfer", new EmojiShortcut("surfer", "surfer.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3c4.png", "objects"));
        shortCutMap.put("sushi", new EmojiShortcut("sushi", "sushi.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f363.png", "objects"));
        shortCutMap.put("suspect", new EmojiShortcut("suspect", "suspect.png", "https://assets-cdn.github.com/images/icons/emoji/suspect.png", "people"));
        shortCutMap.put("suspension_railway", new EmojiShortcut("suspension_railway", "suspension_railway.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f69f.png", "places"));
        shortCutMap.put("sweat", new EmojiShortcut("sweat", "sweat.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f613.png", "people"));
        shortCutMap.put("sweat_drops", new EmojiShortcut("sweat_drops", "sweat_drops.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4a6.png", "people"));
        shortCutMap.put("sweat_smile", new EmojiShortcut("sweat_smile", "sweat_smile.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f605.png", "people"));
        shortCutMap.put("sweet_potato", new EmojiShortcut("sweet_potato", "sweet_potato.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f360.png", "objects"));
        shortCutMap.put("swimmer", new EmojiShortcut("swimmer", "swimmer.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3ca.png", "objects"));
        shortCutMap.put("symbols", new EmojiShortcut("symbols", "symbols.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f523.png", "symbols"));
        shortCutMap.put("syringe", new EmojiShortcut("syringe", "syringe.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f489.png", "objects"));
        shortCutMap.put("tada", new EmojiShortcut("tada", "tada.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f389.png", "objects"));
        shortCutMap.put("tanabata_tree", new EmojiShortcut("tanabata_tree", "tanabata_tree.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f38b.png", "objects"));
        shortCutMap.put("tangerine", new EmojiShortcut("tangerine", "tangerine.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f34a.png", "objects"));
        shortCutMap.put("taurus", new EmojiShortcut("taurus", "taurus.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2649.png", "symbols"));
        shortCutMap.put("taxi", new EmojiShortcut("taxi", "taxi.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f695.png", "places"));
        shortCutMap.put("tea", new EmojiShortcut("tea", "tea.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f375.png", "objects"));
        shortCutMap.put("telephone", new EmojiShortcut("telephone", "telephone.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/260e.png", "objects"));
        shortCutMap.put("telephone_receiver", new EmojiShortcut("telephone_receiver", "telephone_receiver.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4de.png", "objects"));
        shortCutMap.put("telescope", new EmojiShortcut("telescope", "telescope.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f52d.png", "objects"));
        shortCutMap.put("tennis", new EmojiShortcut("tennis", "tennis.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3be.png", "objects"));
        shortCutMap.put("tent", new EmojiShortcut("tent", "tent.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/26fa.png", "places"));
        shortCutMap.put("thought_balloon", new EmojiShortcut("thought_balloon", "thought_balloon.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4ad.png", "people"));
        shortCutMap.put("three", new EmojiShortcut("three", "three.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/0033-20e3.png", "symbols"));
        shortCutMap.put("thumbsdown", new EmojiShortcut("thumbsdown", "thumbsdown.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f44e.png", "people"));
        shortCutMap.put("thumbsup", new EmojiShortcut("thumbsup", "thumbsup.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f44d.png", "people"));
        shortCutMap.put("ticket", new EmojiShortcut("ticket", "ticket.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3ab.png", "places"));
        shortCutMap.put("tiger", new EmojiShortcut("tiger", "tiger.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f42f.png", "nature"));
        shortCutMap.put("tiger2", new EmojiShortcut("tiger2", "tiger2.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f405.png", "nature"));
        shortCutMap.put("tired_face", new EmojiShortcut("tired_face", "tired_face.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f62b.png", "people"));
        shortCutMap.put("tm", new EmojiShortcut("tm", "tm.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2122.png", "symbols"));
        shortCutMap.put("toilet", new EmojiShortcut("toilet", "toilet.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6bd.png", "objects"));
        shortCutMap.put("tokyo_tower", new EmojiShortcut("tokyo_tower", "tokyo_tower.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f5fc.png", "places"));
        shortCutMap.put("tomato", new EmojiShortcut("tomato", "tomato.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f345.png", "objects"));
        shortCutMap.put("tongue", new EmojiShortcut("tongue", "tongue.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f445.png", "people"));
        shortCutMap.put("top", new EmojiShortcut("top", "top.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f51d.png", "symbols"));
        shortCutMap.put("tophat", new EmojiShortcut("tophat", "tophat.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3a9.png", "objects"));
        shortCutMap.put("tractor", new EmojiShortcut("tractor", "tractor.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f69c.png", "places"));
        shortCutMap.put("traffic_light", new EmojiShortcut("traffic_light", "traffic_light.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6a5.png", "places"));
        shortCutMap.put("train", new EmojiShortcut("train", "train.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f68b.png", "places"));
        shortCutMap.put("train2", new EmojiShortcut("train2", "train2.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f686.png", "places"));
        shortCutMap.put("tram", new EmojiShortcut("tram", "tram.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f68a.png", "places"));
        shortCutMap.put("triangular_flag_on_post", new EmojiShortcut("triangular_flag_on_post", "triangular_flag_on_post.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6a9.png", "places"));
        shortCutMap.put("triangular_ruler", new EmojiShortcut("triangular_ruler", "triangular_ruler.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4d0.png", "objects"));
        shortCutMap.put("trident", new EmojiShortcut("trident", "trident.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f531.png", "symbols"));
        shortCutMap.put("triumph", new EmojiShortcut("triumph", "triumph.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f624.png", "people"));
        shortCutMap.put("trolleybus", new EmojiShortcut("trolleybus", "trolleybus.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f68e.png", "places"));
        shortCutMap.put("trollface", new EmojiShortcut("trollface", "trollface.png", "https://assets-cdn.github.com/images/icons/emoji/trollface.png", "people"));
        shortCutMap.put("trophy", new EmojiShortcut("trophy", "trophy.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3c6.png", "objects"));
        shortCutMap.put("tropical_drink", new EmojiShortcut("tropical_drink", "tropical_drink.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f379.png", "objects"));
        shortCutMap.put("tropical_fish", new EmojiShortcut("tropical_fish", "tropical_fish.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f420.png", "nature"));
        shortCutMap.put("truck", new EmojiShortcut("truck", "truck.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f69a.png", "places"));
        shortCutMap.put("trumpet", new EmojiShortcut("trumpet", "trumpet.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3ba.png", "objects"));
        shortCutMap.put("tshirt", new EmojiShortcut("tshirt", "tshirt.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f455.png", "objects"));
        shortCutMap.put("tulip", new EmojiShortcut("tulip", "tulip.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f337.png", "nature"));
        shortCutMap.put("turtle", new EmojiShortcut("turtle", "turtle.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f422.png", "nature"));
        shortCutMap.put("tv", new EmojiShortcut("tv", "tv.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4fa.png", "objects"));
        shortCutMap.put("twisted_rightwards_arrows", new EmojiShortcut("twisted_rightwards_arrows", "twisted_rightwards_arrows.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f500.png", "symbols"));
        shortCutMap.put("two", new EmojiShortcut("two", "two.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/0032-20e3.png", "symbols"));
        shortCutMap.put("two_hearts", new EmojiShortcut("two_hearts", "two_hearts.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f495.png", "people"));
        shortCutMap.put("two_men_holding_hands", new EmojiShortcut("two_men_holding_hands", "two_men_holding_hands.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f46c.png", "people"));
        shortCutMap.put("two_women_holding_hands", new EmojiShortcut("two_women_holding_hands", "two_women_holding_hands.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f46d.png", "people"));
        shortCutMap.put("u6e80", new EmojiShortcut("u6e80", "u6e80.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f235.png", "symbols"));
        shortCutMap.put("u7a7a", new EmojiShortcut("u7a7a", "u7a7a.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f233.png", "symbols"));
        shortCutMap.put("u55b6", new EmojiShortcut("u55b6", "u55b6.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f23a.png", "symbols"));
        shortCutMap.put("u5272", new EmojiShortcut("u5272", "u5272.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f239.png", "symbols"));
        shortCutMap.put("u5408", new EmojiShortcut("u5408", "u5408.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f234.png", "symbols"));
        shortCutMap.put("u6307", new EmojiShortcut("u6307", "u6307.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f22f.png", "symbols"));
        shortCutMap.put("u6708", new EmojiShortcut("u6708", "u6708.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f237.png", "symbols"));
        shortCutMap.put("u6709", new EmojiShortcut("u6709", "u6709.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f236.png", "symbols"));
        shortCutMap.put("u7121", new EmojiShortcut("u7121", "u7121.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f21a.png", "symbols"));
        shortCutMap.put("u7533", new EmojiShortcut("u7533", "u7533.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f238.png", "symbols"));
        shortCutMap.put("u7981", new EmojiShortcut("u7981", "u7981.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f232.png", "symbols"));
        shortCutMap.put("uk", new EmojiShortcut("uk", "uk.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f1ec-1f1e7.png", "places"));
        shortCutMap.put("umbrella", new EmojiShortcut("umbrella", "umbrella.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2614.png", "nature"));
        shortCutMap.put("unamused", new EmojiShortcut("unamused", "unamused.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f612.png", "people"));
        shortCutMap.put("underage", new EmojiShortcut("underage", "underage.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f51e.png", "symbols"));
        shortCutMap.put("unlock", new EmojiShortcut("unlock", "unlock.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f513.png", "objects"));
        shortCutMap.put("up", new EmojiShortcut("up", "up.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f199.png", "symbols"));
        shortCutMap.put("us", new EmojiShortcut("us", "us.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f1fa-1f1f8.png", "places"));
        shortCutMap.put("v", new EmojiShortcut("v", "v.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/270c.png", "people"));
        shortCutMap.put("vertical_traffic_light", new EmojiShortcut("vertical_traffic_light", "vertical_traffic_light.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6a6.png", "places"));
        shortCutMap.put("vhs", new EmojiShortcut("vhs", "vhs.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4fc.png", "objects"));
        shortCutMap.put("vibration_mode", new EmojiShortcut("vibration_mode", "vibration_mode.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4f3.png", "symbols"));
        shortCutMap.put("video_camera", new EmojiShortcut("video_camera", "video_camera.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4f9.png", "objects"));
        shortCutMap.put("video_game", new EmojiShortcut("video_game", "video_game.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3ae.png", "objects"));
        shortCutMap.put("violin", new EmojiShortcut("violin", "violin.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f3bb.png", "objects"));
        shortCutMap.put("virgo", new EmojiShortcut("virgo", "virgo.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/264d.png", "symbols"));
        shortCutMap.put("volcano", new EmojiShortcut("volcano", "volcano.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f30b.png", "nature"));
        shortCutMap.put("vs", new EmojiShortcut("vs", "vs.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f19a.png", "symbols"));
        shortCutMap.put("walking_man", new EmojiShortcut("walking_man", "walking.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6b6.png", "people"));
        shortCutMap.put("waning_crescent_moon", new EmojiShortcut("waning_crescent_moon", "waning_crescent_moon.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f318.png", "nature"));
        shortCutMap.put("waning_gibbous_moon", new EmojiShortcut("waning_gibbous_moon", "waning_gibbous_moon.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f316.png", "nature"));
        shortCutMap.put("warning", new EmojiShortcut("warning", "warning.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/26a0.png", "places"));
        shortCutMap.put("watch", new EmojiShortcut("watch", "watch.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/231a.png", "objects"));
        shortCutMap.put("water_buffalo", new EmojiShortcut("water_buffalo", "water_buffalo.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f403.png", "nature"));
        shortCutMap.put("watermelon", new EmojiShortcut("watermelon", "watermelon.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f349.png", "objects"));
        shortCutMap.put("wave", new EmojiShortcut("wave", "wave.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f44b.png", "people"));
        shortCutMap.put("wavy_dash", new EmojiShortcut("wavy_dash", "wavy_dash.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/3030.png", "symbols"));
        shortCutMap.put("waxing_crescent_moon", new EmojiShortcut("waxing_crescent_moon", "waxing_crescent_moon.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f312.png", "nature"));
        shortCutMap.put("waxing_gibbous_moon", new EmojiShortcut("waxing_gibbous_moon", "waxing_gibbous_moon.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f314.png", "nature"));
        shortCutMap.put("wc", new EmojiShortcut("wc", "wc.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6be.png", "symbols"));
        shortCutMap.put("weary", new EmojiShortcut("weary", "weary.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f629.png", "people"));
        shortCutMap.put("wedding", new EmojiShortcut("wedding", "wedding.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f492.png", "places"));
        shortCutMap.put("whale", new EmojiShortcut("whale", "whale.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f433.png", "nature"));
        shortCutMap.put("whale2", new EmojiShortcut("whale2", "whale2.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f40b.png", "nature"));
        shortCutMap.put("wheelchair", new EmojiShortcut("wheelchair", "wheelchair.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/267f.png", "symbols"));
        shortCutMap.put("white_check_mark", new EmojiShortcut("white_check_mark", "white_check_mark.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2705.png", "symbols"));
        shortCutMap.put("white_circle", new EmojiShortcut("white_circle", "white_circle.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/26aa.png", "symbols"));
        shortCutMap.put("white_flower", new EmojiShortcut("white_flower", "white_flower.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4ae.png", "symbols"));
        shortCutMap.put("white_large_square", new EmojiShortcut("white_large_square", "white_large_square.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/2b1c.png", "symbols"));
        shortCutMap.put("white_medium_small_square", new EmojiShortcut("white_medium_small_square", "white_medium_small_square.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/25fd.png", "symbols"));
        shortCutMap.put("white_medium_square", new EmojiShortcut("white_medium_square", "white_medium_square.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/25fb.png", "symbols"));
        shortCutMap.put("white_small_square", new EmojiShortcut("white_small_square", "white_small_square.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/25ab.png", "symbols"));
        shortCutMap.put("white_square_button", new EmojiShortcut("white_square_button", "white_square_button.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f533.png", "symbols"));
        shortCutMap.put("wind_chime", new EmojiShortcut("wind_chime", "wind_chime.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f390.png", "objects"));
        shortCutMap.put("wine_glass", new EmojiShortcut("wine_glass", "wine_glass.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f377.png", "objects"));
        shortCutMap.put("wink", new EmojiShortcut("wink", "wink.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f609.png", "people"));
        shortCutMap.put("wolf", new EmojiShortcut("wolf", "wolf.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f43a.png", "nature"));
        shortCutMap.put("woman", new EmojiShortcut("woman", "woman.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f469.png", "people"));
        shortCutMap.put("womans_clothes", new EmojiShortcut("womans_clothes", "womans_clothes.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f45a.png", "objects"));
        shortCutMap.put("womans_hat", new EmojiShortcut("womans_hat", "womans_hat.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f452.png", "objects"));
        shortCutMap.put("womens", new EmojiShortcut("womens", "womens.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f6ba.png", "symbols"));
        shortCutMap.put("worried", new EmojiShortcut("worried", "worried.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f61f.png", "people"));
        shortCutMap.put("wrench", new EmojiShortcut("wrench", "wrench.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f527.png", "objects"));
        shortCutMap.put("x", new EmojiShortcut("x", "x.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/274c.png", "symbols"));
        shortCutMap.put("yellow_heart", new EmojiShortcut("yellow_heart", "yellow_heart.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f49b.png", "people"));
        shortCutMap.put("yen", new EmojiShortcut("yen", "yen.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4b4.png", "objects"));
        shortCutMap.put("yum", new EmojiShortcut("yum", "yum.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f60b.png", "people"));
        shortCutMap.put("zap", new EmojiShortcut("zap", "zap.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/26a1.png", "nature"));
        shortCutMap.put("zero", new EmojiShortcut("zero", "zero.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/0030-20e3.png", "symbols"));
        shortCutMap.put("zzz", new EmojiShortcut("zzz", "zzz.png", "https://assets-cdn.github.com/images/icons/emoji/unicode/1f4a4.png", "people"));
    }

    public static class EmojiShortcut {
        public final String name;
        public final String image;
        public final String url;
        public final String category;

        public EmojiShortcut(String name, String image, String url, String category) {
            this.name = name;
            this.image = image;
            this.url = url;
            this.category = category;
        }
    }
}

