/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.videotools.misc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Util {
    private static final Logger LOG = LoggerFactory.getLogger(Util.class);
    private static final Map<Float, String> NAMED_RESOLUTIONS;

    private Util() {
    }

    public static String getOutput(Process p) throws IOException {
        String delimiter = System.getProperty("line.separator");
        String out = IOUtils.readLines((InputStream)p.getInputStream(), (Charset)Charset.defaultCharset()).stream().peek(s -> LOG.trace("          [avconv output] : " + s)).collect(Collectors.joining(delimiter)).trim();
        String err = IOUtils.readLines((InputStream)p.getErrorStream(), (Charset)Charset.defaultCharset()).stream().peek(s -> LOG.trace("          [avconv stderr] : " + s)).collect(Collectors.joining(delimiter)).trim();
        return "----- STDOUT -----\n" + out + "\n----- STDERR -----\n" + err + "\n------------------";
    }

    public static String formatOffset(long offsetMillis) {
        long milliseconds = Math.max(offsetMillis, 1L);
        long ms = milliseconds % 1000L;
        long seconds = milliseconds / 1000L;
        long ss = seconds % 60L;
        long minutes = milliseconds / 60000L;
        long mm = minutes % 60L;
        long hours = milliseconds / 3600000L;
        StringBuilder bui = new StringBuilder(16);
        if (hours < 10L) {
            bui.append("0");
        }
        bui.append(hours);
        bui.append(":");
        if (mm < 10L) {
            bui.append("0");
        }
        bui.append(mm);
        bui.append(":");
        if (ss < 10L) {
            bui.append("0");
        }
        bui.append(ss);
        if (ms > 0L) {
            bui.append(".");
            bui.append(ms);
        }
        return bui.toString();
    }

    public static boolean isSameFile(File a, File b) {
        try {
            return Files.isSameFile(Paths.get(a.getPath(), new String[0]), Paths.get(b.getPath(), new String[0]));
        }
        catch (IOException e) {
            throw new RuntimeException("could not compare files " + a + " and " + b, e);
        }
    }

    public static String squeezeFileName(String fileName) {
        int maxUnsqueezedLength = 50;
        return Util.squeezeFileName(maxUnsqueezedLength, fileName);
    }

    public static String squeezeFileName(int maxUnsqueezedLength, String fileName) {
        String beyondDot;
        if (fileName.length() < maxUnsqueezedLength) {
            return fileName;
        }
        String suffix = "...";
        if (fileName.length() <= suffix.length() + 3) {
            return fileName.substring(0, maxUnsqueezedLength);
        }
        int lastDotIndex = fileName.lastIndexOf(".");
        if (lastDotIndex >= 0 && (beyondDot = fileName.substring(lastDotIndex)).length() <= 5) {
            suffix = suffix + beyondDot;
        }
        int length = Math.max(maxUnsqueezedLength - suffix.length(), 0);
        return fileName.substring(0, length) + suffix;
    }

    public static String getOsInfoString() {
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        return "Operating System: '" + osName + "', Version: '" + osVersion + "'";
    }

    public static String printArgs(String[] a) {
        return Arrays.stream(a).map(c -> "\"" + c + "\"").collect(Collectors.joining(" "));
    }

    public static String printArgs(List<String> l) {
        return l.stream().map(c -> "\"" + c + "\"").collect(Collectors.joining(" "));
    }

    public static String getDimensionString(int w, int h) {
        if (w < 0 || h < 0) {
            return "";
        }
        return NAMED_RESOLUTIONS.entrySet().stream().filter(e -> (float)h >= ((Float)e.getKey()).floatValue() * 0.9f && (float)h < ((Float)e.getKey()).floatValue() * 1.1f && (float)w >= ((Float)e.getKey()).floatValue()).map(Map.Entry::getValue).findFirst().orElseGet(() -> w + "x" + h);
    }

    static {
        LinkedHashMap<Float, String> namedResolutions = new LinkedHashMap<Float, String>();
        namedResolutions.put(Float.valueOf(240.0f), "240p");
        namedResolutions.put(Float.valueOf(360.0f), "360p");
        namedResolutions.put(Float.valueOf(480.0f), "480p");
        namedResolutions.put(Float.valueOf(720.0f), "720p");
        namedResolutions.put(Float.valueOf(1080.0f), "1080p");
        namedResolutions.put(Float.valueOf(2160.0f), "4K");
        namedResolutions.put(Float.valueOf(4320.0f), "8K");
        namedResolutions.put(Float.valueOf(8640.0f), "16K");
        NAMED_RESOLUTIONS = Collections.unmodifiableMap(namedResolutions);
    }

    public static final class DirsFirstAlphabeticFileComparator
    implements Comparator<File> {
        @Override
        public int compare(File o1, File o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            boolean o1IsDir = o1.isDirectory();
            boolean o2IsDir = o2.isDirectory();
            if (o1IsDir && !o2IsDir) {
                return -1;
            }
            if (o2IsDir && !o1IsDir) {
                return 1;
            }
            return o1.getPath().compareToIgnoreCase(o2.getPath());
        }
    }
}

