/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.videotools.misc;

import com.myapp.videotools.misc.Broadcast;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.DateTimeException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;

public class SeleniumHolder {
    private static final Pattern DURATION_REGEX = Pattern.compile("0?([0-9]+):0?([0-9]+)\\s*(Std|Min)", 2);
    private static boolean mutedLoggers = false;

    public void tryImdbLookup(List<Broadcast> broadcasts) {
        broadcasts.forEach(bc -> {
            HtmlUnitDriver driver = new HtmlUnitDriver();
            String title = bc.getTitle();
            String url = "https://www.google.com/search?q=";
            try {
                url = url + URLEncoder.encode(title, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(title, e);
            }
            url = url + "+site%3Aimdb.com";
            driver.get(url);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Broadcast> fetchAllBroadcasts() {
        List<Broadcast> allBroadcasts;
        if (!mutedLoggers) {
            LogFactory.getFactory().setAttribute("org.apache.commons.logging.Log", (Object)"org.apache.commons.logging.impl.NoOpLog");
            Logger.getLogger("com.gargoylesoftware.htmlunit").setLevel(Level.OFF);
            Logger.getLogger("org.apache.commons.httpclient").setLevel(Level.OFF);
            Logger.getLogger("com.gargoylesoftware").setLevel(Level.OFF);
            mutedLoggers = true;
        }
        HtmlUnitDriver driver = new HtmlUnitDriver();
        try {
            driver.get("https://tvthek.orf.at/profiles");
            allBroadcasts = driver.findElements(By.cssSelector((String)"ul.results-list li article.b-teaser")).stream().map(SeleniumHolder::parseBroadcast).collect(Collectors.toList());
        }
        finally {
            try {
                driver.close();
            }
            catch (Exception exception) {}
        }
        return allBroadcasts;
    }

    private static Broadcast parseBroadcast(WebElement article) {
        Broadcast broadcast = null;
        try {
            broadcast = SeleniumHolder.parseBroadcastImpl(article);
        }
        catch (Exception e) {
            System.err.println("--------------------------------------------------");
            System.err.println("ERROR: " + e);
            System.err.println("--------------------------------------------------");
            System.err.println(article.getAttribute("innerHTML"));
            System.err.println("--------------------------------------------------");
        }
        return broadcast;
    }

    private static Broadcast parseBroadcastImpl(WebElement article) {
        List durationElements = article.findElements(By.cssSelector((String)"span.hover-duration"));
        if (durationElements.isEmpty()) {
            durationElements = article.findElements(By.cssSelector((String)"p.visible-duration"));
        }
        if (durationElements.isEmpty()) {
            throw new RuntimeException("cannot find duration");
        }
        WebElement duration = (WebElement)durationElements.get(0);
        WebElement image = article.findElement(By.cssSelector((String)"figure.teaser-img img"));
        WebElement tvChannel = article.findElement(By.cssSelector((String)"div.text-container p.channel"));
        WebElement airDate = article.findElement(By.cssSelector((String)"div.text-container time.datetime"));
        WebElement description = article.findElement(By.cssSelector((String)"div.text-container p.description"));
        WebElement availability = article.findElement(By.cssSelector((String)"div.text-container p.availability"));
        WebElement streamUrl = article.findElement(By.cssSelector((String)"a.teaser-link"));
        Broadcast bc = new Broadcast();
        String datetime = StringUtils.trimToEmpty((String)airDate.getAttribute("datetime"));
        try {
            bc.setAirDate(ZonedDateTime.parse(datetime, DateTimeFormatter.ofPattern("yyyy-MM-ddzHH:mm:ss")));
        }
        catch (DateTimeException e) {
            System.out.println(datetime + " --> " + e);
        }
        bc.setTitle(StringUtils.trimToEmpty((String)streamUrl.getAttribute("title")));
        bc.setStreamUrl(StringUtils.trimToEmpty((String)streamUrl.getAttribute("href")));
        bc.setDescription(StringUtils.trimToEmpty((String)description.getText()));
        bc.setImageUrl(StringUtils.trimToEmpty((String)image.getAttribute("src")));
        String durationText = StringUtils.trimToEmpty((String)duration.getAttribute("textContent"));
        bc.setDuration(durationText);
        bc.setDurationSeconds(SeleniumHolder.parseDuration(durationText));
        bc.setTvChannel(StringUtils.trimToEmpty((String)tvChannel.getAttribute("textContent")));
        bc.setAvailability(StringUtils.trimToEmpty((String)availability.getAttribute("textContent")));
        return bc;
    }

    private static int parseDuration(String durationText) {
        Matcher m = DURATION_REGEX.matcher(durationText);
        int seconds = -1;
        if (m.find()) {
            String group3;
            int num1 = Integer.parseInt(m.group(1));
            int num2 = Integer.parseInt(m.group(2));
            switch (group3 = m.group(3).toLowerCase()) {
                case "std": {
                    seconds = num1 * 3600 + num2 * 60;
                    break;
                }
                case "min": {
                    seconds = num1 * 60 + num2;
                }
            }
        }
        return seconds;
    }
}

