/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.videotools.misc;

import java.util.regex.Matcher;

public class RegexHelper {
    public static final int NO_MATCH_INT = -444;
    public static final long NO_MATCH_LONG = -444L;
    public static double NO_MATCH_DOUBLE = -444.0;
    public static final String NO_MATCH_STRING = "<<<<<<< -444 <<<<<<< NO_MATCH_INDICATOR 0d47dedcf9a470f5a61d23f5c2d59a14ce16fa220b34974b62465e88d906cd0b6b28284c3695d70940e743de0ef492e2afe0cea2712570b3e737c34230088c11 >>>>>>>";
    public static final int AMBIGUOUS_MATCH_INT = -555;
    public static long AMBIGUOUS_MATCH_LONG = -555L;
    public static double AMBIGUOUS_MATCH_DOUBLE = -555.0;
    public static final String AMBIGUOUS_MATCH_STRING = "<<<<<<< -555 <<<<<<< AMBIGUOUS_MATCH_INDICATOR 5baf20de66c74cfd1a789744a459324516e343c2e955547490f968ef87811c0b97d8a53a6086b28da2e5fd1b06fd8a5375fd6ca0df537435dc5e1a09dcffa5f5 >>>>>>>";
    public static final int NOT_A_NUMBER_INT = -333;
    public static double NOT_A_NUMBER_DOUBLE = -333.0;
    public static final long NOT_A_NUMBER_LONG = -333L;

    private RegexHelper() {
    }

    public static int getFirstGroupAsInt(Matcher m) {
        return RegexHelper.getFirstGroupAsInt(m, null);
    }

    public static String getFirstGroupAsString(Matcher m) {
        String group;
        switch (group = RegexHelper.getFirstGroupInternal(m)) {
            case "<<<<<<< -444 <<<<<<< NO_MATCH_INDICATOR 0d47dedcf9a470f5a61d23f5c2d59a14ce16fa220b34974b62465e88d906cd0b6b28284c3695d70940e743de0ef492e2afe0cea2712570b3e737c34230088c11 >>>>>>>": 
            case "<<<<<<< -555 <<<<<<< AMBIGUOUS_MATCH_INDICATOR 5baf20de66c74cfd1a789744a459324516e343c2e955547490f968ef87811c0b97d8a53a6086b28da2e5fd1b06fd8a5375fd6ca0df537435dc5e1a09dcffa5f5 >>>>>>>": {
                return null;
            }
        }
        return group;
    }

    public static String getFirstGroupInternal(Matcher m) {
        String result = NO_MATCH_STRING;
        if (m.find()) {
            String group = m.group(1);
            result = m.find() ? AMBIGUOUS_MATCH_STRING : group;
        }
        return result;
    }

    public static int getFirstGroupAsInt(Matcher m, Integer optionalFactor) {
        int result;
        String group;
        switch (group = RegexHelper.getFirstGroupInternal(m)) {
            case "<<<<<<< -444 <<<<<<< NO_MATCH_INDICATOR 0d47dedcf9a470f5a61d23f5c2d59a14ce16fa220b34974b62465e88d906cd0b6b28284c3695d70940e743de0ef492e2afe0cea2712570b3e737c34230088c11 >>>>>>>": {
                result = -444;
                break;
            }
            case "<<<<<<< -555 <<<<<<< AMBIGUOUS_MATCH_INDICATOR 5baf20de66c74cfd1a789744a459324516e343c2e955547490f968ef87811c0b97d8a53a6086b28da2e5fd1b06fd8a5375fd6ca0df537435dc5e1a09dcffa5f5 >>>>>>>": {
                result = -555;
                break;
            }
            default: {
                try {
                    result = Integer.parseInt(group);
                    if (optionalFactor == null) break;
                    result *= optionalFactor.intValue();
                    break;
                }
                catch (NumberFormatException e) {
                    result = -333;
                }
            }
        }
        return result;
    }

    public static double getFirstGroupAsDouble(Matcher m) {
        double result;
        String group;
        switch (group = RegexHelper.getFirstGroupInternal(m)) {
            case "<<<<<<< -444 <<<<<<< NO_MATCH_INDICATOR 0d47dedcf9a470f5a61d23f5c2d59a14ce16fa220b34974b62465e88d906cd0b6b28284c3695d70940e743de0ef492e2afe0cea2712570b3e737c34230088c11 >>>>>>>": {
                result = NO_MATCH_DOUBLE;
                break;
            }
            case "<<<<<<< -555 <<<<<<< AMBIGUOUS_MATCH_INDICATOR 5baf20de66c74cfd1a789744a459324516e343c2e955547490f968ef87811c0b97d8a53a6086b28da2e5fd1b06fd8a5375fd6ca0df537435dc5e1a09dcffa5f5 >>>>>>>": {
                result = AMBIGUOUS_MATCH_DOUBLE;
                break;
            }
            default: {
                try {
                    double tempresult = Double.parseDouble(group);
                    if (tempresult == Double.POSITIVE_INFINITY || tempresult == Double.NEGATIVE_INFINITY) {
                        result = NOT_A_NUMBER_DOUBLE;
                        break;
                    }
                    result = tempresult;
                    break;
                }
                catch (NumberFormatException e) {
                    result = NOT_A_NUMBER_DOUBLE;
                }
            }
        }
        return result;
    }

    public static long getFirstGroupAsLong(Matcher m) {
        long result;
        String group;
        switch (group = RegexHelper.getFirstGroupInternal(m)) {
            case "<<<<<<< -444 <<<<<<< NO_MATCH_INDICATOR 0d47dedcf9a470f5a61d23f5c2d59a14ce16fa220b34974b62465e88d906cd0b6b28284c3695d70940e743de0ef492e2afe0cea2712570b3e737c34230088c11 >>>>>>>": {
                result = -444L;
                break;
            }
            case "<<<<<<< -555 <<<<<<< AMBIGUOUS_MATCH_INDICATOR 5baf20de66c74cfd1a789744a459324516e343c2e955547490f968ef87811c0b97d8a53a6086b28da2e5fd1b06fd8a5375fd6ca0df537435dc5e1a09dcffa5f5 >>>>>>>": {
                result = AMBIGUOUS_MATCH_LONG;
                break;
            }
            default: {
                try {
                    Double resultDouble = Double.valueOf(group);
                    long tempresult = resultDouble.longValue();
                    if (tempresult != Long.MAX_VALUE && tempresult != Long.MIN_VALUE) {
                        result = tempresult;
                        break;
                    }
                    result = -333L;
                    break;
                }
                catch (NumberFormatException e) {
                    result = -333L;
                }
            }
        }
        return result;
    }
}

