/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.videotools.misc;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.VisibleForTesting;

public final class Configuration {
    private static Configuration instance = null;
    public static final String propertiesFileName = "videotool.properties";
    private Properties p = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Configuration getInstance() {
        if (instance != null) return instance;
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            if (instance != null) return instance;
            instance = new Configuration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private Configuration() {
        this(Configuration.loadProps());
    }

    private static InputStream loadProps() {
        ClassLoader scl = ClassLoader.getSystemClassLoader();
        URL url = scl.getResource(propertiesFileName);
        if (url == null && (url = Configuration.class.getResource(propertiesFileName)) == null) {
            String msg = "cannot load videotool.properties from classpath!";
            if (StringUtils.containsIgnoreCase((CharSequence)System.getProperty("user.dir"), (CharSequence)"workspace")) {
                msg = msg + " Maybe forgot to run the maven build?";
            }
            throw new RuntimeException(msg);
        }
        try {
            return url.openStream();
        }
        catch (IOException e) {
            throw new RuntimeException("cannot open " + url + "!");
        }
    }

    @VisibleForTesting
    Configuration(InputStream propertiesStream) {
        try {
            this.p.load(propertiesStream);
        }
        catch (IOException e) {
            String msg = "error reading from propertiesStream: " + propertiesStream;
            String message = e.getMessage();
            if (StringUtils.isNotBlank((CharSequence)message)) {
                msg = msg + " - " + message;
            }
            throw new RuntimeException(msg, e);
        }
        finally {
            if (propertiesStream != null) {
                try {
                    propertiesStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getProperty(String key) {
        return this.p.getProperty(key);
    }
}

