/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.videotools.misc;

import com.myapp.videotools.commandline.CheckForDownloadableMoviesCommand;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;

public class Broadcast {
    public static final String CDATA_BEGIN = "=<![CDATA[";
    public static final String CDATA_END = "]]>";
    private static final Pattern SERIALIZATION_REGEX = Pattern.compile("\\b(\\S+)" + Pattern.quote("=<![CDATA[") + "(.*?)" + Pattern.quote("]]>") + ";");
    private String title;
    private String description;
    private String duration;
    private int durationSeconds;
    private ZonedDateTime airDate;
    private String streamUrl;
    private String imageUrl;
    private String tvChannel;
    private String availability;

    public String toString() {
        return "Broadcast{title=\"" + this.title + '\"' + ", duration='" + this.duration + '\"' + ", tvChannel='" + this.tvChannel + '\'' + ", availability='" + this.availability + '\'' + ", imageUrl='" + this.imageUrl + '\'' + ", description='" + this.description + '\'' + ", streamUrl='" + this.streamUrl + '\'' + ", airDate=" + this.airDate.format(CheckForDownloadableMoviesCommand.FORMATTER) + '}';
    }

    public static List<Broadcast> fromFile(File broadcastInput) throws IOException {
        ArrayList<Broadcast> broadcasts = new ArrayList<Broadcast>();
        LineIterator liter = FileUtils.lineIterator((File)broadcastInput);
        while (liter.hasNext()) {
            String line = liter.nextLine();
            broadcasts.add(Broadcast.fromSerializationString(line));
        }
        return broadcasts;
    }

    public static void toFile(File broadcastOutput, List<Broadcast> broadcasts) throws IOException {
        try (PrintWriter pw = new PrintWriter(new FileWriter(broadcastOutput));){
            broadcasts.forEach(bc -> pw.println(bc.toSerializationString()));
        }
    }

    private String toSerializationString() {
        StringBuilder sb = new StringBuilder();
        sb.append("airDate").append("=").append(CDATA_BEGIN).append(CheckForDownloadableMoviesCommand.FORMATTER.format(this.airDate)).append(CDATA_END).append(";");
        sb.append("title").append("=").append(CDATA_BEGIN).append(this.title).append(CDATA_END).append(";");
        sb.append("description").append("=").append(CDATA_BEGIN).append(this.description).append(CDATA_END).append(";");
        sb.append("duration").append("=").append(CDATA_BEGIN).append(this.duration).append(CDATA_END).append(";");
        sb.append("durationSeconds").append("=").append(CDATA_BEGIN).append(this.durationSeconds).append(CDATA_END).append(";");
        sb.append("streamUrl").append("=").append(CDATA_BEGIN).append(this.streamUrl).append(CDATA_END).append(";");
        sb.append("imageUrl").append("=").append(CDATA_BEGIN).append(this.imageUrl).append(CDATA_END).append(";");
        sb.append("tvChannel").append("=").append(CDATA_BEGIN).append(this.tvChannel).append(CDATA_END).append(";");
        sb.append("availability").append("=").append(CDATA_BEGIN).append(this.availability).append(CDATA_END).append(";");
        return sb.toString();
    }

    private static Broadcast fromSerializationString(String serialized) {
        Broadcast bc = new Broadcast();
        Matcher m = SERIALIZATION_REGEX.matcher(serialized);
        block22: while (m.find()) {
            String property = m.group(1);
            String value = m.group(2);
            if (value.equals("null")) {
                value = "";
            }
            switch (property) {
                case "title": {
                    bc.title = value;
                    continue block22;
                }
                case "description": {
                    bc.description = value;
                    continue block22;
                }
                case "duration": {
                    bc.duration = value;
                    continue block22;
                }
                case "durationSeconds": {
                    bc.durationSeconds = Integer.parseInt(value);
                    continue block22;
                }
                case "streamUrl": {
                    bc.streamUrl = value;
                    continue block22;
                }
                case "imageUrl": {
                    bc.imageUrl = value;
                    continue block22;
                }
                case "tvChannel": {
                    bc.tvChannel = value;
                    continue block22;
                }
                case "availability": {
                    bc.availability = value;
                    continue block22;
                }
                case "airDate": {
                    bc.airDate = value.isEmpty() ? null : ZonedDateTime.parse(value, CheckForDownloadableMoviesCommand.FORMATTER);
                    continue block22;
                }
            }
            throw new RuntimeException("unknown property: '" + property + "' in serialization string: '" + serialized + "'");
        }
        return bc;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public int getDurationSeconds() {
        return this.durationSeconds;
    }

    public void setDurationSeconds(int durationSeconds) {
        this.durationSeconds = durationSeconds;
    }

    public ZonedDateTime getAirDate() {
        return this.airDate;
    }

    public void setAirDate(ZonedDateTime airDate) {
        this.airDate = airDate;
    }

    public String getStreamUrl() {
        return this.streamUrl;
    }

    public void setStreamUrl(String streamUrl) {
        this.streamUrl = streamUrl;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String getTvChannel() {
        return this.tvChannel;
    }

    public void setTvChannel(String tvChannel) {
        this.tvChannel = tvChannel;
    }

    public String getAvailability() {
        return this.availability;
    }

    public void setAvailability(String availability) {
        this.availability = availability;
    }
}

