/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.videotools.misc;

import com.myapp.util.format.TimeFormatUtil;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.assertj.core.util.VisibleForTesting;

public class AppStatistics {
    private static final Format DECIMAL_FORMAT = new DecimalFormat("##0.0");
    private static final String NL = System.getProperty("line.separator");
    private long applicationStart = -1L;
    private long applicationExit = -1L;
    private AtomicInteger thumbnailsCreated = new AtomicInteger(0);
    private AtomicInteger bigPicturesMerged = new AtomicInteger(0);
    private AtomicInteger filesSkippedBecauseExistingTarget = new AtomicInteger(0);
    private AtomicInteger filesSkippedBecauseFiltered = new AtomicInteger(0);
    private AtomicInteger filesParsed = new AtomicInteger(0);
    private AtomicInteger thumbnailFails = new AtomicInteger(0);
    private AtomicInteger mergeFails = new AtomicInteger(0);
    private AtomicInteger parseFails = new AtomicInteger(0);
    private AtomicLong timeSpentWithThumbnailing = new AtomicLong(0L);
    private AtomicLong timeSpentWithImageMerging = new AtomicLong(0L);
    private AtomicLong timeSpentWithParsingMetadata = new AtomicLong(0L);
    private static AppStatistics instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AppStatistics getInstance() {
        if (instance != null) return instance;
        Class<AppStatistics> clazz = AppStatistics.class;
        synchronized (AppStatistics.class) {
            if (instance != null) return instance;
            instance = new AppStatistics();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private AppStatistics() {
    }

    @VisibleForTesting
    public void reset() {
        this.applicationStart = -1L;
        this.applicationExit = -1L;
        this.thumbnailsCreated = new AtomicInteger(0);
        this.bigPicturesMerged = new AtomicInteger(0);
        this.filesSkippedBecauseExistingTarget = new AtomicInteger(0);
        this.filesSkippedBecauseFiltered = new AtomicInteger(0);
        this.filesParsed = new AtomicInteger(0);
        this.thumbnailFails = new AtomicInteger(0);
        this.mergeFails = new AtomicInteger(0);
        this.parseFails = new AtomicInteger(0);
        this.timeSpentWithThumbnailing = new AtomicLong(0L);
        this.timeSpentWithImageMerging = new AtomicLong(0L);
        this.timeSpentWithParsingMetadata = new AtomicLong(0L);
    }

    public void setApplicationStart() {
        if (this.applicationStart != -1L) {
            throw new IllegalStateException("application already started!");
        }
        this.applicationStart = System.currentTimeMillis();
    }

    public void setApplicationExit() {
        if (this.applicationExit != -1L) {
            throw new IllegalStateException("application already exited!");
        }
        this.applicationExit = System.currentTimeMillis();
    }

    public long getApplicationStart() {
        return this.applicationStart;
    }

    public long getApplicationExit() {
        return this.applicationExit;
    }

    public long getTotalTimeNeeded() {
        if (this.applicationStart == -1L || this.applicationExit == -1L) {
            throw new IllegalStateException(this.applicationStart + " , " + this.applicationExit);
        }
        return this.applicationExit - this.applicationStart;
    }

    public final void addTimeSpentWithThumbnailing(long delta) {
        this.timeSpentWithThumbnailing.addAndGet(delta);
    }

    public final long getTimepentWithThumbnailing() {
        return this.timeSpentWithThumbnailing.get();
    }

    public final void addThumbnailsCreated(int delta) {
        this.thumbnailsCreated.addAndGet(delta);
    }

    public final int getThumbnailsCreated() {
        return this.thumbnailsCreated.get();
    }

    public final void incrementThumbnailsCreated() {
        this.thumbnailsCreated.incrementAndGet();
    }

    public final void incrementThumbnailFails() {
        this.thumbnailFails.incrementAndGet();
    }

    public final int getThumbnailFails() {
        return this.thumbnailFails.get();
    }

    public final void addTimeSpentWithImageMerging(long delta) {
        this.timeSpentWithImageMerging.addAndGet(delta);
    }

    public final long getTimeSpentWithImageMerging() {
        return this.timeSpentWithImageMerging.get();
    }

    public final int getBigPicturesMerged() {
        return this.bigPicturesMerged.get();
    }

    public final void incrementBigPicturesMerged() {
        this.bigPicturesMerged.incrementAndGet();
    }

    public final void incrementMergeFails() {
        this.mergeFails.incrementAndGet();
    }

    public final int getMergeFails() {
        return this.mergeFails.get();
    }

    public final void addTimeSpentWithParsingMetadata(long delta) {
        this.timeSpentWithParsingMetadata.addAndGet(delta);
    }

    public final long getTimeSpentWithParsingMetadata() {
        return this.timeSpentWithParsingMetadata.get();
    }

    public final void incrementFilesParsed() {
        this.filesParsed.incrementAndGet();
    }

    public final long getFilesParsed() {
        return this.filesParsed.get();
    }

    public final void incrementParseFails() {
        this.parseFails.incrementAndGet();
    }

    public final int getParseFails() {
        return this.parseFails.get();
    }

    public final int getSkippedBecauseFiltered() {
        return this.filesSkippedBecauseFiltered.get();
    }

    public final void incrementSkippedBecauseFiltered() {
        this.filesSkippedBecauseFiltered.incrementAndGet();
    }

    public final int getSkippedBecauseExistingTarget() {
        return this.filesSkippedBecauseExistingTarget.get();
    }

    public final void incrementSkippedBecauseExistingTarget() {
        this.filesSkippedBecauseExistingTarget.incrementAndGet();
    }

    public String toString() {
        Long totalMillis = this.getTotalTimeNeeded();
        StringBuilder b = new StringBuilder();
        b.append("ApplicationStatistics:").append(NL).append(NL);
        b.append("  creation statistics:").append(NL);
        Long parsedMillis = this.getTimeSpentWithParsingMetadata();
        Long mergedMillis = this.getTimeSpentWithImageMerging();
        Long thumbedMillis = this.getTimepentWithThumbnailing();
        AppStatistics.appendCountWithTimeForEachFile(b, "video-metadata parsed", this.getFilesParsed(), parsedMillis, this.getParseFails());
        AppStatistics.appendCountWithTimeForEachFile(b, "big-pictures merged", this.getBigPicturesMerged(), mergedMillis, this.getMergeFails());
        AppStatistics.appendCountWithTimeForEachFile(b, "thumbnails created", this.getThumbnailsCreated(), thumbedMillis, this.getThumbnailFails());
        b.append("    skipped because target file was existing       : ").append(this.getSkippedBecauseExistingTarget()).append(NL);
        b.append("    skipped because source file was filtered       : ").append(this.getSkippedBecauseFiltered()).append(NL).append(NL);
        b.append("  time statistics:").append(NL);
        AppStatistics.appendTimeSpentWithPercent("with parsing metadata", totalMillis, parsedMillis, b);
        AppStatistics.appendTimeSpentWithPercent("with thumbnailing videos", totalMillis, thumbedMillis, b);
        AppStatistics.appendTimeSpentWithPercent("with image merging", totalMillis, mergedMillis, b);
        Long remainingMillis = totalMillis - (mergedMillis + parsedMillis + thumbedMillis);
        AppStatistics.appendTimeSpentWithPercent("with other activities", totalMillis, remainingMillis, b);
        b.append("    --------------------------------------------------------------------------").append(NL);
        b.append("    total time needed                              : ").append(TimeFormatUtil.getTimeLabel((long)totalMillis)).append(NL);
        b.append("    applicationExit                                : ").append(TimeFormatUtil.getDateLabel((long)this.getApplicationExit())).append(NL);
        b.append("    applicationStart                               : ").append(TimeFormatUtil.getDateLabel((long)this.applicationStart)).append(NL);
        return b.toString();
    }

    private static void appendCountWithTimeForEachFile(StringBuilder b, String description, Number count, Long millisNeeded, int fails) {
        String timeLabel;
        if (count.intValue() != 0) {
            double millisDbl = millisNeeded.doubleValue();
            double countDbl = count.doubleValue();
            long millisPerItem = Double.valueOf(millisDbl / countDbl).longValue();
            timeLabel = TimeFormatUtil.getTimeLabel((long)millisPerItem);
        } else {
            timeLabel = "N/A";
        }
        b.append("    ");
        b.append(description);
        AppStatistics.appendSpaces(46 - description.length(), b);
        b.append(" : ");
        b.append(count);
        AppStatistics.appendSpaces(5 - count.toString().length(), b);
        b.append("  (");
        b.append(timeLabel);
        AppStatistics.appendSpaces(10 - timeLabel.length(), b);
        b.append(" /file)");
        if (fails != 0) {
            b.append("      ");
            b.append(fails);
            b.append(" FAILS !");
        }
        b.append(NL);
    }

    private static void appendTimeSpentWithPercent(String action, Long totalTime, Long millis, StringBuilder b) {
        double percent = millis.doubleValue() / totalTime.doubleValue() * 100.0;
        String percentString = DECIMAL_FORMAT.format(percent);
        String timeLabel = TimeFormatUtil.getTimeLabel((long)millis);
        b.append("    time spent ");
        b.append(action);
        int spaces = 35 - action.length();
        AppStatistics.appendSpaces(spaces, b);
        b.append(" : ");
        b.append(timeLabel);
        AppStatistics.appendSpaces(15 - timeLabel.length(), b);
        AppStatistics.appendSpaces(8 - percentString.length(), b);
        b.append(percentString);
        b.append(" %");
        b.append(NL);
    }

    private static void appendSpaces(int spaces, StringBuilder b) {
        for (int i = 0; i < spaces; ++i) {
            b.append(' ');
        }
    }
}

