/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.videotools.impl;

import com.myapp.util.format.FileFormatUtil;
import com.myapp.util.format.TimeFormatUtil;
import com.myapp.util.process.ProcessTimeoutKiller;
import com.myapp.videotools.AbstractVideoThumbnailer;
import com.myapp.videotools.IImageMerger;
import com.myapp.videotools.VideoFile;
import com.myapp.videotools.commandline.RangeSelection;
import com.myapp.videotools.misc.AppStatistics;
import com.myapp.videotools.misc.Configuration;
import com.myapp.videotools.misc.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ImageMagickImageMerger
implements IImageMerger {
    private static final String MONTAGE_COMMAND_PROPKEY = "com.myapp.videotools.MONTAGE_CMD";
    private static final Logger log = LoggerFactory.getLogger(ImageMagickImageMerger.class);
    private static final AppStatistics statistics = AppStatistics.getInstance();
    private final String montageCommand = Configuration.getInstance().getProperty("com.myapp.videotools.MONTAGE_CMD");
    private RangeSelection rangeSelection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeImages(int rows, int cols, File out, int tileWidth, int tileHeight, List<File> imageList, VideoFile videoFile) throws IOException {
        int i;
        int elementCount = imageList == null ? 0 : imageList.size();
        String outputFilePath = out.getPath();
        String nameLower = out.getName().toLowerCase();
        if (!nameLower.endsWith(".jpeg") && !nameLower.endsWith(".jpg")) {
            outputFilePath = outputFilePath + ".jpeg";
        }
        log.info("        Merging {} pictures to:           {} ...", (Object)elementCount, (Object)out.getName());
        if (elementCount <= 0) {
            throw new RuntimeException("no files specified!");
        }
        ArrayList<String> args = new ArrayList<String>();
        if (this.montageCommand.contains("%")) {
            args.addAll(Arrays.asList(this.montageCommand.split("[%]")));
        } else {
            args.add(this.montageCommand);
        }
        if (videoFile != null) {
            for (i = 0; i < elementCount; ++i) {
                double currentTimeInSeconds = 0.001 * (double)AbstractVideoThumbnailer.calculateOffsetMillis(this.rangeSelection, videoFile, i, elementCount);
                File f = imageList.get(i);
                args.add("-label");
                args.add(TimeFormatUtil.getTimeLabel((double)currentTimeInSeconds));
                args.add(f.getPath());
            }
        } else {
            for (i = 0; i < elementCount; ++i) {
                args.add(imageList.get(i).getPath());
            }
        }
        args.add("-tile");
        args.add(cols + "x");
        args.add("-geometry");
        args.add(tileWidth + "x" + tileHeight + "+1+1");
        args.add("-background");
        args.add("black");
        args.add("-fill");
        args.add("white");
        if (videoFile != null) {
            args.add("-title");
            args.add(ImageMagickImageMerger.generateTitleString(videoFile, cols, tileWidth));
        }
        args.add(outputFilePath);
        if (log.isTraceEnabled()) {
            log.trace("          Starting process:               {}", (Object)Util.printArgs(args));
        }
        ProcessBuilder pb = new ProcessBuilder(args);
        Process p = null;
        long start = System.currentTimeMillis();
        try {
            p = pb.start();
            int i2 = this.waitForProcess(out, p);
            if (i2 != 0) {
                log.warn("          Process: {} returned with {}", args.get(0), (Object)i2);
                log.error("        FAIL, no pictures were merged !");
            }
        }
        catch (InterruptedException e) {
            log.error("        Could not merge thumbnails");
            log.trace("        Stacktrace:", (Throwable)e);
            statistics.incrementMergeFails();
            return;
        }
        finally {
            if (p != null) {
                p.destroy();
            }
            ProcessTimeoutKiller.cancelKillTimeout((Process)p);
            log.trace("          Process cleaned up.");
            statistics.addTimeSpentWithImageMerging(System.currentTimeMillis() - start);
        }
        statistics.incrementBigPicturesMerged();
        log.info("        OK, {} pictures were merged.", (Object)elementCount);
    }

    private static String generateTitleString(VideoFile videoFile, int cols, int tileWidthPixels) {
        String videoName = videoFile.getName();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)videoName).as("videofile name must be set.", new Object[0])).isNotNull();
        StringBuilder titleBuilder = new StringBuilder();
        titleBuilder.append(" [");
        titleBuilder.append(FileFormatUtil.getHumanReadableFileSize((File)videoFile.getFile()));
        titleBuilder.append(" ");
        int w = videoFile.getVideoWidth();
        int h = videoFile.getVideoHeight();
        if (w > 0 && h > 0) {
            String dimensions = Util.getDimensionString(w, h);
            titleBuilder.append(dimensions).append(" ");
        }
        titleBuilder.append(TimeFormatUtil.getTimeLabel((double)videoFile.getLengthSeconds(), (boolean)false));
        titleBuilder.append("]");
        float pixelsPerChar = 11.0f;
        int estimatedTitleChars = videoName.length() + titleBuilder.length();
        int estimatedTitlePx = Math.round(11.0f * (float)estimatedTitleChars);
        int mergedImageWidthPx = cols * (tileWidthPixels + 2);
        if (estimatedTitlePx > mergedImageWidthPx) {
            int beyondPx = estimatedTitlePx - mergedImageWidthPx;
            int beyondChars = Math.round((float)beyondPx / 11.0f);
            int squeezedLengthChars = videoName.length() - beyondChars;
            videoName = Util.squeezeFileName(squeezedLengthChars, videoName);
        }
        titleBuilder.insert(0, videoName);
        return titleBuilder.toString();
    }

    @VisibleForTesting
    protected int waitForProcess(File out, Process p) throws InterruptedException {
        ProcessTimeoutKiller.registerKillTimeout((Process)p, (long)10000L, (String)("merge images to: " + out.getName()), (boolean)false);
        int i = p.waitFor();
        ProcessTimeoutKiller.cancelKillTimeout((Process)p);
        return i;
    }

    @Override
    public void setRangeSelection(RangeSelection rangeSelection) {
        this.rangeSelection = rangeSelection;
    }
}

