/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.videotools.impl;

import com.myapp.videotools.AbstractPathCalculator;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public final class FileHierarchyCopying
extends AbstractPathCalculator {
    private String videoRootDir = null;
    private String targetRootDir = null;

    public FileHierarchyCopying(File videoRootDir, File targetRootDir) {
        this.setTargetRootDirFile(targetRootDir);
        this.setVideoRootDirFile(videoRootDir);
    }

    @Override
    public synchronized String getTargetFileImpl(File source) {
        String prefix;
        String parent = source.getParentFile().getPath();
        parent = parent.replace(this.videoRootDir, this.targetRootDir);
        StringBuilder builder = new StringBuilder();
        builder.append(parent);
        if (builder.charAt(builder.length() - 1) != File.separatorChar) {
            builder.append(File.separatorChar);
        }
        if (StringUtils.isNotEmpty((CharSequence)(prefix = this.getPrefix()))) {
            builder.append(prefix);
        }
        builder.append(source.getName());
        String fileNameSuffix = this.getSuffix();
        if (StringUtils.isNotEmpty((CharSequence)fileNameSuffix)) {
            builder.append(fileNameSuffix);
        }
        return builder.toString();
    }

    @Override
    protected void validateSourceImpl(File source) {
        if (!source.getPath().contains(this.videoRootDir)) {
            throw new IllegalStateException("sourceFile not inside source dir: " + source);
        }
    }

    public void setTargetRootDirFile(File dir) {
        if (!dir.isDirectory() || !dir.canWrite()) {
            throw new IllegalArgumentException("targetDir not a writeable directory: " + dir);
        }
        this.targetRootDir = dir.getPath();
    }

    public void setVideoRootDirFile(File dir) {
        if (!dir.isDirectory() || !dir.canRead()) {
            throw new IllegalArgumentException("videoDir not a readable directory: " + dir);
        }
        this.videoRootDir = dir.getPath();
    }

    public String getTargetRootDir() {
        return this.targetRootDir;
    }

    public String getVideoRootDir() {
        return this.videoRootDir;
    }
}

