/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.videotools.impl;

import com.myapp.videotools.AbstractVideoFileParser;
import com.myapp.videotools.impl.AvconvConstants;
import com.myapp.videotools.misc.RegexHelper;
import com.myapp.videotools.misc.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class FfmpegVideoFileParser
extends AbstractVideoFileParser
implements AvconvConstants {
    private static final Pattern LINE_OF_INTEREST_PATTERN = Pattern.compile("\\s* ( Input | Duration: | Stream ) \\s+ .* ", 4);
    static final Pattern DURATION_PATTERN = Pattern.compile("^\\s*[Dd]uration: (\\d\\d:\\d\\d:\\d\\d\\.\\d\\d), ");
    static final Pattern TOTAL_BYTES_PER_SEC_PATTERN = Pattern.compile("^\\s*[Dd]uration: .*, bitrate: ([0-9]+) kb/s\\b");
    static final Pattern VIDEO_START_OFFSET_PATTERN = Pattern.compile("^\\s*[Dd]uration: .*,\\s*[Ss]tart\\s*:\\s*([0-9]+(?:\\.[0-9]+)), ");
    static final Pattern VIDEO_BYTES_PER_SECOND_PATTERN = Pattern.compile("^\\s*[Ss]tream .* [Vv]ideo: .*,\\s+(\\d+)\\s*kb/s\\s*,\\s+");
    static final Pattern VIDEO_CODEC_PATTERN = Pattern.compile("^\\s*[Ss]tream .* [Vv]ideo: ([^,]+?)\\s*, ");
    static final Pattern VIDEO_FORMAT_PATTERN = Pattern.compile("^\\s*[Ss]tream .* [Vv]ideo: [^,]+, ([^,]+),");
    static final Pattern VIDEO_FRAME_RATE_PATTERN = Pattern.compile("^\\s*[Ss]tream .* [Vv]ideo: .*, (\\d+(?:\\.\\d*)?)k? fps, ");
    static final Pattern VIDEO_HEIGHT_PATTERN = Pattern.compile("^\\s*[Ss]tream .* [Vv]ideo: .*, \\d+[xX](\\d+)[, ]");
    static final Pattern VIDEO_WIDTH_PATTERN = Pattern.compile("^\\s*[Ss]tream .* [Vv]ideo: .*, (\\d+)[xX]\\d+[, ]");
    static final Pattern AUDIO_BYTES_PER_SEC_PATTERN = Pattern.compile("^\\s*[Ss]tream .* [Aa]udio: .*, ([0-9]+) kb/s\\b");
    static final Pattern AUDIO_CHANNELS_PATTERN = Pattern.compile("^\\s*[Ss]tream .* [Aa]udio: .*, (mono|stereo|5\\.[10](?:\\([^),]+\\))?|[0-9]+ channels?)");
    static final Pattern AUDIO_CODEC_PATTERN = Pattern.compile("^\\s*[Ss]tream .* [Aa]udio: ([^,]+?)\\s*,\\s*");
    static final Pattern AUDIO_SAMPLE_RATE_PATTERN = Pattern.compile("^\\s*[Ss]tream .* [Aa]udio: .*, ([0-9]+) Hz, ");

    @Override
    protected boolean isLineOfInterest(String lineOfMetaData) {
        return LINE_OF_INTEREST_PATTERN.matcher(lineOfMetaData).matches();
    }

    @Override
    protected int parseAudioBytesPerSecond(String lineOfMetaData) {
        return RegexHelper.getFirstGroupAsInt(AUDIO_BYTES_PER_SEC_PATTERN.matcher(lineOfMetaData), 1024);
    }

    @Override
    protected String parseAudioChannels(String lineOfMetaData) {
        return RegexHelper.getFirstGroupAsString(AUDIO_CHANNELS_PATTERN.matcher(lineOfMetaData));
    }

    @Override
    protected String parseAudioCodec(String lineOfMetaData) {
        return RegexHelper.getFirstGroupAsString(AUDIO_CODEC_PATTERN.matcher(lineOfMetaData));
    }

    @Override
    protected int parseAudioSampleRate(String lineOfMetaData) {
        return RegexHelper.getFirstGroupAsInt(AUDIO_SAMPLE_RATE_PATTERN.matcher(lineOfMetaData));
    }

    @Override
    protected long parseDurationMillis(String lineOfMetaData) {
        long result;
        String group;
        switch (group = RegexHelper.getFirstGroupInternal(DURATION_PATTERN.matcher(lineOfMetaData))) {
            case "<<<<<<< -444 <<<<<<< NO_MATCH_INDICATOR 0d47dedcf9a470f5a61d23f5c2d59a14ce16fa220b34974b62465e88d906cd0b6b28284c3695d70940e743de0ef492e2afe0cea2712570b3e737c34230088c11 >>>>>>>": {
                result = -444L;
                break;
            }
            default: {
                String[] parts = group.split("[:.]");
                int hours = Integer.parseInt(FfmpegVideoFileParser.stripLeadingZeros(parts[0]));
                int minutes = Integer.parseInt(FfmpegVideoFileParser.stripLeadingZeros(parts[1]));
                int seconds = Integer.parseInt(FfmpegVideoFileParser.stripLeadingZeros(parts[2]));
                int hundredths = Integer.parseInt(FfmpegVideoFileParser.stripLeadingZeros(parts[3]));
                long millis = 0L;
                millis += (long)(3600000 * hours);
                millis += (long)(60000 * minutes);
                millis += (long)(1000 * seconds);
                result = millis += (long)(10 * hundredths);
                break;
            }
        }
        return result;
    }

    private static String stripLeadingZeros(String input) {
        String result = input;
        while (result.charAt(0) == '0' && result.length() > 1) {
            result = result.substring(1);
        }
        return result;
    }

    @Override
    protected int parseTotalBytesPerSecond(String lineOfMetaData) {
        return RegexHelper.getFirstGroupAsInt(TOTAL_BYTES_PER_SEC_PATTERN.matcher(lineOfMetaData), 1024);
    }

    @Override
    protected int parseVideoBytesPerSecond(String lineOfMetaData) {
        return RegexHelper.getFirstGroupAsInt(VIDEO_BYTES_PER_SECOND_PATTERN.matcher(lineOfMetaData), 1024);
    }

    @Override
    protected long parseVideoStartOffsetMillis(String lineOfMetaData) {
        return RegexHelper.getFirstGroupAsLong(VIDEO_START_OFFSET_PATTERN.matcher(lineOfMetaData));
    }

    @Override
    protected String parseVideoCodec(String lineOfMetaData) {
        return RegexHelper.getFirstGroupAsString(VIDEO_CODEC_PATTERN.matcher(lineOfMetaData));
    }

    @Override
    protected String parseVideoFormat(String lineOfMetaData) {
        return RegexHelper.getFirstGroupAsString(VIDEO_FORMAT_PATTERN.matcher(lineOfMetaData));
    }

    @Override
    protected double parseVideoFrameRate(String lineOfMetaData) {
        return RegexHelper.getFirstGroupAsDouble(VIDEO_FRAME_RATE_PATTERN.matcher(lineOfMetaData));
    }

    @Override
    protected int parseVideoHeight(String lineOfMetaData) {
        return RegexHelper.getFirstGroupAsInt(VIDEO_HEIGHT_PATTERN.matcher(lineOfMetaData));
    }

    @Override
    protected int parseVideoWidth(String lineOfMetaData) {
        return RegexHelper.getFirstGroupAsInt(VIDEO_WIDTH_PATTERN.matcher(lineOfMetaData));
    }

    @Override
    protected List<String> readVideoMetaData(File videoFile2) throws IOException {
        String line;
        String[] cmds = new String[]{this.getAvconvCommand(), "-i", videoFile2.getPath()};
        this.log.trace("          starting process: {}", (Object)Util.printArgs(cmds));
        Process p = new ProcessBuilder(new String[0]).redirectErrorStream(true).command(cmds).start();
        BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
        ArrayList<String> outputLines = new ArrayList<String>();
        while ((line = input.readLine()) != null) {
            outputLines.add(line);
            this.log.trace("          got output line:    > {}", (Object)line.trim());
        }
        return outputLines;
    }
}

