/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.videotools.impl;

import com.myapp.util.file.FileUtils;
import com.myapp.util.format.TimeFormatUtil;
import com.myapp.util.process.ProcessTimeoutKiller;
import com.myapp.videotools.AbstractVideoThumbnailer;
import com.myapp.videotools.impl.AnimatedBigPictureHelper;
import com.myapp.videotools.impl.AvconvConstants;
import com.myapp.videotools.misc.AppStatistics;
import com.myapp.videotools.misc.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractFileAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvconvVideoThumbnailer
extends AbstractVideoThumbnailer
implements AvconvConstants {
    private static final Logger LOG = LoggerFactory.getLogger(AvconvVideoThumbnailer.class);

    @Override
    public List<File> createThumbnailSeries(int count, File targetDir) {
        if (this.videoFile == null) {
            throw new IllegalStateException("videofile must be set!");
        }
        if (count <= 0) {
            throw new IllegalArgumentException("count must be greater 0, but got: " + count);
        }
        LOG.info("        Creating {} thumbnails for:       {}", (Object)count, (Object)this.videoFile.getName());
        if (!this.parseIfNotYetParsed()) {
            LOG.error("        Could not parse video file:       {}", (Object)this.videoFile.getFile());
            return Collections.emptyList();
        }
        LOG.debug("          Length of video file:             {}", (Object)TimeFormatUtil.getTimeLabel((double)this.videoFile.getLengthSeconds()));
        LOG.debug("          Thumbnails will be created in:    {}", (Object)targetDir);
        this.createOrWipeTempThumbnailDir(targetDir);
        int width = this.getPreferredWidth();
        int height = this.getPreferredHeight();
        ArrayList<List<String>> commandSeries = new ArrayList<List<String>>();
        for (int i = 0; i < count; ++i) {
            ArrayList<String> commands = new ArrayList<String>();
            commands.add("ffmpegthumbnailer");
            commands.add("-i");
            commands.add(this.videoFile.getFile().getPath());
            commands.add("-o");
            commands.add(AvconvVideoThumbnailer.__thumbName(targetDir, i));
            commands.add("-s");
            String dim = Integer.toString(Math.max(height, width));
            commands.add(dim);
            commands.add("-t");
            commands.add(this.calculateOffset(i, count));
            commandSeries.add(commands);
        }
        long start = System.currentTimeMillis();
        try {
            this.__executeThumbnailCmds(commandSeries, targetDir);
        }
        catch (ThumbnailException te) {
            LOG.error("          " + te.getMessage());
            String message = "at least one thumbnail process did not finish properly. " + te.getMessage();
            throw new RuntimeException(message, te);
        }
        catch (IOException | InterruptedException e) {
            String message = "an error occured while executing the thumbnail process: " + e;
            LOG.trace("          " + message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
        finally {
            this.statistics.addTimeSpentWithThumbnailing(System.currentTimeMillis() - start);
        }
        ArrayList<File> results = new ArrayList<File>();
        for (int i = 0; i < count; ++i) {
            String path = AvconvVideoThumbnailer.__thumbName(targetDir, i);
            File f = new File(path);
            if (!f.isFile()) {
                LOG.warn("        FAIL thumbnailing process did not create enough pix: requested: {} file: {}", (Object)count, (Object)this.videoFile.getName());
                LOG.warn("        FAIL during command: " + commandSeries.get(i));
                this.statistics.incrementThumbnailFails();
                return null;
            }
            results.add(f);
            this.statistics.addThumbnailsCreated(1);
        }
        LOG.info("        OK, {} thumbnails were created.", (Object)results.size());
        return results;
    }

    @VisibleForTesting
    protected void __executeThumbnailCmds(List<List<String>> commandSeries, File targetDir) throws IOException, InterruptedException, ThumbnailException {
        int cpus = Runtime.getRuntime().availableProcessors();
        ExecutorService es = Executors.newFixedThreadPool(Math.max(1, Math.min(commandSeries.size(), cpus)));
        List results = commandSeries.stream().map(command -> es.submit(() -> {
            ProcessBuilder pb = new ProcessBuilder((List<String>)command);
            Process nailProcess = null;
            try {
                LOG.trace("          starting command: " + String.join((CharSequence)" ", command));
                nailProcess = this.__startProcess(pb);
                ProcessTimeoutKiller.registerKillTimeout((Process)nailProcess, (long)7500L, (String)("thumnail_" + targetDir.getName()), (boolean)true);
                String stdoutLines = Util.getOutput(nailProcess);
                int status = this.__waitForProcess(nailProcess, (List<String>)command);
                LOG.trace("          command finished with status " + status);
                ProcessTimeoutKiller.cancelKillTimeout((Process)nailProcess);
                if (status != 0) {
                    throw new ThumbnailException("process " + command + " returned with status " + status + "! output:\n" + stdoutLines);
                }
            }
            finally {
                if (nailProcess != null) {
                    nailProcess.destroy();
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("          process 'thumbnails' cleaned up. ({})", (Object)targetDir.getName());
                }
            }
            return null;
        })).collect(Collectors.toList());
        es.shutdown();
        es.awaitTermination(commandSeries.size() * 2, TimeUnit.SECONDS);
        for (Future result : results) {
            try {
                result.get();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof ThumbnailException) {
                    throw (ThumbnailException)e.getCause();
                }
                throw new RuntimeException("expecting only thumbnail exceptions: " + e);
            }
        }
    }

    @VisibleForTesting
    protected static String __thumbName(File targetDir, int num) {
        String name = "thumb_" + StringUtils.leftPad((String)("" + num), (int)6, (char)'0') + ".jpeg";
        File file = new File(targetDir, name);
        return file.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createBigPicture(File out) {
        int thumbsGotReally;
        LOG.info("      Creating big-picture for video:     {} ...", (Object)this.videoFile.getName());
        LOG.info("        Big-picture target file:          {}", (Object)out);
        if (!this.parseIfNotYetParsed()) {
            LOG.error("        Could not parse video file:       {}", (Object)this.videoFile.getFile());
            return false;
        }
        int rows = this.getBigPictureRows();
        int cols = this.getBigPictureCols();
        int width = this.getPreferredWidth();
        int height = this.getPreferredHeight();
        int numberOfThumbsExpected = rows * cols;
        File tempDir = this.calculateThumbnailTempDir();
        List<File> thumbs = this.createThumbnailSeries(numberOfThumbsExpected, tempDir);
        int n = thumbsGotReally = thumbs == null ? 0 : thumbs.size();
        if (thumbs == null || thumbs.size() != numberOfThumbsExpected) {
            LOG.error("      FAIL, pictures expected: {}, but got {}", (Object)numberOfThumbsExpected, (Object)thumbsGotReally);
            return false;
        }
        try {
            this.merger.setRangeSelection(this.getRangeSelection());
            this.merger.mergeImages(rows, cols, out, width, height, thumbs, this.videoFile);
        }
        catch (Exception e) {
            LOG.error("        Could not merge thumbnails: " + e.getMessage(), (Throwable)e);
            LOG.trace("        Stacktrace:", (Throwable)e);
            LOG.error("      FAIL, no big-picture for video:  {}", (Object)this.videoFile);
            boolean bl = false;
            return bl;
        }
        finally {
            FileUtils.deleteRecursively((File)tempDir);
            LOG.trace("        tmp files removed.");
        }
        LOG.info("      OK, created big-picture for video:  {}", (Object)this.videoFile);
        return true;
    }

    @Override
    public boolean createAnimatedBigPicture(File out, int frameCount) {
        LOG.info("      Creating animated big-picture for:  {} ...", (Object)this.videoFile.getName());
        LOG.info("        Big-picture target file:          {}", (Object)out);
        if (!this.parseIfNotYetParsed()) {
            LOG.error("        Could not parse video file:       {}", (Object)this.videoFile.getFile());
            return false;
        }
        AnimatedBigPictureHelper helper = new AnimatedBigPictureHelper(this);
        helper.animatedBigPic(out, frameCount);
        return true;
    }

    @Override
    public void captureSingleImage(double offset, int width, int height, File out) {
        String output;
        int exitCode;
        LOG.info("capturing image of                : " + this.videoFile.getFile().getPath());
        LOG.info("  target file                     : " + out.getPath());
        LOG.info("  offset in seconds of screenshot : " + TimeFormatUtil.getTimeLabel((double)offset));
        String[] cmd = this.createScreenshotCommandArray(offset, width, height, out);
        Process p = null;
        try {
            p = this.__startProcess(new ProcessBuilder(cmd));
            if (LOG.isDebugEnabled()) {
                LOG.debug("  started process                : {}", (Object)Util.printArgs(cmd));
            }
            ProcessTimeoutKiller.registerKillTimeout((Process)p, (long)1000L, (String)("captureSingleImage_" + out.getName()), (boolean)false);
            exitCode = this.__waitForProcess(p, Arrays.asList(cmd));
            output = Util.getOutput(p);
            ProcessTimeoutKiller.cancelKillTimeout((Process)p);
        }
        catch (Exception e) {
            AppStatistics.getInstance().incrementThumbnailFails();
            String msg = "  could not capture image: " + this.videoFile.getFile().getName();
            LOG.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        finally {
            if (p != null) {
                p.destroy();
                LOG.trace("  process cleaned up.");
            }
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)exitCode).as(output, new Object[0])).isEqualTo(0);
        ((AbstractFileAssert)Assertions.assertThat((File)out).as(output, new Object[0])).isFile();
        ((AbstractLongAssert)Assertions.assertThat((long)out.length()).as(output, new Object[0])).isGreaterThan(1000L);
        AppStatistics.getInstance().incrementThumbnailsCreated();
        LOG.info("OK, image captured to file : {}", (Object)out);
    }

    private String[] createScreenshotCommandArray(double offset, int pWidth, int pHeight, File outputFile) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getAvconvCommand());
        args.add("-i");
        args.add(this.videoFile.getFile().getPath());
        args.add("-y");
        args.add("-f");
        args.add("image2");
        String time = TimeFormatUtil.formatTimeTo2Digits((double)offset);
        if (LOG.isTraceEnabled()) {
            LOG.trace("formatTime: {}", (Object)time);
        }
        args.add("-ss");
        args.add(time);
        args.add("-t");
        args.add("0.001");
        args.add("-s");
        args.add(pWidth + "*" + pHeight);
        args.add(outputFile.getPath());
        return args.toArray(new String[0]);
    }

    private String calculateOffset(int num, int count) {
        long offsetMillis = this.calculateOffsetMillis(num, count);
        return Util.formatOffset(offsetMillis);
    }

    private static class ThumbnailException
    extends Exception {
        private ThumbnailException(String message) {
            super(message);
        }
    }
}

