/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.videotools.impl;

import com.myapp.util.image.ImageUtil;
import com.myapp.videotools.AbstractVideoThumbnailer;
import com.myapp.videotools.IImageMerger;
import com.myapp.videotools.VideoFile;
import com.myapp.videotools.impl.Application;
import com.myapp.videotools.misc.Configuration;
import com.myapp.videotools.misc.Util;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.AbstractFileAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AnimatedBigPictureHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AnimatedBigPictureHelper.class);
    private final AbstractVideoThumbnailer thumbnailer;
    private VideoFile videoFile;
    private IImageMerger merger;

    AnimatedBigPictureHelper(AbstractVideoThumbnailer thumbnailer) {
        this.thumbnailer = Objects.requireNonNull(thumbnailer);
        this.merger = Application.getInstance().createImageMerger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void animatedBigPic(File out, int frameCount) {
        this.videoFile = Objects.requireNonNull(this.thumbnailer.getVideoFile());
        File tempDir = this.thumbnailer.calculateThumbnailTempDir();
        this.thumbnailer.createOrWipeTempThumbnailDir(tempDir);
        try {
            List<Burst> bursts = this.createBurstFrames(frameCount, tempDir);
            this.createMultipleBigPicsFromBursts(frameCount, tempDir, bursts);
            this.createGifFromMultipleBigPics(out, tempDir);
        }
        finally {
            FileUtils.deleteQuietly((File)tempDir);
        }
    }

    private List<Burst> createBurstFrames(int frameCount, File tempDir) {
        int rows = this.thumbnailer.getBigPictureRows();
        int cols = this.thumbnailer.getBigPictureCols();
        Dimension dimension = ImageUtil.scaleDimensions((int)this.thumbnailer.getPreferredWidth(), (int)this.thumbnailer.getPreferredHeight(), (int)this.videoFile.getVideoWidth(), (int)this.videoFile.getVideoHeight());
        ArrayList<Burst> bursts = new ArrayList<Burst>();
        int i = 0;
        for (int r = 0; r < rows; ++r) {
            int c = 0;
            while (c < cols) {
                Burst burst2 = new Burst();
                burst2.workingDir = new File(tempDir, "burst_" + (i < 10 ? "00" : (i < 100 ? "0" : "")) + i + "_r" + r + "c" + c);
                burst2.marker = burst2.workingDir.getName() + " ";
                burst2.inputFile = this.videoFile.getFile();
                burst2.frameSize = dimension;
                burst2.frameCount = frameCount;
                burst2.offsetMillis = this.thumbnailer.calculateOffsetMillis(i, rows * cols);
                bursts.add(burst2);
                ++c;
                ++i;
            }
        }
        LinkedHashMap<Burst, Future> futureMap = new LinkedHashMap<Burst, Future>();
        int cpus = Runtime.getRuntime().availableProcessors();
        ExecutorService es1 = Executors.newFixedThreadPool(Math.max(1, Math.min(rows * cols, cpus)));
        bursts.forEach(task -> futureMap.put((Burst)task, es1.submit(task)));
        try {
            this.thumbnailer.__awaitTermination(es1, 500L * (long)rows * (long)cols * (long)frameCount, "create burst frames");
        }
        catch (InterruptedException e) {
            throw new RuntimeException("an error occued during creating bursts", e);
        }
        futureMap.forEach((burst, futureFiles) -> {
            try {
                futureFiles.get();
            }
            catch (Exception e) {
                throw new RuntimeException("error during creating burst with offset " + burst.offsetMillis, e);
            }
        });
        bursts.forEach(b -> {
            ListAssert cfr_ignored_0 = (ListAssert)Assertions.assertThat(b.collectedFiles).hasSize(frameCount);
        });
        return bursts;
    }

    private void createMultipleBigPicsFromBursts(int frameCount, File tempDir, List<Burst> bursts) {
        int thumbWidth2 = this.thumbnailer.getPreferredWidth();
        int thumbHeight2 = this.thumbnailer.getPreferredHeight();
        int rows2 = this.thumbnailer.getBigPictureRows();
        int cols2 = this.thumbnailer.getBigPictureCols();
        int cpus2 = Runtime.getRuntime().availableProcessors();
        ExecutorService es2 = Executors.newFixedThreadPool(Math.max(1, Math.min(frameCount, cpus2)));
        TreeMap<Integer, File> bigPics = new TreeMap<Integer, File>();
        IntStream.range(0, frameCount).mapToObj(i -> () -> {
            int k = i + 1;
            String oneBasedIdx = "" + k;
            File bigPic = new File(tempDir, "bigPic_" + oneBasedIdx + ".jpeg");
            bigPics.put(i, bigPic);
            List<File> files = bursts.stream().map(b -> b.collectedFiles.get(i)).collect(Collectors.toList());
            FileUtils.deleteQuietly((File)bigPic);
            this.merger.mergeImages(rows2, cols2, bigPic, thumbWidth2, thumbHeight2, files, this.videoFile);
            Assertions.assertThat((File)bigPic).isFile();
            return bigPic;
        }).forEach(es2::submit);
        try {
            this.thumbnailer.__awaitTermination(es2, 1500L * (long)frameCount, "create bigpics from bursts");
        }
        catch (InterruptedException e) {
            throw new RuntimeException("an error occured while creating bigpics from bursts", e);
        }
        Assertions.assertThat(bigPics).hasSize(frameCount);
        bigPics.forEach((k, v) -> Assertions.assertThat((File)v).isFile());
    }

    private void createGifFromMultipleBigPics(File out, File tempDir) {
        String output;
        int exitCode;
        String ffmpeg = Configuration.getInstance().getProperty("com.myapp.videotools.FFMPEG_CMD");
        List<String> command = Arrays.asList(ffmpeg, "-i", tempDir.getPath() + File.separator + "bigPic_%d.jpeg", "-f", "gif", out.getPath());
        LOG.debug("Starting gif merge process for: " + String.join((CharSequence)" ", command));
        try {
            Process process = this.thumbnailer.__startProcess(new ProcessBuilder(new String[0]).command(command));
            exitCode = this.thumbnailer.__waitForProcess(process, command);
            output = Util.getOutput(process);
        }
        catch (Exception e) {
            throw new RuntimeException("gif merge process threw: " + e.getClass().getSimpleName(), e);
        }
        if (exitCode != 0) {
            throw new RuntimeException("gif merge process for " + out + " failed, exitCode was " + exitCode + "!\n" + output);
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)exitCode).as(output, new Object[0])).isEqualTo(0);
        ((AbstractFileAssert)Assertions.assertThat((File)out).as(output, new Object[0])).isFile();
        ((AbstractLongAssert)Assertions.assertThat((long)out.length()).as(output, new Object[0])).isGreaterThan(1000L);
        LOG.debug("Gif merged to: " + out.getPath());
    }

    class Burst
    implements Callable<List<File>> {
        long offsetMillis;
        int frameCount;
        Dimension frameSize;
        File inputFile;
        File workingDir;
        String marker;
        List<File> collectedFiles;

        Burst() {
        }

        @Override
        public List<File> call() throws Exception {
            String output;
            int exitCode;
            FileUtils.deleteQuietly((File)this.workingDir);
            FileUtils.forceMkdir((File)this.workingDir);
            String ffmpeg = Configuration.getInstance().getProperty("com.myapp.videotools.FFMPEG_CMD");
            List<String> command = Arrays.asList(ffmpeg, "-i", this.inputFile.getPath(), "-ss", Util.formatOffset(this.offsetMillis), "-frames", String.valueOf(this.frameCount), "-s", this.frameSize.width + "x" + this.frameSize.height, this.workingDir.getPath() + File.separator + "frame-%003d.jpeg");
            LOG.debug(this.marker + " Starting process for: " + String.join((CharSequence)" ", command));
            try {
                Process process = AnimatedBigPictureHelper.this.thumbnailer.__startProcess(new ProcessBuilder(new String[0]).command(command));
                exitCode = AnimatedBigPictureHelper.this.thumbnailer.__waitForProcess(process, command);
                output = Util.getOutput(process);
            }
            catch (Exception e) {
                throw new RuntimeException("process for " + this.marker + " threw: " + e.getClass().getSimpleName(), e);
            }
            if (exitCode != 0) {
                throw new RuntimeException("process for " + this.marker + " failed, exitCode was " + exitCode + "!\n" + output);
            }
            this.collectedFiles = FileUtils.listFiles((File)this.workingDir, null, (boolean)false).stream().sorted(new Util.DirsFirstAlphabeticFileComparator()).peek(f -> Assertions.assertThat((File)f).isFile()).collect(Collectors.toList());
            LOG.debug(this.marker + " Process finished, frames captured for burst: " + this.collectedFiles.size());
            return this.collectedFiles;
        }
    }
}

