/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.videotools.commandline;

import com.myapp.videotools.commandline.InOut;
import com.myapp.videotools.misc.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;
import picocli.custom.AssertionErrorWrappingException;
import picocli.custom.BaseCommand;
import picocli.custom.VerbosityOptions;

public abstract class VideoToolsBaseCommand
extends BaseCommand {
    static final String HELP = "--help";
    static final String HELP2 = "-?";
    static final String HELP3 = "-help";
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @CommandLine.Mixin
    private VerbosityOptions verbosity = new VerbosityOptions();
    @CommandLine.Mixin
    InOut io = new InOut();
    @CommandLine.Option(names={"--help", "-?", "-help"}, usageHelp=true, description={"Display this help and exit"})
    private boolean help;

    public final Void call() throws Exception {
        try {
            this.verbosity.applyLogConfig();
            if (this.log.isDebugEnabled()) {
                this.log.debug(Util.getOsInfoString());
            }
            this.executeImpl();
        }
        catch (AssertionError e) {
            throw new AssertionErrorWrappingException(e);
        }
        return null;
    }

    protected abstract void executeImpl();
}

