/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.videotools.commandline;

import com.myapp.videotools.VideoFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import picocli.CommandLine;

@CommandLine.Command
public class RangeSelection {
    public static final double DEFAULT_RATIO = 1.0;
    public static final long DEFAULT_OFFSET = 0L;
    public static final RangeSelection COMPLETELY = new RangeSelection(){

        @Override
        public Coords calculate(VideoFile videoFile) {
            this.checkParsed(videoFile);
            long lengthMillis = videoFile.getLengthMillis();
            return new Coords(0L, lengthMillis);
        }
    };
    private Double lengthRatio = 1.0;
    private Long offsetMillis = 0L;

    public void setLengthRatio(Double lengthRatio) {
        if (lengthRatio == null) {
            this.lengthRatio = lengthRatio;
            return;
        }
        if (lengthRatio > -1.0E-5 && lengthRatio < 1.0E-5) {
            throw new IllegalArgumentException("ratio zero is not allowed.");
        }
        if (lengthRatio > 1.0 || lengthRatio < -1.0) {
            throw new IllegalArgumentException("ratio not within -1 and 1: " + lengthRatio);
        }
        this.lengthRatio = lengthRatio;
    }

    public void setOffsetMillis(Long offsetMillis) {
        this.offsetMillis = offsetMillis;
    }

    public static RangeSelection ofFirstPercent(double percent) {
        RangeSelection partSelection = new RangeSelection();
        partSelection.setOffsetMillis(null);
        partSelection.setLengthRatio(percent * 0.01);
        return partSelection;
    }

    public static RangeSelection ofLastPercent(double percent) {
        RangeSelection partSelection = new RangeSelection();
        partSelection.setOffsetMillis(null);
        partSelection.setLengthRatio(percent * -0.01);
        return partSelection;
    }

    public Coords calculate(VideoFile videoFile) {
        this.checkParsed(videoFile);
        long totalDuration = videoFile.getLengthMillis();
        if (this.offsetMillis != null) {
            if (this.lengthRatio == null) {
                long offset;
                long duration;
                if (this.offsetMillis < 0L) {
                    duration = 0L - this.offsetMillis;
                    offset = totalDuration - duration;
                } else {
                    duration = totalDuration - this.offsetMillis;
                    offset = this.offsetMillis;
                }
                return new Coords(offset, duration);
            }
            long offset = this.offsetMillis;
            long duration = Math.round(this.lengthRatio * (double)totalDuration);
            return new Coords(offset, duration);
        }
        if (this.lengthRatio != null) {
            long offset = 0L;
            long duration = Math.round(this.lengthRatio * (double)totalDuration);
            if (this.lengthRatio < 0.0) {
                duration = -duration;
                offset = totalDuration - duration;
            }
            return new Coords(offset, duration);
        }
        return new Coords(0L, totalDuration);
    }

    void checkParsed(VideoFile videoFile) {
        if (!videoFile.isParsed()) {
            throw new IllegalStateException("only parsed videofiles please.");
        }
    }

    public Double getLengthRatio() {
        return this.lengthRatio;
    }

    public Long getOffsetMillis() {
        return this.offsetMillis;
    }

    public static class Converter
    implements CommandLine.ITypeConverter<RangeSelection> {
        private static final Pattern OFFSET_ONLY = Pattern.compile("(?x) ^ @ \\s* ([-+]?) \\s* (\\d+) $");
        private static final Pattern PERCENT_ONLY = Pattern.compile("(?x) ^ ([-+]?) \\s* (\\d+ \\.? \\d*) \\s* [%] $");
        private static final Pattern OFFSET_AND_PERCENT = Pattern.compile("(?x) ^ [+]? \\s* (\\d+ \\.? \\d*) \\s* [%] \\s* @ \\s* [+]? \\s* (\\d+) $");

        public RangeSelection convert(String value) {
            String s = StringUtils.trimToEmpty((String)value);
            if (StringUtils.isEmpty((CharSequence)s)) {
                return COMPLETELY;
            }
            Matcher matcher = PERCENT_ONLY.matcher(s);
            if (matcher.matches()) {
                String sign = StringUtils.trimToEmpty((String)matcher.group(1));
                String percentString = StringUtils.trimToEmpty((String)matcher.group(2));
                double percentValue = Double.parseDouble(percentString);
                return "-".equals(sign) ? RangeSelection.ofLastPercent(percentValue) : RangeSelection.ofFirstPercent(percentValue);
            }
            matcher = OFFSET_ONLY.matcher(s);
            if (matcher.matches()) {
                String sign = StringUtils.trimToEmpty((String)matcher.group(1));
                String offsetMillisString = StringUtils.trimToEmpty((String)matcher.group(2));
                long offset = Long.parseLong(offsetMillisString);
                RangeSelection rangeSelection = new RangeSelection();
                rangeSelection.setOffsetMillis("-".equals(sign) ? -offset : offset);
                rangeSelection.setLengthRatio(null);
                return rangeSelection;
            }
            matcher = OFFSET_AND_PERCENT.matcher(s);
            if (matcher.matches()) {
                String percentString = StringUtils.trimToEmpty((String)matcher.group(1));
                String offsetMillisString = StringUtils.trimToEmpty((String)matcher.group(2));
                double percentValue = 0.01 * Double.parseDouble(percentString);
                long offset = Long.parseLong(offsetMillisString);
                RangeSelection rangeSelection = new RangeSelection();
                rangeSelection.setOffsetMillis(offset);
                rangeSelection.setLengthRatio(percentValue);
                return rangeSelection;
            }
            throw new IllegalArgumentException("Unsupported Range Selection format: '" + s + "'");
        }
    }

    public static class Coords {
        private final long lengthMillis;
        private final long offsetMillis;

        Coords(long offsetMillis, long lengthMillis) {
            this.offsetMillis = offsetMillis;
            this.lengthMillis = lengthMillis;
        }

        public long getOffsetMillis() {
            return this.offsetMillis;
        }

        public long getLengthMillis() {
            return this.lengthMillis;
        }
    }
}

