/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.videotools.commandline;

import com.myapp.util.text.NumericStringComparator;
import com.myapp.videotools.misc.Broadcast;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import picocli.CommandLine;
import picocli.custom.CustomTypeConverters;

@CommandLine.Command
public class Filters {
    public static final int DEFAULT_THRESHOLD_SECS = 1800;
    public static final String OPT_NON_MATCHING_FILTERS = "--show-non-matching-filters";
    private Set<String> blackListPrefix = new TreeSet<String>();
    private Set<String> blackList = new TreeSet<String>();
    private Set<String> blackListChannels = new TreeSet<String>();
    private Set<String> blackListRegex = new TreeSet<String>();
    private Set<String> blackListDescriptionRegex = new TreeSet<String>();
    @CommandLine.Option(names={"--duration-threshold", "-dth"}, converter={CustomTypeConverters.PositiveInteger.class}, defaultValue="1800", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="INT", description={"The minimum duration in seconds of a tvthek item, shorter items will be filtered."})
    private int thresholdSecs = 1800;
    @CommandLine.Option(names={"--show-non-matching-filters", "-showfilt"}, showDefaultValue=CommandLine.Help.Visibility.ALWAYS, defaultValue="false", description={"Shows which filters did not match any broadcasts."})
    private boolean showUnNecessaryFilters = false;
    private Map<FilterType, List<FilterResult>> stats = new EnumMap<FilterType, List<FilterResult>>(FilterType.class);

    public Filters() {
        this.populateBlacklists();
    }

    public void clear() {
        this.stats.clear();
        this.blackListChannels.clear();
        this.blackListPrefix.clear();
        this.blackListRegex.clear();
        this.blackList.clear();
        this.blackListDescriptionRegex.clear();
    }

    private List<FilterResult> filter(Broadcast bc, List<Broadcast> allBroadcasts) {
        ArrayList<FilterResult> matchingFilters = new ArrayList<FilterResult>();
        if (bc == null) {
            matchingFilters.add(new FilterResult(FilterType.PARSE_ERROR));
            return matchingFilters;
        }
        String title = bc.getTitle().replaceAll("^AD \\| ", "");
        if (this.blackList.contains(title)) {
            matchingFilters.add(new FilterResult(FilterType.TITLE_EXACT, title));
        }
        this.blackListPrefix.forEach(prefix -> {
            if (title.startsWith((String)prefix)) {
                matchingFilters.add(new FilterResult(FilterType.TITLE_PREFIX, (String)prefix));
            }
        });
        this.blackListRegex.forEach(regex -> {
            if (Pattern.compile(regex).matcher(title).find()) {
                matchingFilters.add(new FilterResult(FilterType.TITLE_REGEX, (String)regex));
            }
        });
        this.blackListDescriptionRegex.forEach(regex -> {
            if (Pattern.compile(regex).matcher(bc.getDescription()).find()) {
                matchingFilters.add(new FilterResult(FilterType.DESCRIPTION_REGEX, (String)regex));
            }
        });
        if (bc.getTitle().startsWith("AD | ") && allBroadcasts.stream().anyMatch(x -> x.getTitle().equals(title))) {
            matchingFilters.add(new FilterResult(FilterType.AD_COPY, bc.getTitle()));
        }
        if (bc.getDurationSeconds() > 0 && bc.getDurationSeconds() < this.thresholdSecs) {
            matchingFilters.add(new FilterResult(FilterType.TIME));
        }
        if (this.blackListChannels.contains(bc.getTvChannel())) {
            matchingFilters.add(new FilterResult(FilterType.CHANNEL, bc.getTvChannel()));
        }
        return matchingFilters;
    }

    public void showUnnecessaryFilters() {
        List<FilterResult> byDescriptionRegex;
        List<FilterResult> byTitlePrefix;
        List<FilterResult> byTitleRegex;
        List<FilterResult> byChannel;
        Arrays.stream(FilterType.values()).filter(key -> !this.stats.containsKey(key)).forEach(x -> System.err.println("Filtertype with no match: " + (Object)x));
        List<FilterResult> byTitleExact = this.stats.get((Object)FilterType.TITLE_EXACT);
        if (byTitleExact != null) {
            this.blackList.stream().sorted().filter(title -> byTitleExact.stream().noneMatch(hit -> title.equals(hit.reason))).forEach(x -> System.err.println("blackList entry '" + x + "' did not match anything."));
        }
        if ((byChannel = this.stats.get((Object)FilterType.CHANNEL)) != null) {
            this.blackListChannels.stream().sorted().filter(channel -> byChannel.stream().noneMatch(hit -> channel.equals(hit.reason))).forEach(x -> System.err.println("blackListChannel entry '" + x + "' did not match anything."));
        }
        if ((byTitleRegex = this.stats.get((Object)FilterType.TITLE_REGEX)) != null) {
            this.blackListRegex.stream().sorted().filter(regex -> byTitleRegex.stream().noneMatch(hit -> regex.equals(hit.reason))).forEach(x -> System.err.println("blackListRegex entry '" + x + "' did not match anything."));
        }
        if ((byTitlePrefix = this.stats.get((Object)FilterType.TITLE_PREFIX)) != null) {
            this.blackListPrefix.stream().filter(channel -> byTitlePrefix.stream().noneMatch(hit -> channel.equals(hit.reason))).sorted().forEach(x -> System.err.println("blackListPrefix entry '" + x + "' did not match anything."));
        }
        if ((byDescriptionRegex = this.stats.get((Object)FilterType.DESCRIPTION_REGEX)) != null) {
            this.blackListDescriptionRegex.stream().filter(channel -> byDescriptionRegex.stream().noneMatch(hit -> channel.equals(hit.reason))).sorted().forEach(x -> System.err.println("descriptionRegex entry '" + x + "' did not match anything."));
        }
        for (String p : this.blackListPrefix) {
            for (String s : this.blackList) {
                if (!s.startsWith(p)) continue;
                System.err.println(s + " starts with " + p);
            }
        }
        for (String p : this.blackListRegex) {
            Matcher matcher = Pattern.compile(p).matcher("foo");
            for (String s : this.blackList) {
                if (!matcher.reset(s).find()) continue;
                System.err.println(s + " matches " + p);
            }
            for (String s : this.blackListPrefix) {
                if (!matcher.reset(s).find()) continue;
                System.err.println(s + " matches " + p);
            }
        }
    }

    public String showFilterStatistics() {
        List<FilterResult> byTime = this.stats.get((Object)FilterType.TIME);
        List<FilterResult> byTitleExact = this.stats.get((Object)FilterType.TITLE_EXACT);
        List<FilterResult> byChannel = this.stats.get((Object)FilterType.CHANNEL);
        List<FilterResult> byTitleRegex = this.stats.get((Object)FilterType.TITLE_REGEX);
        List<FilterResult> byAdCopy = this.stats.get((Object)FilterType.AD_COPY);
        List<FilterResult> byTitlePrefix = this.stats.get((Object)FilterType.TITLE_PREFIX);
        List<FilterResult> byDescriptionRegex = this.stats.get((Object)FilterType.DESCRIPTION_REGEX);
        List<FilterResult> byParseError = this.stats.get((Object)FilterType.PARSE_ERROR);
        ArrayList<String> stmts = new ArrayList<String>();
        if (byTime != null) {
            stmts.add("Time('t < " + this.thresholdSecs / 60 + " min':" + byTime.size() + ")");
        }
        if (byTitleExact != null) {
            stmts.add("Title(" + byTitleExact.size() + ")");
        }
        if (byChannel != null) {
            stmts.add("Channel(" + Filters.distinctCountsString(byChannel) + ")");
        }
        if (byAdCopy != null) {
            stmts.add("AdCopy(" + byAdCopy.size() + ")");
        }
        if (byTitleRegex != null) {
            stmts.add("TitleRegex(" + Filters.distinctCountsString(byTitleRegex) + ")");
        }
        if (byTitlePrefix != null) {
            stmts.add("TitlePrefix(" + Filters.distinctCountsString(byTitlePrefix) + ")");
        }
        if (byDescriptionRegex != null) {
            stmts.add("DescriptionRegex(" + Filters.distinctCountsString(byDescriptionRegex) + ")");
        }
        if (byParseError != null) {
            stmts.add("Unparseable(" + byParseError.size() + ")");
        }
        return "FilterType: [\n    " + String.join((CharSequence)"\n    ", stmts) + "\n]";
    }

    public boolean isInteresting(Broadcast bc, List<Broadcast> allBroadcasts) {
        return 0L == this.filter(bc, allBroadcasts).stream().peek(fr -> this.stats.computeIfAbsent(fr.type, foo -> new ArrayList()).add(fr)).count();
    }

    private static String distinctCountsString(List<FilterResult> filterResults) {
        return filterResults.size() + " - " + filterResults.stream().map(x -> x.reason).distinct().collect(Collectors.toMap(channelName -> channelName, cn -> filterResults.stream().filter(x -> x.reason.equals(cn)).count())).entrySet().stream().map(e -> e.getValue() + "x'" + (String)e.getKey() + "'").sorted(new NumericStringComparator().reversed()).collect(Collectors.joining(", "));
    }

    public boolean isShowUnNecessaryFilters() {
        return this.showUnNecessaryFilters;
    }

    public void setShowUnNecessaryFilters(boolean showUnNecessaryFilters) {
        this.showUnNecessaryFilters = showUnNecessaryFilters;
    }

    private void populateBlacklists() {
        this.blackListChannels.add("ORF Sport+");
        this.blackListRegex.add("(?i)wahlkampf");
        this.blackListRegex.add("\\b(SP\u00d6|FP\u00d6|\u00d6VP)\\b");
        this.blackListRegex.add("(?i)\\b(Weltmeisterschaft|Weltcup|Nordische Kombination|Ski alpin)\\b");
        this.blackListRegex.add("\\b(Weltcup)\\b");
        this.blackListPrefix.add("Pressefoyer ");
        this.blackListPrefix.add("Pressegespr\u00e4ch ");
        this.blackListPrefix.add("Pressekonferenz: ");
        this.blackListPrefix.add("Pressekonferenz ");
        this.blackListPrefix.add("Rosamunde Pilcher: ");
        this.blackListPrefix.add("Fu\u00dfball: ");
        this.blackListPrefix.add("Biathlon-WM ");
        this.blackListPrefix.add("ZIB ");
        this.blackListPrefix.add("Guten Morgen \u00d6sterreich");
        this.blackListPrefix.add("Wetter");
        this.blackListPrefix.add("Politik Spezial: ");
        this.blackListPrefix.add("Snowboard: ");
        this.blackListPrefix.add("Tischtennis: ");
        this.blackListPrefix.add("Judo: ");
        this.blackListPrefix.add("Rallye: ");
        this.blackListPrefix.add("Weltjournal");
        this.blackListPrefix.add("Sport ");
        this.blackListPrefix.add("Fu\u00dfball");
        this.blackListPrefix.add("Sport-");
        this.blackListPrefix.add("St\u00f6ckl ");
        this.blackListPrefix.add("ST\u00d6CKL.");
        this.blackListPrefix.add("Tatort");
        this.blackListPrefix.add("Seitenblicke");
        this.blackListPrefix.add("[WETTER] ZIB");
        this.blackListPrefix.add("Dancing Stars");
        this.blackListPrefix.add("Lasko ");
        this.blackListPrefix.add("Mordshunger ");
        this.blackListPrefix.add("Herzflimmern ");
        this.blackListPrefix.add("Nationalrat");
        this.blackListPrefix.add("ORF III Aktuell");
        this.blackListPrefix.add("Medicopter 117");
        this.blackListPrefix.add("B\u00fcrgeranwalt");
        this.blackListPrefix.add("Die Chefin");
        for (String x : new String[]{"\u00d6sterreich", "Vorarlberg", "Tirol", "Salzburg", "K\u00e4rnten", "Steiermark", "Ober\u00f6sterreich", "Nieder\u00f6sterreich", "Wien", "Burgenland", "S\u00fcdtirol"}) {
            this.blackListPrefix.add(x + " heute");
        }
        this.blackList.add("Sp\u00e4t-ZIB");
        this.blackList.add("Soko Kitzb\u00fchel");
        this.blackList.add("Servus Kasperl");
        this.blackList.add("Newton");
        this.blackList.add("Report");
        this.blackList.add("Thema");
        this.blackList.add("Themenmontag");
        this.blackList.add("Kommissar Rex");
        this.blackList.add("Die Millionenshow");
        this.blackList.add("Euromillionen");
        this.blackList.add("Soko Donau");
        this.blackList.add("Lotto 6 aus 45");
        this.blackList.add("Helmi");
        this.blackList.add("Eco");
        this.blackList.add("Hohes Haus");
        this.blackList.add("Heimat \u00d6sterreich");
        this.blackList.add("Land der Berge");
        this.blackList.add("Im Brennpunkt");
        this.blackList.add("Im Zentrum");
        this.blackList.add("Formel 1");
        this.blackList.add("konkret");
        this.blackList.add("konkret (\u00d6GS)");
        this.blackList.add("kreuz und quer");
        this.blackList.add("Tom Turbo");
        this.blackList.add("Unser \u00d6sterreich");
        this.blackList.add("Unterwegs in \u00d6sterreich");
        this.blackList.add("Barbara Karlich Show");
        this.blackList.add("\u010cesk\u00e9 & Slovensk\u00e9 Ozveny");
        this.blackList.add("Dobar dan Hrvati");
        this.blackList.add("Dober dan, Koro\u0161ka");
        this.blackList.add("Dober dan, \u0160tajerska");
        this.blackList.add("Echt Fett");
        this.blackList.add("Schmatzo - Der Koch-Kids-Club");
        this.blackList.add("Schmatzo - Kochen mit WOW");
        this.blackList.add("Servus Szia Zdravo Del tuha");
        this.blackList.add("Servus, Sre\u010dno, Ciao");
        this.blackList.add("Willkommen \u00d6sterreich");
        this.blackList.add("Mein D\u00f6bling");
        this.blackList.add("Klingendes \u00d6sterreich");
        this.blackList.add("Verstehen Sie Spa\u00df?");
        this.blackList.add("zeit.geschichte");
        this.blackList.add("Mittag in \u00d6sterreich");
        this.blackList.add("Mord in bester Gesellschaft");
        this.blackList.add("Pressestunde");
        this.blackList.add("Erlebnis B\u00fchne");
        this.blackList.add("Wilde Reise mit Erich Pr\u00f6ll");
        this.blackList.add("erLesen");
        this.blackList.add("kulturMontag");
        this.blackList.add("matinee am Sonntag");
        this.blackList.add("Politik live");
        this.blackList.add("DOK.eins");
        this.blackList.add("Expeditionen");
        this.blackList.add("Studio 2");
        this.blackList.add("Universum History");
        this.blackList.add("Universum");
        this.blackList.add("Am Schauplatz");
        this.blackList.add("Treffpunkt Medizin");
        this.blackList.add("Der Zigeunerbaron");
        this.blackList.add("Der Alte");
        this.blackList.add("Die Tafelrunde");
        this.blackList.add("Was gibt es Neues?");
        this.blackList.add("Was sch\u00e4tzen Sie?");
        this.blackList.add("Doctor's Diary");
        this.blackList.add("B\u00fcrgeranwalt");
        this.blackList.add("Erbe \u00d6sterreich");
        this.blackList.add("MERYNS sprechzimmer");
        this.blackList.add("Quantensprung");
        this.blackList.add("Evangelischer Gottesdienst");
        this.blackList.add("Rosamunde Pilcher");
        this.blackList.add("ORF-1-Freistunde: ");
        this.blackList.add("Q1 Ein Hinweis ist falsch");
        this.blackList.add("AKTUELL nach eins");
        this.blackList.add("Bergweihnacht");
        this.blackList.add("Die Promi-Millionenshow");
        this.blackList.add("Die Wintercamper");
        this.blackList.add("Vera");
        this.blackList.add("Katholischer Gottesdienst");
        this.blackList.add("Quiz ohne Grenzen");
        this.blackList.add("Talk 1");
        this.blackList.add("matinee am Feiertag");
        this.blackList.add("Das Traumhotel");
        this.blackList.add("Letzter Wille");
        this.blackList.add("Gute Nacht \u00d6sterreich");
        this.blackList.add("xxxxxxxxxxxxxxxxxxxx");
        this.blackList.add("xxxxxxxxxxxxxxxxxxxx");
        this.blackList.add("xxxxxxxxxxxxxxxxxxxx");
        this.blackList.add("xxxxxxxxxxxxxxxxxxxx");
        this.blackList.add("xxxxxxxxxxxxxxxxxxxx");
        this.blackList.add("xxxxxxxxxxxxxxxxxxxx");
        this.blackList.add("xxxxxxxxxxxxxxxxxxxx");
        this.blackListDescriptionRegex.add("Polit-Talk");
        this.blackListDescriptionRegex.add("Krimiserie");
    }

    static class FilterResult {
        String reason;
        FilterType type;

        FilterResult(FilterType type, String reason) {
            this.type = type;
            this.reason = reason;
        }

        FilterResult(FilterType type) {
            this(type, null);
        }
    }

    static enum FilterType {
        TITLE_EXACT,
        TITLE_PREFIX,
        TITLE_REGEX,
        CHANNEL,
        TIME,
        AD_COPY,
        DESCRIPTION_REGEX,
        PARSE_ERROR;

    }
}

