/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.videotools.commandline;

import com.myapp.videotools.commandline.BigPictureCommand;
import com.myapp.videotools.commandline.CaptureFrameCommand;
import com.myapp.videotools.commandline.CreateThumbsCommand;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(subcommands={CommandLine.HelpCommand.class, BigPictureCommand.class, CaptureFrameCommand.class, CreateThumbsCommand.class})
public class CommandLineInterpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandLineInterpreter.class);

    public static int runProgram(PrintStream out, final PrintStream err, String ... args) {
        List commandLines;
        if (args == null) {
            throw new NullPointerException("args is null");
        }
        CommandLine testCommand = new CommandLine((Object)new CommandLineInterpreter());
        if (args.length == 0) {
            CommandLineInterpreter.showUsage(err, testCommand);
            return 1;
        }
        if (args[0].equals("--help") || args[0].equals("-?") || args[0].equals("-help")) {
            CommandLineInterpreter.showUsage(out, testCommand);
            return 0;
        }
        final AtomicInteger exitCode = new AtomicInteger(0);
        CommandLine.DefaultExceptionHandler<List<Object>> eh = new CommandLine.DefaultExceptionHandler<List<Object>>(){

            public List<Object> handleException(CommandLine.ParameterException ex, PrintStream out, CommandLine.Help.Ansi ansi, String ... args) {
                return this.handleParseException(ex, args);
            }

            public List<Object> handleExecutionException(CommandLine.ExecutionException ex, CommandLine.ParseResult pr) {
                exitCode.set(2);
                String errorMessage = ex.getMessage();
                for (Object cause = ex; cause != null; cause = cause.getCause()) {
                    if (cause instanceof CommandLine.PicocliException) continue;
                    errorMessage = cause.getMessage();
                    break;
                }
                err.println("ERROR: " + errorMessage);
                LOGGER.debug("An error occured during execution.", (Throwable)ex);
                return null;
            }

            public List<Object> handleParseException(CommandLine.ParameterException ex, String[] args) {
                exitCode.set(1);
                err.println("ERROR: " + ex.getMessage());
                LOGGER.debug("An error occured during parsing " + Arrays.toString(args), (Throwable)ex);
                return null;
            }
        };
        eh.useErr(err);
        eh.useOut(out);
        try {
            commandLines = testCommand.parse(args);
        }
        catch (CommandLine.ParameterException pe) {
            eh.handleException(pe, err, eh.ansi(), args);
            return exitCode.get();
        }
        Optional<CommandLine> helpCmdOptional = commandLines.stream().filter(CommandLine::isUsageHelpRequested).findFirst();
        if (helpCmdOptional.isPresent()) {
            CommandLine commandLine = helpCmdOptional.get();
            CommandLineInterpreter.showUsage(out, commandLine);
            return 0;
        }
        Optional<CommandLine> helpOptional = commandLines.stream().filter(c -> c.getCommandSpec().helpCommand()).findFirst();
        if (helpOptional.isPresent()) {
            CommandLineInterpreter.showUsage(out, testCommand);
            return 0;
        }
        CommandLine commandLine = new CommandLine((Object)new CommandLineInterpreter());
        commandLine.parseWithHandlers((CommandLine.IParseResultHandler2)new CommandLine.RunLast(), (CommandLine.IExceptionHandler2)eh, args);
        return exitCode.get();
    }

    private static void showUsage(PrintStream printStream, CommandLine commandLine) {
        CommandLine.Help help = new CommandLine.Help(commandLine.getCommandSpec(), CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)CommandLine.Help.Ansi.AUTO));
        int width = Stream.of(System.getProperty("COLUMNS"), System.getenv("COLUMNS")).map(StringUtils::trimToEmpty).filter(StringUtils::isNotEmpty).filter(s -> s.matches("\\d{2,3}")).mapToInt(Integer::parseInt).findFirst().orElse(-1);
        if (width >= 80 && width < 400) {
            commandLine.setUsageHelpWidth(width);
        }
        StringBuilder usage = CommandLine.usage((StringBuilder)new StringBuilder(), (CommandLine.Help)help);
        printStream.println(usage);
    }
}

