/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.videotools.commandline;

import com.myapp.videotools.commandline.Filters;
import com.myapp.videotools.commandline.VideoToolsBaseCommand;
import com.myapp.videotools.misc.Broadcast;
import com.myapp.videotools.misc.SeleniumHolder;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import picocli.CommandLine;
import picocli.custom.CustomTypeConverters;

@CommandLine.Command(name="tvthek", aliases={"--check-tvthek", "-tv"}, description={"Create a single frame snapshot image of a videofile"})
public class CheckForDownloadableMoviesCommand
extends VideoToolsBaseCommand {
    public static final String CMD_NAME = "tvthek";
    public static final String OPT_THRESHOLD = "--duration-threshold";
    public static final String OPT_WRITE_CACHE_FILE = "--write-cache-file";
    public static final String OPT_READ_CACHE_FILE = "--read-cache-file";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    private SeleniumHolder seleniumHolder = new SeleniumHolder();
    @CommandLine.Mixin
    private Filters filterSettings = new Filters();
    @CommandLine.Option(names={"--read-cache-file", "-rcf"}, converter={CustomTypeConverters.ReadableFile.class}, description={"Read broadcasts from a file instead of fetching from ORF."})
    private File broadcastInput = null;
    @CommandLine.Option(names={"--write-cache-file", "-wcf"}, converter={CustomTypeConverters.WriteableFile.class}, description={"Writes fetched broadcasts to a file."})
    private File broadcastOutput = null;

    @Override
    protected void executeImpl() {
        if (this.broadcastInput != null && this.broadcastOutput != null) {
            throw this.paramEx(OPT_WRITE_CACHE_FILE, "");
        }
        List<Broadcast> allBroadcasts = this.collectAllBroadcasts();
        List<Broadcast> interesting = allBroadcasts.stream().filter(bc -> this.filterSettings.isInteresting((Broadcast)bc, allBroadcasts)).sorted(Comparator.comparing(bc -> bc.getTitle().replaceFirst("^AD \\| ", ""))).collect(Collectors.toList());
        System.out.println(this.printMatchesInTextTable(allBroadcasts, interesting));
        System.out.println();
        System.out.println(this.filterSettings.showFilterStatistics());
        if (this.filterSettings.isShowUnNecessaryFilters()) {
            this.filterSettings.showUnnecessaryFilters();
        }
    }

    private List<Broadcast> collectAllBroadcasts() {
        List<Broadcast> allBroadcasts;
        if (this.broadcastInput == null) {
            allBroadcasts = this.seleniumHolder.fetchAllBroadcasts();
            if (this.broadcastOutput != null) {
                try {
                    Broadcast.toFile(this.broadcastOutput, allBroadcasts);
                }
                catch (IOException e) {
                    throw this.execEx("Unable to write to " + this.broadcastInput, e);
                }
            }
        } else {
            try {
                allBroadcasts = Broadcast.fromFile(this.broadcastInput);
            }
            catch (IOException e) {
                throw this.execEx("Unable to read from " + this.broadcastInput, e);
            }
        }
        return allBroadcasts;
    }

    private String printMatchesInTextTable(List<Broadcast> allBroadcasts, List<Broadcast> interesting) {
        StringBuilder sb = new StringBuilder();
        AtomicInteger longestTitleLen = new AtomicInteger(0);
        AtomicInteger longestAvailabilityLen = new AtomicInteger(0);
        AtomicInteger longestChannelLen = new AtomicInteger(0);
        AtomicInteger longestDurationLen = new AtomicInteger(0);
        AtomicInteger longestDescriptionLen = new AtomicInteger(0);
        interesting.parallelStream().forEach(bc -> {
            int titleLen = bc.getTitle().length();
            if (longestTitleLen.get() < titleLen) {
                longestTitleLen.set(titleLen);
            }
            int channelLen = bc.getTvChannel().length();
            if (longestChannelLen.get() < channelLen) {
                longestChannelLen.set(channelLen);
            }
            int availLen = bc.getAvailability().length();
            if (longestAvailabilityLen.get() < availLen) {
                longestAvailabilityLen.set(availLen);
            }
            int durationLen = bc.getDuration().length();
            if (longestDurationLen.get() < durationLen) {
                longestDurationLen.set(durationLen);
            }
            int descriptionLen = StringUtils.length((CharSequence)bc.getDescription());
            if (longestDescriptionLen.get() < descriptionLen) {
                longestDescriptionLen.set(descriptionLen);
            }
        });
        interesting.forEach(bc -> {
            int i;
            sb.append(bc.getTitle());
            for (i = longestTitleLen.get() - bc.getTitle().length(); i > 0; --i) {
                sb.append(" ");
            }
            sb.append(" | ");
            sb.append(bc.getTvChannel());
            for (i = longestChannelLen.get() - bc.getTvChannel().length(); i > 0; --i) {
                sb.append(" ");
            }
            sb.append(" | ");
            sb.append(bc.getDuration());
            for (i = longestDurationLen.get() - bc.getDuration().length(); i > 0; --i) {
                sb.append(" ");
            }
            sb.append(" | noch ");
            sb.append(bc.getAvailability());
            for (i = longestAvailabilityLen.get() - bc.getAvailability().length(); i > 0; --i) {
                sb.append(" ");
            }
            sb.append(" | ");
            sb.append(bc.getDescription());
            for (i = longestDescriptionLen.get() - bc.getDescription().length(); i > 0; --i) {
                sb.append(" ");
            }
            sb.append(" | ");
            sb.append(bc.getStreamUrl());
            sb.append(LINE_SEPARATOR);
        });
        sb.append(LINE_SEPARATOR);
        sb.append("Items total: ").append(allBroadcasts.size());
        sb.append(", kept: ").append(interesting.size());
        sb.append(", filtered: ").append(allBroadcasts.size() - interesting.size());
        sb.append(" Fetched at: ").append(DateTimeFormatter.ISO_DATE_TIME.format(LocalDateTime.now()));
        return sb.toString();
    }

    public static void main(String[] args) {
        CheckForDownloadableMoviesCommand cmd = new CheckForDownloadableMoviesCommand();
        cmd.executeImpl();
    }
}

