/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.videotools.commandline;

import com.myapp.videotools.AbstractPathCalculator;
import com.myapp.videotools.IVideoFileParser;
import com.myapp.videotools.IVideoThumbnailer;
import com.myapp.videotools.VideoFile;
import com.myapp.videotools.commandline.FrameDimensions;
import com.myapp.videotools.commandline.RangeSelection;
import com.myapp.videotools.commandline.VideoToolsBaseCommand;
import com.myapp.videotools.impl.Application;
import com.myapp.videotools.impl.FileHierarchyCopying;
import com.myapp.videotools.impl.NextToSourceFile;
import com.myapp.videotools.misc.AppStatistics;
import com.myapp.videotools.misc.StatisticsShutDownHook;
import com.myapp.videotools.misc.Util;
import java.io.File;
import java.io.IOException;
import org.assertj.core.util.VisibleForTesting;
import picocli.CommandLine;
import picocli.custom.CustomTypeConverters;
import picocli.custom.MessageOnlyException;

@CommandLine.Command(name="bigpic", aliases={"--create-big-picture", "-bigpic"}, description={"Combines a set of multiple thumbnails of a video file to a big-picture image file."})
public class BigPictureCommand
extends VideoToolsBaseCommand {
    static final String CMD_BIGPIC = "bigpic";
    static final String OPT_RECURSIVE = "--recursive";
    static final String OPT_INPUT_DIR = "--video-root-dir";
    static final String OPT_OUTPUT_DIR = "--big-picture-root-dir";
    static final String OPT_ROWS = "--rows";
    static final String OPT_COLUMNS = "--columns";
    static final String OPT_BP_PREFIX = "--big-picture-prefix";
    static final String OPT_BP_SUFFIX = "--big-picture-suffix";
    static final String OPT_SUPPRESS_STATISTICS = "--suppress-statistics";
    static final String OPT_ANIMATED = "--animated-gif";
    static final String OPT_RANGE_SELECTION = "--range-selection";
    @CommandLine.Option(names={"--range-selection"}, description={"Which part of the video file will be considered for the thumbnails."}, converter={RangeSelection.Converter.class})
    private RangeSelection partSelection;
    @CommandLine.Mixin
    private FrameDimensions dims = new FrameDimensions();
    @CommandLine.Option(names={"--recursive", "-R"}, description={"Recurse into directories and create big-pics for every video file found."})
    boolean recursive;
    @CommandLine.Option(names={"--video-root-dir", "-vr"}, converter={CustomTypeConverters.ReadableDirectory.class}, paramLabel="DIR", description={"Root directory where the videos are located"})
    File inDir;
    @CommandLine.Option(names={"--big-picture-root-dir", "-bpr"}, converter={CustomTypeConverters.ExistingWriteableDirectory.class}, paramLabel="DIR", description={"directory where the big-picture files will be stored. if not specified, it will be written next to the video file."})
    File outDir;
    @CommandLine.Option(names={"--rows", "-r"}, converter={CustomTypeConverters.PositiveInteger.class}, defaultValue="3", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="INT", description={"Number of rows in the big-picture grid."})
    int rows;
    @CommandLine.Option(names={"--columns", "-c"}, converter={CustomTypeConverters.PositiveInteger.class}, defaultValue="5", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="INT", description={"Number of columns in the big-picture grid."})
    int cols;
    @CommandLine.Option(names={"--big-picture-prefix", "-bp"}, defaultValue="", description={"Prefix of the big-picture files"})
    String bigPicPrefix;
    @CommandLine.Option(names={"--big-picture-suffix", "-bs"}, defaultValue=".jpeg", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, description={"Suffix of the big-picture files"})
    String bigPicSuffix;
    @CommandLine.Option(names={"--suppress-statistics"}, defaultValue="false", hidden=true, description={"Dont show stats after generating recursively"})
    boolean suppressStatistics;
    @CommandLine.Option(names={"--animated-gif", "-gif"}, defaultValue="false", description={"Generate animated gifs as big-picture"})
    boolean animated;
    @VisibleForTesting
    static StatisticsShutDownHook statisticsShutDownHook = new StatisticsShutDownHook();

    @Override
    protected void executeImpl() {
        if (this.bigPicPrefix == null || this.bigPicPrefix.contains("%")) {
            throw this.paramEx(OPT_BP_PREFIX, "must not contain '%' symbol");
        }
        if (this.recursive) {
            this.executeRecursive();
        } else {
            this.executeSingle();
        }
    }

    private void executeSingle() {
        String suffix = " when option --recursive is enabled.";
        String notWithOutputFile = "is unsupported with explicit --output-file option.";
        if (this.inDir != null) {
            throw this.paramEx(OPT_INPUT_DIR, "is only applicable" + suffix);
        }
        if (this.io.outFile != null && !"".equals(this.bigPicPrefix)) {
            throw this.paramEx(OPT_BP_PREFIX, notWithOutputFile);
        }
        if (this.io.outFile != null && !".jpeg".equals(this.bigPicSuffix)) {
            throw this.paramEx(OPT_BP_SUFFIX, notWithOutputFile);
        }
        if (this.outDir != null) {
            throw this.paramEx(OPT_OUTPUT_DIR, "is only applicable" + suffix);
        }
        if (this.io.inFile == null) {
            throw this.paramEx("--input-file", "Must be specified.");
        }
        if (this.io.outFile != null && this.io.outFile.exists() && Util.isSameFile(this.io.inFile, this.io.outFile)) {
            throw this.paramEx("--input-file", "refers to the same file as option --output-file");
        }
        boolean impliedTarget = false;
        IVideoThumbnailer tn = this.instantiateNailer();
        if (this.io.outFile == null) {
            NextToSourceFile pathCalc = new NextToSourceFile();
            pathCalc.setSuffix(this.bigPicSuffix);
            pathCalc.setPrefix(this.bigPicPrefix);
            tn.setPathCalculator(pathCalc);
            String implicitTarget = pathCalc.getTargetPath(this.io.inFile);
            try {
                this.io.outFile = CustomTypeConverters.WriteableFile.getWriteableFile((String)implicitTarget);
                impliedTarget = true;
            }
            catch (MessageOnlyException e) {
                throw this.paramEx("--output-file", "Implicit outputfile " + (Object)((Object)e) + ": " + implicitTarget);
            }
        }
        if (!this.io.overWriteExisting && this.io.outFile.exists()) {
            throw this.paramEx("--overwrite-existing", "is not enabled but target file exists.");
        }
        this.log.debug("  Configuring the video thumbnailer instance ...");
        try {
            VideoFile videoFile = new VideoFile(this.io.inFile);
            IVideoFileParser parser = Application.getInstance().createVideoFileParser();
            videoFile.parse(parser);
            tn.setVideoFile(videoFile);
            if (impliedTarget) {
                this.log.info("  Output unspecified - writing big-picture next to the video file.");
            }
            tn.createBigPicture(this.io.outFile);
        }
        catch (IOException e) {
            throw this.execEx("could not create big-picture for: " + this.io.inFile.getName() + " (" + e.getMessage() + ")", e);
        }
    }

    private void executeRecursive() {
        AbstractPathCalculator pathCalculator;
        String suffix = " when option --recursive is enabled.";
        if (this.inDir == null) {
            throw this.paramEx(OPT_INPUT_DIR, "must be specified" + suffix);
        }
        if (this.io.inFile != null) {
            throw this.paramEx("--input-file", "cannot be used" + suffix);
        }
        if (this.io.outFile != null) {
            throw this.paramEx("--output-file", "cannot be used" + suffix);
        }
        this.log.info("Creating big-pictures recursively ...");
        this.log.debug("  Configuring the video thumbnailer instance ...");
        IVideoThumbnailer tn = this.instantiateNailer();
        tn.setVideoRootDir(this.inDir);
        if (this.outDir == null) {
            this.log.info("  Files will be written next to the source file");
            pathCalculator = new NextToSourceFile();
        } else {
            this.log.info("  Files will be written into:             {}", (Object)this.outDir);
            pathCalculator = new FileHierarchyCopying(this.inDir, this.outDir);
        }
        pathCalculator.setPrefix(this.bigPicPrefix);
        String suf = this.bigPicSuffix;
        if (this.animated && this.bigPicSuffix.equals(".jpeg")) {
            suf = ".gif";
        }
        pathCalculator.setSuffix(suf);
        tn.setPathCalculator(pathCalculator);
        tn.setAnimated(this.animated);
        this.log.info("  Searching for videos in:                {} ...", (Object)tn.getVideoRootDir());
        if (!this.suppressStatistics) {
            AppStatistics instance = AppStatistics.getInstance();
            if (instance.getApplicationStart() < 0L) {
                instance.setApplicationStart();
            }
            Runtime.getRuntime().addShutdownHook(statisticsShutDownHook);
        }
        tn.createBigPictureRecursively();
        this.log.info("Created big-pictures recursively.");
    }

    protected IVideoThumbnailer instantiateNailer() {
        Application application = Application.getInstance();
        if (this.log.isDebugEnabled()) {
            this.log.debug(Util.getOsInfoString());
        }
        IVideoThumbnailer thumbnailer = application.createVideoThumbnailer();
        thumbnailer.setPreferredWidth(this.dims.thumbnailWidth);
        thumbnailer.setPreferredHeight(this.dims.thumbnailHeight);
        thumbnailer.setBigPictureRows(this.rows);
        thumbnailer.setBigPictureCols(this.cols);
        thumbnailer.setOverwritePolicy(this.io.overWriteExisting ? IVideoThumbnailer.OverwritePolicy.OVERWRITE : IVideoThumbnailer.OverwritePolicy.SKIP);
        thumbnailer.setRangeSelection(this.partSelection);
        return thumbnailer;
    }
}

