/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.videotools;

import com.myapp.util.format.TimeFormatUtil;
import com.myapp.videotools.IVideoFileParser;
import com.myapp.videotools.misc.AppStatistics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.assertj.core.util.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VideoFile {
    private static final Logger log = LoggerFactory.getLogger(VideoFile.class);
    private final File file;
    private boolean parsed = false;
    private String videoFormat = null;
    private String videoCodec = null;
    private String audioCodec = null;
    private String audioChannelType = null;
    private int audioSampleRate = -1;
    private int audioBytesPerSecond = -1;
    private int totalBytesPerSecond = -1;
    private int videoBytesPerSecond = -1;
    private double videoFramesPerSecond = -1.0;
    private int videoWidth = -1;
    private int videoHeight = -1;
    private long lengthMillis = -1L;
    private long videoStartOffsetMillis = 0L;
    private AppStatistics statistics = AppStatistics.getInstance();

    public VideoFile(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.file = file;
    }

    public VideoFile(String path) {
        this(new File(path));
    }

    public void parse(IVideoFileParser parser) throws IOException {
        long start = System.currentTimeMillis();
        try {
            this.parse0(parser);
            this.parsed = true;
            this.statistics.incrementFilesParsed();
        }
        catch (IOException | RuntimeException e) {
            this.statistics.incrementParseFails();
            throw e;
        }
        finally {
            long timeNeeded = System.currentTimeMillis() - start;
            this.statistics.addTimeSpentWithParsingMetadata(timeNeeded);
        }
    }

    private void parse0(IVideoFileParser parser) throws IOException {
        if (parser == null) {
            throw new NullPointerException();
        }
        if (!this.file.exists()) {
            throw new FileNotFoundException(this.file.getAbsolutePath());
        }
        if (this.file.isDirectory()) {
            throw new IllegalArgumentException(this.file.getAbsolutePath());
        }
        parser.parse(this);
        String path = this.file.getPath();
        if (this.videoFormat == null) {
            log.trace("      videoFormat could not be determined            : {}", (Object)path);
        }
        if (this.videoCodec == null) {
            log.trace("      videoCodec could not be determined          : {}", (Object)path);
        }
        if (this.audioCodec == null) {
            log.trace("      audioCodec could not be determined          : {}", (Object)path);
        }
        if (this.audioChannelType == null) {
            log.trace("      audioChannelType could not be determined    : {}", (Object)path);
        }
        if (this.audioSampleRate <= 0) {
            log.trace("      audioSampleRate could not be determined     : {}", (Object)path);
        }
        if (this.totalBytesPerSecond <= 0) {
            log.trace("      bytesPerSecond could not be determined      : {}", (Object)path);
        }
        if (this.videoFramesPerSecond <= 0.0) {
            log.trace("      framesPerSecond could not be determined     : {}", (Object)path);
        }
        if (this.videoWidth <= 0) {
            log.warn("      width could not be determined               : {}", (Object)path);
        }
        if (this.videoHeight <= 0) {
            log.warn("      height could not be determined              : {}", (Object)path);
        }
        if (this.audioBytesPerSecond <= 0) {
            log.trace("      audioBytesPerSecond could not be determined : {}", (Object)path);
        }
        if (this.lengthMillis == -1L) {
            throw new RuntimeException("Unable to parse video file: " + path);
        }
    }

    public boolean isParsed() {
        return this.parsed;
    }

    public File getFile() {
        return this.file;
    }

    public String getAudioChannelType() {
        return this.audioChannelType;
    }

    public String getAudioCodec() {
        return this.audioCodec;
    }

    public int getAudioSampleRate() {
        return this.audioSampleRate;
    }

    public int getTotalBytesPerSecond() {
        return this.totalBytesPerSecond;
    }

    public String getVideoFormat() {
        return this.videoFormat;
    }

    public double getVideoFramesPerSecond() {
        return this.videoFramesPerSecond;
    }

    public int getVideoHeight() {
        return this.videoHeight;
    }

    public long getLengthMillis() {
        return this.lengthMillis;
    }

    public String getVideoCodec() {
        return this.videoCodec;
    }

    public int getVideoWidth() {
        return this.videoWidth;
    }

    public double getLengthSeconds() {
        return (double)this.lengthMillis / 1000.0;
    }

    public String getFormattedLength() {
        return TimeFormatUtil.formatTimeTo2Digits((double)this.getLengthSeconds());
    }

    public String getName() {
        return this.file.getName();
    }

    public VideoFile setVideoFormat(String fileType) {
        this.videoFormat = fileType;
        return this;
    }

    public VideoFile setVideoCodec(String videoCodec) {
        this.videoCodec = videoCodec;
        return this;
    }

    public VideoFile setAudioCodec(String audioCodec) {
        this.audioCodec = audioCodec;
        return this;
    }

    public VideoFile setAudioChannelType(String type) {
        this.audioChannelType = type;
        return this;
    }

    public VideoFile setAudioSampleRate(int rate) {
        this.audioSampleRate = rate;
        return this;
    }

    public VideoFile setTotalBytesPerSecond(int bps) {
        this.totalBytesPerSecond = bps;
        return this;
    }

    public VideoFile setVideoFramesPerSecond(double fps) {
        this.videoFramesPerSecond = fps;
        return this;
    }

    public VideoFile setVideoWidth(int width) {
        this.videoWidth = width;
        return this;
    }

    public VideoFile setVideoHeight(int height) {
        this.videoHeight = height;
        return this;
    }

    public VideoFile setLengthMillis(long lengthMillis) {
        this.lengthMillis = lengthMillis;
        return this;
    }

    public VideoFile setVideoStartOffsetMillis(long millis) {
        this.videoStartOffsetMillis = millis;
        return this;
    }

    public long getVideoStartOffsetMillis() {
        return this.videoStartOffsetMillis;
    }

    public VideoFile setVideoBytesPerSecond(int bps) {
        this.videoBytesPerSecond = bps;
        return this;
    }

    public int getVideoBytesPerSecond() {
        return this.videoBytesPerSecond;
    }

    public VideoFile setAudioBytesPerSecond(int bps) {
        this.audioBytesPerSecond = bps;
        return this;
    }

    public int getAudioBytesPerSecond() {
        return this.audioBytesPerSecond;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.file != null) {
            s.append(this.getName());
        }
        if (this.videoFormat != null) {
            s.append(" type:");
            s.append(this.getVideoFormat());
        }
        if (this.lengthMillis > 0L) {
            s.append(", duration: ");
            s.append(this.getFormattedLength());
        }
        if (this.totalBytesPerSecond > 0) {
            s.append(", bitrate:");
            s.append(this.getTotalBytesPerSecond());
            s.append("b/s");
        }
        if (s.length() > 0) {
            s.append(", ");
        }
        s.append("VIDEO:[");
        if (this.videoCodec != null) {
            s.append("codec=");
            s.append(this.getVideoCodec());
            s.append(" ");
        }
        if (this.videoFramesPerSecond > 0.0) {
            s.append("frames=");
            s.append(this.getVideoFramesPerSecond());
            s.append("fps ");
        }
        if (this.videoWidth > 0 && this.videoHeight > 0) {
            s.append("dimension=");
            s.append(this.getVideoWidth());
            s.append("x");
            s.append(this.getVideoHeight());
            s.append(" ");
        }
        if (this.videoBytesPerSecond > 0) {
            s.append("bitrate=");
            s.append(this.getVideoBytesPerSecond());
            s.append("b/s ");
        }
        if (this.videoStartOffsetMillis > 0L) {
            s.append("offset=");
            s.append(this.getVideoStartOffsetMillis());
            s.append("ms");
        }
        s.append("]");
        s.append(", ");
        s.append("AUDIO:[");
        if (this.audioCodec != null) {
            s.append("codec=");
            s.append(this.getAudioCodec());
            s.append(" ");
        }
        if (this.audioSampleRate > 0) {
            s.append("samplerate=");
            s.append(this.getAudioSampleRate());
            s.append(" ");
        }
        if (this.audioChannelType != null) {
            s.append("channeltype=");
            s.append(this.getAudioChannelType());
            s.append(" ");
        }
        if (this.audioBytesPerSecond > 0) {
            s.append("bitrate=");
            s.append(this.getAudioBytesPerSecond());
            s.append("b/s");
        }
        s.append("]");
        return s.toString();
    }

    @VisibleForTesting
    public VideoFile _setParsed() {
        this.parsed = true;
        return this;
    }
}

