/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.videotools;

import com.myapp.videotools.IPathCalculator;
import com.myapp.videotools.VideoFile;
import com.myapp.videotools.commandline.RangeSelection;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.List;

public interface IVideoThumbnailer {
    public static final int DEFAULT_THUMB_WIDTH = 410;
    public static final int DEFAULT_THUMB_HEIGHT = 330;
    public static final int DEFAULT_BIG_PIC_COLS = 5;
    public static final int DEFAULT_BIG_PIC_ROWS = 3;
    public static final int DEFAULT_BIG_PIC_SCREENSHOT_COUNT = 15;
    public static final String DEFAULT_THUMB_FILE_NAME_PREFIX = "thumb_";
    public static final String DEFAULT_BIGPIC_FILENAME_PREFIX = "";
    public static final String DEFAULT_BIGPIC_FILENAME_SUFFIX = ".jpeg";
    public static final String DEFAULT_BIGPIC_FILENAME_SUFFIX_ANIMATED = ".gif";

    public boolean createBigPicture(File var1) throws IOException;

    public boolean createAnimatedBigPicture(File var1, int var2) throws IOException;

    public void createBigPictureRecursively();

    default public void createBigPictureRecursively(String folder) {
        this.setVideoRootDir(new File(folder));
        this.createBigPictureRecursively();
    }

    public List<File> createThumbnailSeries(int var1, File var2) throws IOException;

    public void captureSingleImage(double var1, int var3, int var4, File var5) throws IOException;

    default public void captureImageOriginalSize(double timeOffset, File out) throws IOException {
        VideoFile videoFile = this.getVideoFile();
        this.captureSingleImage(timeOffset, videoFile.getVideoHeight(), videoFile.getVideoWidth(), out);
    }

    default public void captureImage(double timeOffset, File out) throws IOException {
        int height = this.getPreferredHeight();
        int width = this.getPreferredWidth();
        this.captureSingleImage(timeOffset, width, height, out);
    }

    public void setRangeSelection(RangeSelection var1);

    public void setOverwritePolicy(OverwritePolicy var1);

    public OverwritePolicy getOverwritePolicy();

    public VideoFile getVideoFile();

    public void setVideoFile(VideoFile var1);

    public File getVideoRootDir();

    public void setVideoRootDir(File var1);

    public void setPreferredWidth(int var1);

    public int getPreferredWidth();

    public int getPreferredHeight();

    public void setPreferredHeight(int var1);

    public void setPathCalculator(IPathCalculator var1);

    public IPathCalculator getPathCalculator();

    public int getBigPictureCols();

    public void setBigPictureCols(int var1);

    public int getBigPictureRows();

    public void setBigPictureRows(int var1);

    public FileFilter getFileFilter();

    public void setFileFilter(FileFilter var1);

    public boolean isAnimated();

    public void setAnimated(boolean var1);

    public static enum OverwritePolicy {
        SKIP,
        OVERWRITE;

    }
}

