/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.videotools;

import com.myapp.videotools.misc.Configuration;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultVideoFileFilter
implements FileFilter {
    private static final Logger log = LoggerFactory.getLogger(DefaultVideoFileFilter.class);
    private static final String EXCLUDED_FILE_SUFFIXES_PROPKEY = "EXCLUDED_FILE_SUFFIXES";
    private Set<String> excludedExtensions = new HashSet<String>();

    public DefaultVideoFileFilter() {
        log.trace("  loading file filter from config file {}", (Object)"videotool.properties");
        this.readConfigFile();
        log.trace("  OK, file filter loaded.");
    }

    public void readConfigFile() {
        String excludies = Configuration.getInstance().getProperty(EXCLUDED_FILE_SUFFIXES_PROPKEY);
        String[] excl = excludies.split(",");
        Arrays.stream(excl).forEach(ex -> this.excludedExtensions.add(ex.toLowerCase()));
        log.trace("    {} files will be filtered: {}", (Object)this.excludedExtensions.size(), (Object)excludies);
    }

    @Override
    public boolean accept(File f) {
        if (!f.exists() || f.isDirectory() || f.isHidden()) {
            return false;
        }
        String name = f.getName().toLowerCase();
        if (name.endsWith("~")) {
            return false;
        }
        int lastDotPos = name.lastIndexOf(".");
        if (lastDotPos <= 0) {
            return false;
        }
        String extension = name.substring(lastDotPos);
        if (extension.length() == 1) {
            return false;
        }
        return !this.excludedExtensions.contains(extension);
    }
}

