/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.videotools;

import com.myapp.videotools.DefaultVideoFileFilter;
import com.myapp.videotools.IImageMerger;
import com.myapp.videotools.IPathCalculator;
import com.myapp.videotools.IVideoFileParser;
import com.myapp.videotools.IVideoThumbnailer;
import com.myapp.videotools.VideoFile;
import com.myapp.videotools.commandline.RangeSelection;
import com.myapp.videotools.impl.Application;
import com.myapp.videotools.impl.NextToSourceFile;
import com.myapp.videotools.misc.AppStatistics;
import com.myapp.videotools.misc.Util;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVideoThumbnailer
implements IVideoThumbnailer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractVideoThumbnailer.class);
    private static final String TMP_DIR = System.getProperty("java.io.tmpdir");
    private static final Util.DirsFirstAlphabeticFileComparator FILE_CMP = new Util.DirsFirstAlphabeticFileComparator();
    private FileFilter videoFileFilter = new DefaultVideoFileFilter();
    @VisibleForTesting
    protected IVideoFileParser videoFileParser = Application.getInstance().createVideoFileParser();
    private IPathCalculator targetPathGenerator = new NextToSourceFile();
    protected IImageMerger merger = Application.getInstance().createImageMerger();
    protected AppStatistics statistics = AppStatistics.getInstance();
    private int preferredWidth = 410;
    private int preferredHeight = 330;
    private int bigPictureRows = 3;
    private int bigPictureCols = 5;
    protected VideoFile videoFile;
    private File videoRootDir = null;
    private boolean animated = false;
    private IVideoThumbnailer.OverwritePolicy overwritePolicy = IVideoThumbnailer.OverwritePolicy.SKIP;
    private RangeSelection rangeSelection;

    protected AbstractVideoThumbnailer() {
    }

    @Override
    public void createBigPictureRecursively() {
        this.createBigPictureRecursively0(this.getVideoRootDir());
    }

    private void createBigPictureRecursively0(File file) {
        if (file.isDirectory()) {
            this.createBigPictureRecursivelyForDirectory(file);
        } else if (file.isFile()) {
            this.createBigPictureRecursivelyForFile(file);
        } else {
            throw new RuntimeException("File is neither a file nor a directory: " + file);
        }
    }

    private void createBigPictureRecursivelyForDirectory(File directory) {
        LOG.info("  Entering directory:                     {}", (Object)directory);
        Object[] children = directory.listFiles();
        Assertions.assertThat((Object[])children).isNotNull();
        Arrays.sort(children, FILE_CMP);
        Arrays.stream(children).forEach(this::createBigPictureRecursively0);
        LOG.info("  Exiting directory:                      {}", (Object)directory);
        if (!directory.equals(this.videoRootDir)) {
            LOG.info("  Now in directory:                       {}", (Object)directory.getParent());
        }
    }

    private void createBigPictureRecursivelyForFile(File file) {
        File par;
        String path = file.getPath();
        StringBuilder bui = new StringBuilder();
        bui.append("    Creating big-picture for file:        ").append(path).append(" ... ");
        for (int i = path.length(); i < 60; ++i) {
            bui.append(' ');
        }
        if (!this.videoFileFilter.accept(file)) {
            LOG.info(bui.append("        SKIP. (filtered)").toString());
            this.statistics.incrementSkippedBecauseFiltered();
            return;
        }
        VideoFile v = new VideoFile(file);
        this.setVideoFile(v);
        File vid = this.videoFile.getFile();
        File bigPicFile = new File(this.targetPathGenerator.getTargetPath(vid));
        if (bigPicFile.exists()) {
            IVideoThumbnailer.OverwritePolicy policy = this.getOverwritePolicy();
            switch (policy) {
                case SKIP: {
                    LOG.info(bui.append("        SKIP. (already has big pic)").toString());
                    this.statistics.incrementSkippedBecauseExistingTarget();
                    return;
                }
                case OVERWRITE: {
                    if (bigPicFile.isFile() && bigPicFile.canWrite()) {
                        bui.append("        OVERWRITING existing file!");
                        break;
                    }
                    LOG.warn(bui.append("        SKIP. (file not writeable)").toString());
                    this.statistics.incrementSkippedBecauseExistingTarget();
                    return;
                }
            }
        }
        ((AbstractBooleanAssert)Assertions.assertThat(((par = bigPicFile.getParentFile()).isDirectory() || par.mkdirs() ? 1 : 0) != 0).as("not a directory " + par, new Object[0])).isTrue();
        LOG.info(bui.toString());
        boolean yetParsed = this.parseIfNotYetParsed();
        if (!yetParsed) {
            return;
        }
        try {
            boolean ok = this.animated ? this.createAnimatedBigPicture(bigPicFile, 10) : this.createBigPicture(bigPicFile);
            if (!ok) {
                LOG.error("    FAIL, unable to create big-pic for: {}", (Object)file.getName());
                return;
            }
        }
        catch (Exception e) {
            LOG.error("      Could not create big-picture for: {}", (Object)file.getName());
            LOG.trace("      Stacktrace:", (Throwable)e);
            LOG.error("    FAIL, an error ({}) occured while create big-pic for: {}", (Object)e, (Object)file.getName());
            return;
        }
        LOG.info("    OK, created big-picture for:          {}", (Object)file.getName());
    }

    protected boolean parseIfNotYetParsed() {
        if (this.videoFile.isParsed()) {
            return true;
        }
        try {
            this.videoFile.parse(this.videoFileParser);
            return this.videoFile.isParsed();
        }
        catch (Exception e) {
            File file = this.videoFile.getFile();
            LOG.error("      Could not determine video-metadata for: {}", (Object)file.getName());
            LOG.trace("      Stacktrace:", (Throwable)e);
            LOG.error("    FAIL, an error ({}) occured while parsing {}", (Object)e, (Object)file.getName());
            return false;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(" [file=");
        if (this.videoFile != null && this.videoFile.getFile() != null) {
            builder.append(this.videoFile.getFile().getName());
        } else {
            builder.append("<NULL>");
        }
        builder.append(", bigPic r*c=");
        builder.append(this.bigPictureRows);
        builder.append("*");
        builder.append(this.bigPictureCols);
        builder.append(", thumbs: h*w=");
        builder.append(this.preferredHeight);
        builder.append("*");
        builder.append(this.preferredWidth);
        if (this.videoRootDir != null) {
            builder.append(", videoRootDir=");
            builder.append(this.videoRootDir.getName());
        }
        builder.append("]");
        return builder.toString();
    }

    public File calculateThumbnailTempDir() {
        return new File(TMP_DIR, "thumbnails-tempdir-" + this.videoFile.getFile().getName());
    }

    public void createOrWipeTempThumbnailDir(File targetDir) {
        if (!targetDir.exists()) {
            Assertions.assertThat((boolean)targetDir.mkdirs()).isTrue();
        } else {
            Object[] subfiles = targetDir.listFiles();
            Assertions.assertThat((Object[])subfiles).isNotNull();
            if (subfiles.length > 0) {
                LOG.warn("          TARGETDIR NOT EMPTY! sweeping {} files from: {}", (Object)subfiles.length, (Object)targetDir);
                Arrays.stream(subfiles).forEach(f -> {
                    FileUtils.deleteQuietly((File)f);
                    ((AbstractBooleanAssert)Assertions.assertThat((boolean)f.exists()).as("Could not delete " + f, new Object[0])).isFalse();
                });
            }
        }
    }

    @Override
    public VideoFile getVideoFile() {
        return this.videoFile;
    }

    @Override
    public File getVideoRootDir() {
        return this.videoRootDir;
    }

    @Override
    public void setVideoRootDir(File dir) {
        this.videoRootDir = dir;
    }

    @Override
    public void setVideoFile(VideoFile vf) {
        this.videoFile = vf;
    }

    @Override
    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    @Override
    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    @Override
    public void setPreferredWidth(int w) {
        LOG.debug("  picture width: '{}'", (Object)w);
        this.preferredWidth = w;
    }

    @Override
    public void setPreferredHeight(int h) {
        LOG.debug("  picture height: '{}'", (Object)h);
        this.preferredHeight = h;
    }

    @Override
    public void setPathCalculator(IPathCalculator pc) {
        LOG.debug("  big-picture path algorithm: '{}'", pc.getClass());
        this.targetPathGenerator = pc;
    }

    @Override
    public IPathCalculator getPathCalculator() {
        return this.targetPathGenerator;
    }

    @Override
    public int getBigPictureCols() {
        return this.bigPictureCols;
    }

    @Override
    public int getBigPictureRows() {
        return this.bigPictureRows;
    }

    @Override
    public void setBigPictureCols(int c) {
        LOG.debug("  big-picture columns: '{}'", (Object)c);
        this.bigPictureCols = c;
    }

    @Override
    public void setBigPictureRows(int r) {
        LOG.debug("  big-picture rows: '{}'", (Object)r);
        this.bigPictureRows = r;
    }

    @Override
    public FileFilter getFileFilter() {
        return this.videoFileFilter;
    }

    @Override
    public void setFileFilter(FileFilter e) {
        this.videoFileFilter = e;
    }

    @Override
    public void setOverwritePolicy(IVideoThumbnailer.OverwritePolicy overwritePolicy) {
        this.overwritePolicy = overwritePolicy;
    }

    @Override
    public IVideoThumbnailer.OverwritePolicy getOverwritePolicy() {
        return this.overwritePolicy;
    }

    @Override
    public boolean isAnimated() {
        return this.animated;
    }

    @Override
    public void setAnimated(boolean animated) {
        this.animated = animated;
    }

    @Override
    public void setRangeSelection(RangeSelection rangeSelection) {
        this.rangeSelection = rangeSelection;
    }

    public static long calculateOffsetMillis(RangeSelection selection, VideoFile file, int sliceIndex, int sliceCount) {
        Assertions.assertThat((int)sliceIndex).isGreaterThanOrEqualTo(0);
        Assertions.assertThat((int)sliceCount).isGreaterThan(0);
        RangeSelection rs = selection != null ? selection : RangeSelection.COMPLETELY;
        RangeSelection.Coords coords = rs.calculate(file);
        long selectionLength = coords.getLengthMillis();
        Assertions.assertThat((long)selectionLength).isGreaterThan(0L);
        long offsetWithinSelection = Math.round((double)selectionLength / (double)sliceCount * (double)sliceIndex);
        long selectionOffset = coords.getOffsetMillis();
        return selectionOffset + offsetWithinSelection;
    }

    public long calculateOffsetMillis(int sliceIndex, int numberOfSlices) {
        return AbstractVideoThumbnailer.calculateOffsetMillis(this.rangeSelection, this.videoFile, sliceIndex, numberOfSlices);
    }

    public RangeSelection getRangeSelection() {
        return this.rangeSelection;
    }

    @VisibleForTesting
    public Process __startProcess(ProcessBuilder pb) throws IOException {
        return pb.start();
    }

    @VisibleForTesting
    public int __waitForProcess(Process p, List<String> command) throws InterruptedException {
        return p.waitFor();
    }

    @VisibleForTesting
    public void __awaitTermination(ExecutorService service, long maxWaitMillis, String description) throws InterruptedException {
        service.shutdown();
        service.awaitTermination(maxWaitMillis, TimeUnit.MILLISECONDS);
        Assertions.assertThat((boolean)service.isTerminated()).isTrue();
    }
}

