/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.videotools;

import com.myapp.videotools.IVideoFileParser;
import com.myapp.videotools.VideoFile;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.assertj.core.util.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVideoFileParser
implements IVideoFileParser {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private File file = null;
    private VideoFile videoFile = null;

    protected AbstractVideoFileParser() {
    }

    @Override
    public synchronized void parse() throws IOException {
        this.check(this.videoFile);
        String videoFilePath = this.file.getPath();
        this.log.debug("      parsing metadata for: '{}' ...", (Object)videoFilePath);
        List<String> ffmpegOutputLines = this.readFfmpegOutput();
        this.initMetaDataFromLines(ffmpegOutputLines);
        this.log.debug("      OK, metadata for: '{}' parsed.", (Object)this.file.getName());
    }

    @Override
    public void setVideoFile(VideoFile vidfile) {
        this.check(vidfile);
        this.videoFile = vidfile;
        this.file = this.videoFile.getFile();
    }

    private void check(VideoFile vidfile) {
        if (vidfile == null) {
            throw new NullPointerException();
        }
        if (vidfile.getFile() == null || !vidfile.getFile().isFile()) {
            throw new RuntimeException("cannot live without an existing file: " + vidfile);
        }
    }

    protected abstract List<String> readVideoMetaData(File var1) throws IOException;

    protected abstract boolean isLineOfInterest(String var1);

    protected abstract long parseDurationMillis(String var1);

    protected abstract long parseVideoStartOffsetMillis(String var1);

    protected abstract int parseTotalBytesPerSecond(String var1);

    protected abstract String parseVideoCodec(String var1);

    protected abstract String parseVideoFormat(String var1);

    protected abstract int parseVideoHeight(String var1);

    protected abstract int parseVideoWidth(String var1);

    protected abstract int parseVideoBytesPerSecond(String var1);

    protected abstract double parseVideoFrameRate(String var1);

    protected abstract String parseAudioCodec(String var1);

    protected abstract int parseAudioSampleRate(String var1);

    protected abstract String parseAudioChannels(String var1);

    protected abstract int parseAudioBytesPerSecond(String var1);

    private List<String> readFfmpegOutput() throws IOException {
        this.log.trace("        will now read std-out from ffmpeg-process...");
        List<String> outputLines = this.readVideoMetaData(this.file);
        this.log.trace("        OK, std-out from process read.");
        return outputLines;
    }

    @VisibleForTesting
    protected void initMetaDataFromLines(List<String> lines) {
        this.log.debug("        will now parse collected output from ffmpeg...");
        lines.stream().filter(this::isLineOfInterest).forEach(line -> {
            this.gatherGeneralMetaData((String)line);
            this.gatherVideoMetaData((String)line);
            this.gatherAudioMetaData((String)line);
        });
        this.log.debug("        OK, collected output parsed. ({} lines)", (Object)lines.size());
    }

    private void gatherGeneralMetaData(String line) {
        long durationMillis = this.parseDurationMillis(line);
        long offsetMillis = this.parseVideoStartOffsetMillis(line);
        int totalBytesPerSecond = this.parseTotalBytesPerSecond(line);
        if (durationMillis >= 0L && this.videoFile.getLengthMillis() < 0L) {
            this.videoFile.setLengthMillis(durationMillis);
            this.log.debug("          duration       = {} ms", (Object)durationMillis);
        }
        if (offsetMillis >= 0L && this.videoFile.getVideoStartOffsetMillis() == 0L) {
            this.videoFile.setVideoStartOffsetMillis(offsetMillis);
            this.log.trace("          offsetMillis   = {} ms", (Object)offsetMillis);
        }
        if (totalBytesPerSecond >= 0 && this.videoFile.getTotalBytesPerSecond() < 0) {
            this.videoFile.setTotalBytesPerSecond(totalBytesPerSecond);
            this.log.trace("          totalBitrate   = {} b/s", (Object)offsetMillis);
        }
    }

    private void gatherVideoMetaData(String line) {
        String videoCodec = this.parseVideoCodec(line);
        String videoFormat = this.parseVideoFormat(line);
        int videoHeight = this.parseVideoHeight(line);
        int videoWidth = this.parseVideoWidth(line);
        int videoBytesPerSecond = this.parseVideoBytesPerSecond(line);
        double videoFrameRate = this.parseVideoFrameRate(line);
        if (videoCodec != null && this.videoFile.getVideoCodec() == null) {
            this.videoFile.setVideoCodec(videoCodec);
            this.log.trace("          vidCodec       = {} ", (Object)videoCodec);
        }
        if (videoFormat != null && this.videoFile.getVideoFormat() == null) {
            this.videoFile.setVideoFormat(videoFormat);
            this.log.trace("          vidFormat      = {} ", (Object)videoFormat);
        }
        if (videoHeight >= 0 && this.videoFile.getVideoHeight() < 0) {
            this.videoFile.setVideoHeight(videoHeight);
            this.log.debug("          vidHeight      = {} pixel", (Object)videoHeight);
        }
        if (videoWidth >= 0 && this.videoFile.getVideoWidth() < 0) {
            this.videoFile.setVideoWidth(videoWidth);
            this.log.debug("          vidWidth       = {} pixel", (Object)videoWidth);
        }
        if (videoBytesPerSecond >= 0 && this.videoFile.getVideoBytesPerSecond() < 0) {
            this.videoFile.setVideoBytesPerSecond(videoBytesPerSecond);
            this.log.trace("          vidBytesPerSec = {} b/s", (Object)videoBytesPerSecond);
        }
        if (videoFrameRate >= 0.0 && this.videoFile.getVideoFramesPerSecond() < 0.0) {
            this.videoFile.setVideoFramesPerSecond(videoFrameRate);
            this.log.trace("          vidFrameRate   = {} fps", (Object)videoFrameRate);
        }
    }

    private void gatherAudioMetaData(String line) {
        String audioCodec = this.parseAudioCodec(line);
        int audioSampleRate = this.parseAudioSampleRate(line);
        String audioChannels = this.parseAudioChannels(line);
        int audioBytesPerSecond = this.parseAudioBytesPerSecond(line);
        if (audioCodec != null && this.videoFile.getAudioCodec() == null) {
            this.videoFile.setAudioCodec(audioCodec);
            this.log.trace("          audioCodec     = {}", (Object)audioCodec);
        }
        if (audioSampleRate >= 0 && this.videoFile.getAudioSampleRate() < 0) {
            this.videoFile.setAudioSampleRate(audioSampleRate);
            this.log.trace("          audioSampleRate= {} Hz", (Object)audioSampleRate);
        }
        if (audioChannels != null && this.videoFile.getAudioChannelType() == null) {
            this.videoFile.setAudioChannelType(audioChannels);
            this.log.trace("          audioChannels  = {}", (Object)audioChannels);
        }
        if (audioBytesPerSecond >= 0 && this.videoFile.getAudioBytesPerSecond() < 0) {
            this.videoFile.setAudioBytesPerSecond(audioBytesPerSecond);
            this.log.trace("          audioBitrate   = {} b/s", (Object)audioBytesPerSecond);
        }
    }
}

