/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.videotools;

import com.myapp.videotools.IPathCalculator;
import com.myapp.videotools.misc.Util;
import java.io.File;

public abstract class AbstractPathCalculator
implements IPathCalculator {
    private String prefix = "";
    private String suffix = ".jpeg";

    @Override
    public final String getTargetPath(File sourceFile) {
        this.validateSource(sourceFile);
        String target = this.getTargetFileImpl(sourceFile);
        if (target == null) {
            throw new RuntimeException("target is null! source: " + sourceFile);
        }
        File targetFile = new File(target);
        if (targetFile.exists() && sourceFile.exists() && Util.isSameFile(sourceFile, targetFile)) {
            throw new RuntimeException("source and target is the same file! source: " + sourceFile + ", target: " + target);
        }
        return target;
    }

    private void validateSource(File source) {
        if (source == null) {
            throw new NullPointerException("source is null!");
        }
        if (source.isDirectory()) {
            throw new IllegalStateException("sourceFile is a directory: " + source);
        }
        if (!source.exists() || !source.canRead()) {
            throw new IllegalStateException("sourceFile is not a readable file: " + source);
        }
        this.validateSourceImpl(source);
    }

    protected abstract String getTargetFileImpl(File var1);

    protected void validateSourceImpl(File source) {
    }

    @Override
    public final String getPrefix() {
        return this.prefix;
    }

    @Override
    public final void setPrefix(String fileNamePrefix) {
        this.prefix = fileNamePrefix;
    }

    @Override
    public final String getSuffix() {
        return this.suffix;
    }

    @Override
    public final void setSuffix(String suffix) {
        this.suffix = suffix;
    }
}

