package com.myapp.videotools.misc;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StatisticsShutDownHook extends Thread {

    private static final String NL = System.getProperty("line.separator");
    private static final Logger log = LoggerFactory.getLogger(StatisticsShutDownHook.class);

    public void run() {
        currentThread().setName("summary");
        AppStatistics s = AppStatistics.getInstance();
        s.setApplicationExit();
        log.info(NL + s.toString());
    }
}