package com.myapp.videotools.misc;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.DateTimeException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

import static java.lang.Integer.parseInt;
import static java.util.logging.Logger.getLogger;
import static java.util.regex.Pattern.CASE_INSENSITIVE;

public class SeleniumHolder /*implements AutoCloseable */{

    private static final Pattern DURATION_REGEX = Pattern.compile("0?([0-9]+):0?([0-9]+)\\s*(Std|Min)", CASE_INSENSITIVE);
    private static boolean mutedLoggers = false;


    @SuppressWarnings("unused")
    public void tryImdbLookup(List<Broadcast> broadcasts) {
        broadcasts.forEach(bc -> {
            HtmlUnitDriver driver = new HtmlUnitDriver();

            String title = bc.getTitle();
            String url = "https://www.google.com/search?q=";
            try {
                url += URLEncoder.encode(title, "UTF-8");
            } catch (UnsupportedEncodingException e) {
                throw new RuntimeException(title, e);
            }
            url += "+site%3Aimdb.com";
            driver.get(url);

            // TODO
        });
    }

    public List<Broadcast> fetchAllBroadcasts() {
        if (!mutedLoggers) {
            LogFactory.getFactory().setAttribute("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
            getLogger("com.gargoylesoftware.htmlunit").setLevel(java.util.logging.Level.OFF);
            getLogger("org.apache.commons.httpclient").setLevel(java.util.logging.Level.OFF);
            getLogger("com.gargoylesoftware").setLevel(java.util.logging.Level.OFF);
            mutedLoggers = true;
        }

        HtmlUnitDriver driver = new HtmlUnitDriver();
        List<Broadcast> allBroadcasts;

        try {
            driver.get("https://tvthek.orf.at/profiles");

            allBroadcasts = driver.findElements(By.cssSelector("ul.results-list li article.b-teaser"))
                    .stream()
                    .map(SeleniumHolder::parseBroadcast)
                    .collect(Collectors.toList());

        } finally {
            try {
                driver.close();
            } catch (Exception ignored) {
            }
        }

        return allBroadcasts;
    }


    private static Broadcast parseBroadcast(WebElement article) {
        Broadcast broadcast = null;
        try {
            broadcast = parseBroadcastImpl(article);
        } catch (Exception e) {
            System.err.println("--------------------------------------------------");
            System.err.println("ERROR: " + e);
            System.err.println("--------------------------------------------------");
            System.err.println(article.getAttribute("innerHTML"));
            System.err.println("--------------------------------------------------");
        }
        return broadcast;
    }

    private static Broadcast parseBroadcastImpl(WebElement article) {
        List<WebElement> durationElements = article.findElements(By.cssSelector("span.hover-duration"));
        if (durationElements.isEmpty()) {
            durationElements = article.findElements(By.cssSelector("p.visible-duration"));
        }
        if (durationElements.isEmpty()) {
            throw new RuntimeException("cannot find duration");
        }

        WebElement duration = durationElements.get(0);
        WebElement image = article.findElement(By.cssSelector("figure.teaser-img img"));
        WebElement tvChannel = article.findElement(By.cssSelector("div.text-container p.channel"));
        WebElement airDate = article.findElement(By.cssSelector("div.text-container time.datetime"));
        WebElement description = article.findElement(By.cssSelector("div.text-container p.description"));
        WebElement availability = article.findElement(By.cssSelector("div.text-container p.availability"));
        WebElement streamUrl = article.findElement(By.cssSelector("a.teaser-link"));

        Broadcast bc = new Broadcast();
        String datetime = StringUtils.trimToEmpty(airDate.getAttribute("datetime"));
        try {
            bc.setAirDate(ZonedDateTime.parse(datetime,
                    DateTimeFormatter.ofPattern("yyyy-MM-ddzHH:mm:ss")));
        } catch (DateTimeException e) {
            System.out.println(datetime + " --> " + e);

        }
        bc.setTitle(StringUtils.trimToEmpty(streamUrl.getAttribute("title")));
        bc.setStreamUrl(StringUtils.trimToEmpty(streamUrl.getAttribute("href")));
        bc.setDescription(StringUtils.trimToEmpty(description.getText()));
        bc.setImageUrl(StringUtils.trimToEmpty(image.getAttribute("src")));

        String durationText = StringUtils.trimToEmpty(duration.getAttribute("textContent")); // '01:33 Std.' or '23:02 Min.'
        bc.setDuration(durationText);
        bc.setDurationSeconds(parseDuration(durationText));

        bc.setTvChannel(StringUtils.trimToEmpty(tvChannel.getAttribute("textContent")));
        bc.setAvailability(StringUtils.trimToEmpty(availability.getAttribute("textContent")));

        return bc;
    }

    private static int parseDuration(String durationText) {
        Matcher m = DURATION_REGEX.matcher(durationText);
        int seconds = -1;
        if (m.find()) {
            int num1 = parseInt(m.group(1));
            int num2 = parseInt(m.group(2));
            String group3 = m.group(3).toLowerCase();
            switch (group3) {
                case "std":
                    seconds = num1 * 3600 + num2 * 60;
                    break;
                case "min":
                    seconds = num1 * 60 + num2;
                    break;
            }
        }
        return seconds;
    }
//
//    @Override
//    public void close() {
//        if (driver != null) {
//            driver.close();
//        }
//    }
}
