package com.myapp.videotools.misc;

import java.util.regex.Matcher;

@SuppressWarnings("WeakerAccess")
public class RegexHelper {

    public static final int NO_MATCH_INT = -444;
    public static final long NO_MATCH_LONG = NO_MATCH_INT;
    public static double NO_MATCH_DOUBLE = NO_MATCH_INT;
    public static final String NO_MATCH_STRING = "<<<<<<< "+NO_MATCH_INT+" <<<<<<< NO_MATCH_INDICATOR 0d47dedcf9a470f5a61d23f5c2d59a14ce16fa220b34974b62465e88d906cd0b6b28284c3695d70940e743de0ef492e2afe0cea2712570b3e737c34230088c11 >>>>>>>";

    public static final int AMBIGUOUS_MATCH_INT = -555;
    public static long AMBIGUOUS_MATCH_LONG = AMBIGUOUS_MATCH_INT;
    public static double AMBIGUOUS_MATCH_DOUBLE = AMBIGUOUS_MATCH_INT;
    public static final String AMBIGUOUS_MATCH_STRING = "<<<<<<< "+AMBIGUOUS_MATCH_INT+" <<<<<<< AMBIGUOUS_MATCH_INDICATOR 5baf20de66c74cfd1a789744a459324516e343c2e955547490f968ef87811c0b97d8a53a6086b28da2e5fd1b06fd8a5375fd6ca0df537435dc5e1a09dcffa5f5 >>>>>>>";

    public static final int NOT_A_NUMBER_INT = -333;
    public static double NOT_A_NUMBER_DOUBLE = NOT_A_NUMBER_INT;
    public static final long NOT_A_NUMBER_LONG = NOT_A_NUMBER_INT;


    private RegexHelper() {
        // utility class
    }


    public static int getFirstGroupAsInt(Matcher m) {
        return getFirstGroupAsInt(m, null);
    }

    public static String getFirstGroupAsString(Matcher m) {
        String group = getFirstGroupInternal(m);

        switch (group) {
            case NO_MATCH_STRING:
            case AMBIGUOUS_MATCH_STRING:
                return null;
            default:
                return group;
        }
    }

    public static String getFirstGroupInternal(Matcher m) {
        String result = NO_MATCH_STRING;

        if (m.find()) {
            String group = m.group(1);

            if (m.find()) {
                result = AMBIGUOUS_MATCH_STRING;
            } else {
                result = group;
            }
        }

        return result;
    }

    public static int getFirstGroupAsInt(Matcher m, Integer optionalFactor) {
        int result;
        String group = getFirstGroupInternal(m);

        switch (group) {
            case NO_MATCH_STRING: {
                result = NO_MATCH_INT;
                break;
            }
            case AMBIGUOUS_MATCH_STRING: {
                result = AMBIGUOUS_MATCH_INT;
                break;
            }
            default: {
                try {
                    result = Integer.parseInt(group);

                    if (optionalFactor != null) {
                        result = result * optionalFactor;
                    }

                } catch (NumberFormatException e) {
                    result = NOT_A_NUMBER_INT;
                }
                break;
            }
        }

        return result;
    }

    public static double getFirstGroupAsDouble(Matcher m) {
        double result;
        String group = getFirstGroupInternal(m);

        switch (group) {
            case NO_MATCH_STRING: {
                result = NO_MATCH_DOUBLE;
                break;
            }
            case AMBIGUOUS_MATCH_STRING: {
                result = AMBIGUOUS_MATCH_DOUBLE;
                break;
            }
            default: {
                try {
                    double tempresult = Double.parseDouble(group);
                    if (tempresult == Double.POSITIVE_INFINITY || tempresult == Double.NEGATIVE_INFINITY) {
                        result = NOT_A_NUMBER_DOUBLE;
                    } else {
                        result = tempresult;
                    }

                } catch (NumberFormatException e) {
                    result = NOT_A_NUMBER_DOUBLE;
                }
                break;
            }
        }

        return result;
    }

    public static long getFirstGroupAsLong(Matcher m) {
        long result;
        String group = getFirstGroupInternal(m);

        switch (group) {
            case NO_MATCH_STRING: {
                result = NO_MATCH_LONG;
                break;
            }
            case AMBIGUOUS_MATCH_STRING: {
                result = AMBIGUOUS_MATCH_LONG;
                break;
            }
            default: {
                try {
                    Double resultDouble = Double.valueOf(group);
                    long tempresult = resultDouble.longValue();
                    if (tempresult != Long.MAX_VALUE && tempresult != Long.MIN_VALUE) {
                        result = tempresult;
                    } else {
                        result = NOT_A_NUMBER_LONG;
                    }

                } catch (NumberFormatException e) {
                    result = NOT_A_NUMBER_LONG;
                }
                break;
            }
        }

        return result;
    }
}
