package com.myapp.videotools.misc;

import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.VisibleForTesting;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public final class Configuration {

    private static Configuration instance = null;
    public static final String propertiesFileName = "videotool.properties";
    private Properties p;
    
    public static Configuration getInstance() {
        if (instance == null) {
            synchronized (Configuration.class) {
                if (instance == null)
                    instance = new Configuration();
            }
        }

        return instance;
    }
    
    private Configuration() {
        this(loadProps());
    }

    private static InputStream loadProps() {
        ClassLoader scl = ClassLoader.getSystemClassLoader();
        URL url = scl.getResource(propertiesFileName);

        if (url == null) {
            url = Configuration.class.getResource(propertiesFileName);
            if (url == null) {
                String msg = "cannot load " + propertiesFileName + " from classpath!";
                if (StringUtils.containsIgnoreCase(System.getProperty("user.dir"), "workspace")) {
                    msg += " Maybe forgot to run the maven build?";
                }
                throw new RuntimeException(msg);
            }
        }

        try {
            return url.openStream();
        } catch (IOException e) {
            throw new RuntimeException("cannot open " + url + "!");
        }
    }

    @VisibleForTesting
    Configuration(InputStream propertiesStream) {
        p = new Properties();

        try {
            p.load(propertiesStream);

        } catch (IOException e) {
            String msg = "error reading from propertiesStream: " + propertiesStream;
            String message = e.getMessage();
            if (StringUtils.isNotBlank(message)) {
                msg += " - " + message;
            }
            throw new RuntimeException(msg, e);
        } finally {
            if (propertiesStream != null) {
                try {
                    propertiesStream.close();
                } catch (IOException ignored) {
                }
            }
        }
    }

    public String getProperty(String key) {
        return p.getProperty(key);
    }
}
