package com.myapp.videotools.impl;

import com.myapp.videotools.AbstractPathCalculator;

import java.io.File;

/**
 * A path calculator that places the target file next to the source file
 */
public final class NextToSourceFile extends AbstractPathCalculator {

     @Override
     public String getTargetFileImpl(File source) {
         StringBuilder builder = new StringBuilder();
         builder.append(source.getParentFile().getPath());

         if (builder.charAt(builder.length() - 1) != File.separatorChar) {
             builder.append(File.separatorChar);
         }

         String fileNamePrefix = getPrefix();
         if (fileNamePrefix != null) {
             builder.append(fileNamePrefix);
         }

         builder.append(source.getName());

         String fileNameSuffix = getSuffix();
         if (fileNameSuffix != null) {
             builder.append(fileNameSuffix);
         }

         File target = new File(builder.toString());
         return target.getPath();
     }
}
