package com.myapp.videotools.commandline;

import com.myapp.videotools.misc.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine.Mixin;
import picocli.CommandLine.Option;
import picocli.custom.AssertionErrorWrappingException;
import picocli.custom.BaseCommand;
import picocli.custom.VerbosityOptions;

/**
 * Basic class for all video tool commands.
 */
public abstract class VideoToolsBaseCommand extends BaseCommand {

    static final String HELP = "--help";
    static final String HELP2 = "-?";
    static final String HELP3 = "-help";

    protected final Logger log = LoggerFactory.getLogger(getClass());

    @Mixin
    private VerbosityOptions verbosity = new VerbosityOptions();

    @Mixin
    InOut io = new InOut();

    @SuppressWarnings("unused") // managed by picocli via reflection
    @Option(names = {HELP, HELP2, HELP3},
            usageHelp = true,
            description = "Display this help and exit")
    private boolean help;

    @Override
    public final Void call() throws Exception {
        try {
            verbosity.applyLogConfig();

            if (log.isDebugEnabled()) {
                log.debug(Util.getOsInfoString());
            }

            executeImpl();

        } catch (AssertionError e) {
            throw new AssertionErrorWrappingException(e);
        }
        return null;
    }

    protected abstract void executeImpl();
}
