package com.myapp.videotools.commandline;

import com.myapp.videotools.IVideoThumbnailer;
import picocli.CommandLine.Command;
import picocli.CommandLine.Option;
import picocli.custom.CustomTypeConverters.ReadableFile;
import picocli.custom.CustomTypeConverters.WriteableFile;

import java.io.File;

import static picocli.CommandLine.Help.Visibility.ALWAYS;

/**
 * Specifies input and output files.
 */
@Command
class InOut {

    static final String OPT_INPUT_FILE = "--input-file";
    static final String OPT_OUTPUT_FILE = "--output-file";
    static final String OPT_OVERWRITE_EXISTING = "--overwrite-existing";

    @Option(names = {OPT_INPUT_FILE, "-i"},
            converter = ReadableFile.class,
            paramLabel = "FILE",
            description = "Path of the file where input is read from")
    File inFile;

    @Option(names = {OPT_OUTPUT_FILE, "-o"},
            converter = WriteableFile.class,
            paramLabel = "FILE",
            description = "Path of the file where output is written. " +
                    "If omitted, the image output is written next to the video input file, " +
                    "suffixed with '" + IVideoThumbnailer.DEFAULT_BIGPIC_FILENAME_SUFFIX + "'.")
    File outFile;

    @Option(names = {OPT_OVERWRITE_EXISTING, "-ow"},
            defaultValue = "false",
            showDefaultValue = ALWAYS,
            description = "Overwrite existing target files.")
    boolean overWriteExisting;
}
