package com.myapp.videotools.commandline;

import picocli.CommandLine.Command;
import picocli.CommandLine.Option;
import picocli.custom.CustomTypeConverters;

import static com.myapp.videotools.IVideoThumbnailer.DEFAULT_THUMB_HEIGHT;
import static com.myapp.videotools.IVideoThumbnailer.DEFAULT_THUMB_WIDTH;
import static picocli.CommandLine.Help.Visibility.ALWAYS;

/**
 * Specifies dimensions of a captured frame, aka thumbnail image.
 */
@Command
public class FrameDimensions {

    static final String OPT_WIDTH = "--width";
    static final String OPT_HEIGHT = "--height";

    @Option(names = {OPT_WIDTH, "-w"},
            converter = CustomTypeConverters.PositiveInteger.class,
            defaultValue = ""+DEFAULT_THUMB_WIDTH,
            showDefaultValue = ALWAYS,
            paramLabel = "INT",
            description = "Width of the thumbnails.")
    int thumbnailWidth;

    @Option(names = {OPT_HEIGHT, "-h"},
            converter = CustomTypeConverters.PositiveInteger.class,
            defaultValue = ""+DEFAULT_THUMB_HEIGHT,
            showDefaultValue = ALWAYS,
            paramLabel = "INT",
            description = "Height of the thumbnails")
    int thumbnailHeight;

    @Override
    public String toString() {
        return thumbnailWidth + "x" + thumbnailHeight;
    }
}
