package com.myapp.videotools.commandline;

import picocli.CommandLine.Command;
import picocli.CommandLine.Mixin;
import picocli.CommandLine.Option;

import static com.myapp.videotools.IVideoThumbnailer.DEFAULT_BIG_PIC_SCREENSHOT_COUNT;
import static com.myapp.videotools.commandline.CreateThumbsCommand.CMD_THUMBS;

/**
 * Creates set of snapshots of a video file
 */
@Command(name = CMD_THUMBS,
        aliases = {"--capture-thumb-series", "-thumbs"},
        description = "Create a series of thumbnail images of a videofile")
public class CreateThumbsCommand extends VideoToolsBaseCommand {

    static final String CMD_THUMBS = "thumbs";

    @SuppressWarnings("WeakerAccess")
    static final String OPT_THUMBS_COUNT = "--count";

    @Mixin
    private FrameDimensions dims = new FrameDimensions();

    @Option(names = {OPT_THUMBS_COUNT, "-n"},
            required = true,
            defaultValue = "" + DEFAULT_BIG_PIC_SCREENSHOT_COUNT,
            description = "Number of thumbnails to produce.")
    int count;

    @Override
    protected void executeImpl() {
        log.info("  creating {} thumbnails for video {} with {} size.",
                new Object[]{count, io.inFile, dims});
        throw new UnsupportedOperationException("not yet implemented"); // TODO
    }
}
