package com.myapp.videotools.commandline;

import picocli.CommandLine.Option;

import static com.myapp.videotools.commandline.CaptureFrameCommand.CMD_FRAME;
import static picocli.CommandLine.Command;
import static picocli.CommandLine.Mixin;


/**
 * Creates a snapshot image for a video file
 */
@Command(name = CMD_FRAME,
        aliases= {"--capture-frame", "-frame"},
        description = "Create a single frame snapshot image of a videofile")
public class CaptureFrameCommand extends VideoToolsBaseCommand {

    static final String CMD_FRAME = "frame";

    @SuppressWarnings("WeakerAccess")
    static final String OPT_FRAME_TIME = "--frame-time";

    @Mixin
    private FrameDimensions dims = new FrameDimensions();

    @Option(names = {OPT_FRAME_TIME, "-t"},
            required = true,
            description = "The time of the frame to be captured from the video in milliseconds")
    int captureTime;

    @Override
    protected void executeImpl() {
        log.info("  capturing single frame at {} millis for video {} with {} size.",
                new Object[]{captureTime, io.inFile, dims});
        throw new UnsupportedOperationException("not yet implemented"); // TODO
    }
}
