package com.myapp.videotools;

import com.myapp.videotools.commandline.RangeSelection;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.List;


public interface IVideoThumbnailer {

    enum OverwritePolicy {
        SKIP,
        OVERWRITE
    }

    int DEFAULT_THUMB_WIDTH = 410;
    int DEFAULT_THUMB_HEIGHT = 330;
    int DEFAULT_BIG_PIC_COLS = 5;
    int DEFAULT_BIG_PIC_ROWS = 3;
    int DEFAULT_BIG_PIC_SCREENSHOT_COUNT = DEFAULT_BIG_PIC_ROWS * DEFAULT_BIG_PIC_COLS;

    String DEFAULT_THUMB_FILE_NAME_PREFIX = "thumb_";
    String DEFAULT_BIGPIC_FILENAME_PREFIX = "";
    String DEFAULT_BIGPIC_FILENAME_SUFFIX = ".jpeg";
    String DEFAULT_BIGPIC_FILENAME_SUFFIX_ANIMATED = ".gif";




    // BIG-PICTURE RELATED



    boolean createBigPicture(File out) throws IOException;

    boolean createAnimatedBigPicture(File out, int nFrames) throws IOException;

    // recursive big-picturing


    void createBigPictureRecursively();

    default void createBigPictureRecursively(String folder) {
        setVideoRootDir(new File(folder));
        createBigPictureRecursively();
    }





    // THUMBNAIL SERIES GENERATION RELATED



    /**
     * takes a set of thumbnails of the current videofile and stores in the
     * given directory.
     *
     * @param count
     *            the desired number of thumbnails to create. the time between
     *            the snapshots will be calculated based on the length of the
     *            video and the count value.
     * @param targetDir
     *            the directory where the files will be created
     * @return the list of created thumbnails, in chronologic order, null if the
     *            creation of the thumbnailing process did not exit properly.
     * @throws IOException
     *             if the process fails
     */
    List<File> createThumbnailSeries(int count, File targetDir) throws IOException;



    // SINGLE SNAPSHOT CAPTURING RELATED



    /**
     * @param timeOffset
     *            seconds from start
     * @throws IOException
     *             if the process fails
     */
    void captureSingleImage(double timeOffset, int width, int height, File out) throws IOException;

    /**
     * @param timeOffset
     *            seconds from start
     * @throws IOException when the capturing did not succeed
     */
    default void captureImageOriginalSize(double timeOffset, File out) throws IOException {
        VideoFile videoFile = getVideoFile();
        captureSingleImage(timeOffset, videoFile.getVideoHeight(), videoFile.getVideoWidth(), out);
    }

    /**
     * @param timeOffset
     *            seconds from start
     * @throws IOException when the capturing did not succeed
     */
    default void captureImage(double timeOffset, File out) throws IOException {
        int height = getPreferredHeight();
        int width = getPreferredWidth();
        captureSingleImage(timeOffset, width, height, out);
    }

    /**
     * tells the thumbnailer in which range of the videos we want to create thumbnails
     * @param rangeSelection the range selection
     */
    void setRangeSelection(RangeSelection rangeSelection);

    void setOverwritePolicy(OverwritePolicy overwritePolicy);
    OverwritePolicy getOverwritePolicy();

    VideoFile getVideoFile();
    void setVideoFile(VideoFile vf);

    File getVideoRootDir();
    void setVideoRootDir(File dir);

    void setPreferredWidth(int w);
    int getPreferredWidth();

    int getPreferredHeight();
    void setPreferredHeight(int h);

    void setPathCalculator(IPathCalculator pc);
    IPathCalculator getPathCalculator();

    int getBigPictureCols();
    void setBigPictureCols(int c);

    int getBigPictureRows();
    void setBigPictureRows(int r);

    FileFilter getFileFilter();
    void setFileFilter(FileFilter e);

    boolean isAnimated();
    void setAnimated(boolean animated);
}
