package com.myapp.videotools;

import java.io.File;


public interface IPathCalculator {

    String getTargetPath(File source);

    default File getTargetFile(File source) {
        String targetPath = getTargetPath(source);
        return targetPath == null ? null : new File(targetPath);
    }

    default File getTargetFile(String sourcePath) {
        if (sourcePath == null) {
            throw new NullPointerException("source is null!");
        }
        return getTargetFile(new File(sourcePath));
    }

    default String getTargetPath(String sourcePath) {
        if (sourcePath == null) {
            throw new NullPointerException("source is null!");
        }
        return getTargetPath(new File(sourcePath));
    }

    String getPrefix();
    String getSuffix();
    
    void setPrefix(String fileNamePrefix);
    void setSuffix(String fileNameSuffix);
    
}
