package com.myapp.videotools;

import com.myapp.videotools.misc.Util;

import java.io.File;

import static com.myapp.videotools.IVideoThumbnailer.DEFAULT_BIGPIC_FILENAME_SUFFIX;

/**
 * base class for pathCalculator implementations.
 * takes care of holding the prefix and the suffix.
 */
public abstract class AbstractPathCalculator implements IPathCalculator {

    private String prefix = "";
    private String suffix = DEFAULT_BIGPIC_FILENAME_SUFFIX;


    @Override
    public final String getTargetPath(File sourceFile) {
        validateSource(sourceFile);

        String target = getTargetFileImpl(sourceFile);
        if (target == null) {
            throw new RuntimeException("target is null! source: " + sourceFile);
        }

        File targetFile = new File(target);
        if (targetFile.exists() && sourceFile.exists()) {
            if (Util.isSameFile(sourceFile, targetFile)) {
                throw new RuntimeException("source and target is the same file! " +
                        "source: " + sourceFile + ", target: " + target);
            }
        }

        return target;
    }

    private void validateSource(File source) {
        if (source == null) {
            throw new NullPointerException("source is null!");
        }

        if (source.isDirectory()) {
            throw new IllegalStateException("sourceFile is a directory: " + source);
        }

        if (! source.exists() || ! source.canRead()) {
            throw new IllegalStateException("sourceFile is not a readable file: " + source);
        }

        validateSourceImpl(source);
    }


    protected abstract String getTargetFileImpl(File source);

    protected void validateSourceImpl(File source) {}

    @Override
    public final String getPrefix() {
        return prefix;
    }

    @Override
    public final void setPrefix(String fileNamePrefix) {
        this.prefix = fileNamePrefix;
    }

    @Override
    public final String getSuffix() {
        return suffix;
    }

    @Override
    public final void setSuffix(String suffix) {
        this.suffix = suffix;
    }
}
