/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.kodi.impl.kodi_MyVideos99;

import com.myapp.kodi.common.domain.Movie;
import com.myapp.kodi.common.domain.Tag;
import com.myapp.kodi.common.domain.TvShow;
import com.myapp.kodi.common.service.DomainObjectMapper;
import com.myapp.kodi.common.service.KodiService;
import com.myapp.kodi.common.util.IFileWrapper;
import com.myapp.kodi.impl.kodi_MyVideos99.entities.MovieEntity;
import com.myapp.kodi.impl.kodi_MyVideos99.entities.PathEntity;
import com.myapp.kodi.impl.kodi_MyVideos99.entities.TagEntity;
import com.myapp.kodi.impl.kodi_MyVideos99.entities.TagLinkEntity;
import com.myapp.kodi.impl.kodi_MyVideos99.entities.TvShowEntity;
import com.myapp.kodi.impl.kodi_MyVideos99.repo.MovieRepository;
import com.myapp.kodi.impl.kodi_MyVideos99.repo.TagLinkRepository;
import com.myapp.kodi.impl.kodi_MyVideos99.repo.TagRepository;
import com.myapp.kodi.impl.kodi_MyVideos99.repo.TvShowRepository;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Transactional
public class KodiServiceImpl
implements KodiService {
    @PersistenceContext
    private EntityManager em;
    private final MovieRepository movieRepository;
    private final TagRepository tagRepository;
    private final TvShowRepository tvShowRepository;
    private final TagLinkRepository tagLinkRepository;
    @Autowired
    private DomainObjectMapper mapper;

    @Autowired
    public KodiServiceImpl(MovieRepository movieRepo, TagRepository tagRepo, TvShowRepository tvShowRepo, TagLinkRepository tagLinkRepo, EntityManager em) {
        this.movieRepository = movieRepo;
        this.tagRepository = tagRepo;
        this.tvShowRepository = tvShowRepo;
        this.tagLinkRepository = tagLinkRepo;
        this.em = em;
    }

    @Override
    public TvShow findByTvShowName(String name) {
        TvShowEntity hits = this.tvShowRepository.findByTvShowName(name);
        return this.mapper.convert(hits);
    }

    @Override
    public List<Movie> loadAllMovies() {
        Iterable<MovieEntity> all = this.movieRepository.findAll();
        return StreamSupport.stream(all.spliterator(), false).map(this.mapper::convert).collect(Collectors.toList());
    }

    @Override
    public List<TvShow> loadAllTvShows() {
        Iterable<TvShowEntity> all = this.tvShowRepository.findAll();
        return StreamSupport.stream(all.spliterator(), false).map(this.mapper::convert).collect(Collectors.toList());
    }

    @Override
    public List<Tag> loadAllTags() {
        return StreamSupport.stream(this.tagRepository.findAll().spliterator(), false).map(this.mapper::convert).collect(Collectors.toList());
    }

    @Override
    public void tag(TvShow s, String tag) {
        this.tag(tag, "tvshow", s.getId());
    }

    @Override
    public void tagMovie(Movie m, String tag) {
        this.tag(tag, "movie", m.getId());
    }

    @Transactional
    public void tag(String tagName, String mediaType, int mediaId) {
        TagEntity tagEntity = this.getOrCreateTagEntity(tagName);
        List existing = this.tagLinkRepository.findAll((root, query, cb) -> cb.and(new Predicate[]{cb.equal((Expression)root.get("tagId"), (Object)tagEntity.getTagId()), cb.equal((Expression)root.get("mediaType"), (Object)mediaType), cb.equal((Expression)root.get("mediaId"), (Object)mediaId)}));
        switch (existing.size()) {
            case 0: {
                this.saveTagLink(mediaType, mediaId, tagEntity.getTagId());
                return;
            }
            case 1: {
                return;
            }
        }
        throw new IllegalStateException(existing.size() + " found for " + tagName);
    }

    @Override
    @Transactional
    public void tagMovies(Map<String, Set<Movie>> tagDefinitions) {
        Map<String, TagEntity> existingTags = StreamSupport.stream(this.tagRepository.findAll().spliterator(), false).collect(Collectors.toMap(TagEntity::getName, t -> t));
        tagDefinitions.forEach((tagName, movieSet) -> {
            TagEntity tagEntity = existingTags.computeIfAbsent((String)tagName, this::createTagEntity);
            movieSet.stream().filter(m -> !m.hasTag((String)tagName)).forEach(movie -> this.saveTagLink("movie", movie.getId(), tagEntity.getTagId()));
        });
    }

    @Transactional
    public void saveTagLink(String mediaType, int mediaId, int tagId) {
        TagLinkEntity tle = new TagLinkEntity();
        tle.setMediaId(mediaId);
        tle.setMediaType(mediaType);
        tle.setTagId(tagId);
        this.tagLinkRepository.save(tle);
    }

    @Transactional
    public TagEntity getOrCreateTagEntity(String tagName) {
        if (StringUtils.isBlank((CharSequence)tagName)) {
            throw new IllegalArgumentException("needs a name: " + tagName);
        }
        List existing = this.tagRepository.findAll((tagEntity, query, cb) -> cb.equal((Expression)tagEntity.get("name"), (Object)tagName));
        switch (existing.size()) {
            case 0: {
                return this.createTagEntity(tagName);
            }
            case 1: {
                return (TagEntity)existing.get(0);
            }
        }
        throw new IllegalStateException(existing.size() + " found for " + tagName);
    }

    @Transactional
    public TagEntity createTagEntity(String tagName) {
        TagEntity newTag = new TagEntity();
        newTag.setName(tagName);
        return (TagEntity)this.tagRepository.save(newTag);
    }

    @Override
    public List<IFileWrapper> getMovieShares() {
        return this.getShares("movies");
    }

    @Override
    public List<IFileWrapper> getTvShowShares() {
        return this.getShares("tvshows");
    }

    private List<IFileWrapper> getShares(String c) {
        return this.em.createQuery("select p from PathEntity p where p.parent is null and p.strContent = '" + c + "'", PathEntity.class).getResultList().stream().map(pathEntity -> this.mapper.convert((PathEntity)pathEntity)).collect(Collectors.toList());
    }
}

