/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.kodi.impl.andre;

import com.myapp.kodi.common.service.DomainObjectMapper;
import com.myapp.kodi.common.util.IFileWrapper;
import com.myapp.kodi.common.util.smb.SmbToLocalFileMapper;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class AndresSmbToLocalFileMapper
implements SmbToLocalFileMapper {
    private static final Logger logger = Logger.getLogger(AndresSmbToLocalFileMapper.class);
    private static final Map<String, String> SMB_TO_LOCAL;
    private static final Map<String, String> LOCAL_TO_SMB;
    private final DomainObjectMapper mapper = new DomainObjectMapper();

    @Override
    public File toLocalFile(IFileWrapper networkFile) {
        String path = networkFile.getPath();
        for (Map.Entry<String, String> entry : SMB_TO_LOCAL.entrySet()) {
            if (!path.startsWith(entry.getKey())) continue;
            path = path.replace(entry.getKey(), entry.getValue());
            break;
        }
        if (networkFile.getPath().equals(path)) {
            logger.warn((Object)("could not translate to file system: " + networkFile));
            return null;
        }
        return new File(path);
    }

    @Override
    public IFileWrapper toSmbFile(File localFile) {
        String path = localFile.getAbsolutePath();
        for (Map.Entry<String, String> entry : LOCAL_TO_SMB.entrySet()) {
            if (!path.startsWith(entry.getKey())) continue;
            path = path.replace(entry.getKey(), entry.getValue());
            break;
        }
        if (localFile.getPath().equals(path)) {
            logger.warn((Object)("could not translate to file system: " + localFile));
            return null;
        }
        return this.mapper.createFileWrapper(path);
    }

    static {
        String[][] mappings = new String[][]{{"smb://NAIROBI/av-content/_movies/", "/media/filestore/av-content/movies/"}, {"smb://NAIROBI/av-content/_series/", "/media/filestore/av-content/series/"}};
        HashMap<String, String> stl = new HashMap<String, String>();
        HashMap<String, String> lts = new HashMap<String, String>();
        for (Object[] objectArray : mappings) {
            boolean ltsMappingOk;
            boolean stlMappingOk = null == stl.put(objectArray[0], objectArray[1]);
            boolean bl = ltsMappingOk = null == lts.put(objectArray[1], objectArray[0]);
            if (stlMappingOk && ltsMappingOk) continue;
            throw new RuntimeException("duplicate mapping: " + Arrays.toString(objectArray));
        }
        SMB_TO_LOCAL = Collections.unmodifiableMap(stl);
        LOCAL_TO_SMB = Collections.unmodifiableMap(lts);
    }
}

