/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.kodi.common.util.smb;

import com.myapp.kodi.common.util.IFileWrapper;
import com.myapp.kodi.common.util.smb.SmbFileNode;
import com.myapp.kodi.common.util.smb.SmbTreeIterator;
import com.myapp.util.file.RecursiveTreeIterator;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SmbFileWrapper
implements IFileWrapper {
    private SmbFile smbFile;
    private transient String urlAsString = null;
    private NtlmPasswordAuthentication authentication;

    public SmbFileWrapper(String url, NtlmPasswordAuthentication authentication) {
        this.authentication = authentication;
        try {
            this.smbFile = new SmbFile(url, authentication);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(url + " - " + authentication, e);
        }
    }

    public SmbFileWrapper(SmbFile smbFile) {
        this.smbFile = smbFile;
    }

    public SmbFileWrapper(SmbFileWrapper smbFileWrapper) {
        this.authentication = smbFileWrapper.authentication;
        this.smbFile = new SmbFile(smbFileWrapper.getURL(), this.authentication);
    }

    @Override
    public String getName() {
        return this.smbFile.getName();
    }

    @Override
    public String getPath() {
        return this.smbFile.getPath();
    }

    @Override
    public String getParent() {
        return this.smbFile.getParent();
    }

    @Override
    public SmbFileWrapper getParentWrapped() {
        return new SmbFileWrapper(this.smbFile.getParent(), this.authentication);
    }

    public boolean exists() {
        try {
            return this.smbFile.exists();
        }
        catch (SmbException e) {
            throw new RuntimeException(this.smbFile.getName(), e);
        }
    }

    public boolean canRead() {
        try {
            return this.smbFile.canRead();
        }
        catch (SmbException e) {
            throw new RuntimeException(this.smbFile.getName(), e);
        }
    }

    public boolean canWrite() {
        try {
            return this.smbFile.canWrite();
        }
        catch (SmbException e) {
            throw new RuntimeException(this.smbFile.getName(), e);
        }
    }

    @Override
    public boolean isDirectory() {
        try {
            return this.smbFile.isDirectory();
        }
        catch (SmbException e) {
            throw new RuntimeException(this.smbFile.getName(), e);
        }
    }

    @Override
    public boolean isFile() {
        try {
            return this.smbFile.isFile();
        }
        catch (SmbException e) {
            throw new RuntimeException(this.smbFile.getName(), e);
        }
    }

    public boolean isHidden() {
        try {
            return this.smbFile.isHidden();
        }
        catch (SmbException e) {
            throw new RuntimeException(this.smbFile.getName(), e);
        }
    }

    public List<String> list() {
        try {
            if (!this.smbFile.isDirectory()) {
                return null;
            }
            return Arrays.asList(this.smbFile.list());
        }
        catch (SmbException e) {
            throw new RuntimeException(this.smbFile.getName(), e);
        }
    }

    @Override
    public List<IFileWrapper> listFiles() {
        try {
            if (!this.smbFile.isDirectory()) {
                return null;
            }
            return Stream.of(this.smbFile.listFiles()).map(SmbFileWrapper::new).collect(Collectors.toList());
        }
        catch (SmbException e) {
            throw new RuntimeException(this.smbFile.getPath(), e);
        }
    }

    @Override
    public long getLength() {
        try {
            return this.smbFile.length();
        }
        catch (SmbException e) {
            throw new RuntimeException(this.smbFile.getName(), e);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.smbFile.getInputStream();
    }

    public long getCreateTime() {
        try {
            return this.smbFile.createTime();
        }
        catch (SmbException e) {
            throw new RuntimeException(this.smbFile.getName(), e);
        }
    }

    public long getLastModifiedTime() {
        try {
            return this.smbFile.lastModified();
        }
        catch (SmbException e) {
            throw new RuntimeException(this.smbFile.getName(), e);
        }
    }

    @Override
    public URL getURL() {
        return this.smbFile.getURL();
    }

    @Override
    public String getURLAsString() {
        if (this.urlAsString == null) {
            this.urlAsString = this.getURL().toString();
        }
        return this.urlAsString;
    }

    public final String toString() {
        return this.getURL().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SmbFileWrapper)) {
            return false;
        }
        SmbFileWrapper that = (SmbFileWrapper)o;
        return new EqualsBuilder().append((Object)this.smbFile, (Object)that.smbFile).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.smbFile).toHashCode();
    }

    NtlmPasswordAuthentication getAuthentication() {
        return this.authentication;
    }

    @Override
    public Stream<IFileWrapper> streamChildrenRecursively() {
        return new SmbTreeIterator(new SmbFileNode(this)).stream().map(RecursiveTreeIterator.TreeNode::getValue);
    }
}

