/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.kodi.common.util.smb;

import com.myapp.kodi.common.util.IFileWrapper;
import com.myapp.kodi.common.util.smb.SmbFileWrapper;
import com.myapp.util.file.RecursiveTreeIterator;
import java.net.MalformedURLException;
import java.util.List;
import java.util.stream.Collectors;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbFile;

public class SmbFileNode
implements RecursiveTreeIterator.TreeNode<SmbFileWrapper>,
Comparable<SmbFileNode> {
    private String url;
    private NtlmPasswordAuthentication auth;

    public SmbFileNode(SmbFileWrapper smbFileWrapper) {
        this.url = smbFileWrapper.getURL().toString();
        this.auth = smbFileWrapper.getAuthentication();
    }

    public SmbFileNode(String url, NtlmPasswordAuthentication auth) {
        this.url = url;
        this.auth = auth;
    }

    public List<RecursiveTreeIterator.TreeNode<SmbFileWrapper>> getChildren() {
        SmbFileWrapper value = this.getValue();
        List<IFileWrapper> smbFiles = value.listFiles();
        if (smbFiles == null) {
            return null;
        }
        return smbFiles.stream().map(f -> new SmbFileNode(f.getURL().toString(), this.auth)).sorted().collect(Collectors.toList());
    }

    public SmbFileWrapper getValue() {
        try {
            return new SmbFileWrapper(new SmbFile(this.url, this.auth));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int compareTo(SmbFileNode o) {
        return this.getValue().compareTo(o.getValue());
    }
}

