/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.kodi.common.util.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.myapp.kodi.common.util.IFileWrapper;
import com.myapp.kodi.common.util.sftp.SftpConnectionManager;
import com.myapp.kodi.common.util.sftp.SftpFileNode;
import com.myapp.kodi.common.util.sftp.SftpTreeIterator;
import com.myapp.util.file.RecursiveTreeIterator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;

public class SftpFileWrapper
implements IFileWrapper {
    private static final Logger logger = Logger.getLogger(SftpFileWrapper.class);
    private SftpConnectionManager sftpConnectionManager;
    private String url;
    private transient URL cachedUrl = null;
    private List<ChannelSftp.LsEntry> cachedEntries = null;

    public SftpFileWrapper(SftpConnectionManager sftpConnectionManager, String url) {
        this.sftpConnectionManager = sftpConnectionManager;
        this.url = url;
    }

    private SftpFileWrapper(ChannelSftp.LsEntry entry, URL theUrl) {
        this.sftpConnectionManager = null;
        this.cachedEntries = Collections.singletonList(entry);
        String urlString = theUrl.toString();
        if (!urlString.endsWith("/")) {
            urlString = urlString + "/";
        }
        this.url = urlString + entry.getFilename();
    }

    SftpConnectionManager getSftpConnectionManager() {
        return this.sftpConnectionManager;
    }

    @Override
    public String getName() {
        String urlPath = this.getPath();
        int lastSlash = urlPath.lastIndexOf(47);
        return urlPath.substring(lastSlash + 1);
    }

    @Override
    public String getPath() {
        URL theUrl = this.getURL();
        String urlPath = theUrl.getPath();
        if (urlPath.endsWith("/")) {
            urlPath = urlPath.substring(0, urlPath.length() - 1);
        }
        if (urlPath.startsWith("//")) {
            urlPath = urlPath.substring(2);
        }
        return urlPath;
    }

    @Override
    public String getParent() {
        String urlPath = this.getPath();
        int lastSlash = urlPath.lastIndexOf(47);
        return urlPath.substring(0, lastSlash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ls() {
        SftpFileWrapper sftpFileWrapper = this;
        synchronized (sftpFileWrapper) {
            if (this.cachedEntries != null) {
                return;
            }
            ChannelSftp sftp = this.sftpConnectionManager.aquireSftpChannel(this.url);
            String path = this.getPath();
            try {
                Vector lsResult = sftp.ls(path);
                this.cachedEntries = lsResult.stream().map(e -> (ChannelSftp.LsEntry)e).sorted().collect(Collectors.toList());
            }
            catch (SftpException e2) {
                throw new RuntimeException("path: " + path, e2);
            }
            finally {
                this.sftpConnectionManager.passivateSftpChannel(this.url, sftp);
            }
        }
    }

    @Override
    public boolean isDirectory() {
        this.ls();
        Optional<ChannelSftp.LsEntry> dot = this.cachedEntries.stream().filter(e -> e.getFilename().equals(".")).findAny();
        return dot.isPresent() && dot.get().getAttrs().isDir();
    }

    @Override
    public boolean isFile() {
        this.ls();
        Optional<ChannelSftp.LsEntry> dot = this.cachedEntries.stream().filter(e -> e.getFilename().equals(".")).findAny();
        ChannelSftp.LsEntry single = null;
        if (dot.isPresent()) {
            single = dot.get();
        } else if (this.cachedEntries.size() == 1) {
            single = this.cachedEntries.get(0);
        }
        return single != null && single.getAttrs().isReg();
    }

    public String toString() {
        return this.url;
    }

    @Override
    public List<IFileWrapper> listFiles() {
        this.ls();
        List<IFileWrapper> result = this.cachedEntries.stream().map(lse -> new SftpFileWrapper((ChannelSftp.LsEntry)lse, this.getURL())).collect(Collectors.toList());
        return result;
    }

    @Override
    public long getLength() {
        if (this.isFile()) {
            return this.cachedEntries.get(0).getAttrs().getSize();
        }
        return 0L;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return null;
    }

    @Override
    public URL getURL() {
        if (this.cachedUrl == null) {
            try {
                this.cachedUrl = new URL(this.url);
                return this.cachedUrl;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return this.cachedUrl;
    }

    @Override
    public String getURLAsString() {
        return this.url;
    }

    @Override
    public IFileWrapper getParentWrapped() {
        this.ls();
        if (this.isFile() || this.isDirectory()) {
            String path = this.getURL().toString();
            String name = this.getName();
            String parentPath = path.replaceAll("/" + Pattern.quote(name) + "/?$", "");
            return new SftpFileWrapper(this.sftpConnectionManager, parentPath);
        }
        return null;
    }

    @Override
    public Stream<IFileWrapper> streamChildrenRecursively() {
        if (this.isFile()) {
            return Stream.of(this);
        }
        return new SftpTreeIterator(new SftpFileNode(this)).stream().map(RecursiveTreeIterator.TreeNode::getValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SftpFileWrapper)) {
            return false;
        }
        SftpFileWrapper that = (SftpFileWrapper)o;
        return new EqualsBuilder().append((Object)this.getURL(), (Object)that.getURL()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getURL()).toHashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        SftpConnectionManager sftpConnectionManager = new SftpConnectionManager();
        File knownHostsFile = new File(new File(new File(System.getProperty("user.home")), ".ssh"), "known_hosts");
        sftpConnectionManager.setKnownHostsFile(knownHostsFile);
        Session session = null;
        try {
            JSch ssh = new JSch();
            session = ssh.getSession("kodiftp", "nairobi", 22);
            session.setPassword("seDiP93cF");
            SftpFileWrapper sftpDir = new SftpFileWrapper(sftpConnectionManager, "sftp://kodiftp:seDiP93cF@nairobi:22//_series/ENGLISH/bobs_burgers/season_03/");
            List<IFileWrapper> files = sftpDir.listFiles();
            files.forEach(f -> System.out.println(f.getURL()));
            SftpFileWrapper sftpFile = new SftpFileWrapper(sftpConnectionManager, "sftp://kodiftp:seDiP93cF@nairobi:22//_series/ENGLISH/bobs_burgers/season_03/S03E09 - God Rest Ye Merry Gentle-Ma.mp4");
            List<IFileWrapper> file = sftpFile.listFiles();
            file.forEach(f -> System.out.println(f.getURL()));
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
    }
}

